<?php
// $Id: weblinks_template.php,v 1.5 2006/09/16 04:11:52 ohwada Exp $

// 2006-07-30 K.OHWADA
// BUG 4169: not show total in index

// 2006-05-15 K.OHWADA
// use new handler

// 2006-03-26 K.OHWADA
// REQ 3807: Description in main page

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication
// move from include/functions

//================================================================
// WebLinks Module
// 2004/01/23 K.OHWADA
//================================================================

//---------------------------------------------------------
// TODO
// global $xoopsTpl, $xoopsConfig, $xoopsModule, $xoopsUser
// class language_convert get_country()
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_template') ) 
{

//=========================================================
// class weblinks_template
//=========================================================
class weblinks_template
{
// handler
	var $_link_handler;
	var $_category_handler;
	var $_atomfeed_handler;
	var $_config_basic_handler;
	var $_linkitem_handler;
	var $_menu;
	var $_system;

// constant
	var $_MODULE_NAME_DEFAULT = "Web Links";

// dirname
	var $_dirname;
	var $_template_header;
	var $_template_link_single;

// system variable
	var $_module_name;
	var $_xoops_language;
	var $_country;
	var $_happy_linux_url;

// local variable
	var $_time_start = 0;
	var $_time_prev  = 0;

// config
	var $_conf_index_desc;
	var $_conf_topten_links;
	var $_conf_logoshow;
	var $_conf_titleshow;
	var $_conf_link_image_use;
	var $_conf_list_image_use;
	var $_conf_use_ratelink;
	var $_conf_use_brokenlink;
	var $_conf_recommend_pri;
	var $_conf_mutual_pri;
	var $_conf_rss_use;

// search
	var $_search_query = '';
	var $_search_andor = 'AND';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_template( $dirname )
{
	$this->_dirname = $dirname ;

// handler
	$this->_config_basic_handler  =& weblinks_get_handler( 'config2_basic',  $dirname );
	$this->_linkitem_handler      =& weblinks_get_handler( 'linkitem',       $dirname );
	$this->_link_handler          =& weblinks_get_handler( 'link',           $dirname );
	$this->_atomfeed_handler      =& weblinks_get_handler( 'atomfeed',       $dirname );
	$this->_menu   =& weblinks_menu::getInstance($dirname);
	$this->_system =& weblinks_system::getInstance();
	$lang          =& weblinks_language_convert::getInstance();

	$conf = $this->_config_basic_handler->get_cached();
	$this->_conf_index_desc       = $conf['index_desc'];
	$this->_conf_topten_links     = $conf['topten_links'];
	$this->_conf_logoshow         = $conf['logoshow'];
	$this->_conf_titleshow        = $conf['titleshow'];
	$this->_conf_link_image_use   = $conf['link_image_use'];
	$this->_conf_list_image_use   = $conf['list_image_use'];
	$this->_conf_use_ratelink     = $conf['use_ratelink'];
	$this->_conf_use_brokenlink   = $conf['use_brokenlink'];
	$this->_conf_recommend_pri    = $conf['recommend_pri'];
	$this->_conf_mutual_pri       = $conf['mutual_pri'];
	$this->_conf_rss_use          = $conf['rss_use'];

// system
	$this->_module_name    = $this->_system->get_module_name();
	$this->_xoops_language = $this->_system->get_language();

// language
	$this->_country         = $lang->get_country();
	$this->_happy_linux_url = $lang->get_happy_linux_url();

// template
	$this->_template_header      = 'db:'.$dirname.'_header.html';
	$this->_template_link_single = 'db:'.$dirname.'_link_single.html';
	$this->_template_links_list  = 'db:'.$dirname.'_links_list.html';

}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new weblinks_template( $dirname );
	}

	return $instance;
}

//-------------------------------------------------------------------
// assign template
//-------------------------------------------------------------------
function assignPageTitle( $title, $format=true )
{
	global $xoopsTpl;

	$module_name = htmlspecialchars($this->_module_name, ENT_QUOTES);

	if ($format)
	{
		$title = htmlspecialchars($title, ENT_QUOTES);
	}

	$pagetitle = $module_name.' - '.$title;
	$xoopsTpl->assign('xoops_pagetitle', $pagetitle);
}

function assignIndex()
{
	global $xoopsTpl;
	$this->_assign_header_common( $xoopsTpl );
}

function assignHeader( $flag=false )
{
	global $xoopsTpl;
	$header = $this->fetch_header( $flag );
	$xoopsTpl->assign('weblinks_header', $header);

// BUG 4169: not show total in index
	$this->_assign_header_total( $xoopsTpl );
}

function assignDisplayLink()
{
	global $xoopsTpl;
	$this->_assign_link_common( $xoopsTpl );
}

function fetch_header( $flag=false )
{
	$tpl = new XoopsTpl();
	$this->_assign_header_common( $tpl );
	$this->_assign_header_total(  $tpl );

// REQ 3807: Description in main page
	if ( $flag && $this->_conf_index_desc )
	{
		$tpl->assign('index_desc', $this->_conf_index_desc );
	}
	else
	{
		$tpl->assign('index_desc', '');
	}

	$text = $tpl->fetch( $this->_template_header );
	return $text;
}

function fetch_link_single( $link )
{
	$tpl = new XoopsTpl();
	$this->_assign_link_common( $tpl );
	$tpl->assign('link', $link);
	$text = $tpl->fetch( $this->_template_link_single );
	return $text;
}

function fetch_links_full( $links )
{
	$text = '';
	foreach ($links as $link) 
	{
		$text .= $this->fetch_link_single( $link );
	}
	return $text;
}

function fetch_links_list( $links )
{
	$tpl = new XoopsTpl();
	$this->_assign_link_common( $tpl );

	if ( is_array($links) )
	{
		foreach ($links as $link) 
		{
			$tpl->append('links', $link);
		}
	}

	$text = $tpl->fetch( $this->_template_links_list );
	return $text;
}

function set_search($query, $andor)
{
	$this->_search_query = htmlspecialchars($query, ENT_QUOTES);
	$this->_search_andor = $andor;
}

//=========================================================
// private
//=========================================================

function _assign_header_common( &$tpl )
{

// system parameter
	$tpl->assign('xoops_url',      XOOPS_URL );
	$tpl->assign('xoops_language', $this->_xoops_language );
	$tpl->assign('module_name',    $this->_module_name );
	$tpl->assign('dirname',        $this->_dirname );

// menu show
	$tpl->assign('show_submit',        $this->_menu->show_submit() );
	$tpl->assign('show_site_popular',  $this->_menu->show_hits() );
	$tpl->assign('show_site_higtrate', $this->_menu->show_rating() );

// config
	$tpl->assign('logoshow',  $this->_conf_logoshow );
	$tpl->assign('titleshow', $this->_conf_titleshow );
	$tpl->assign('show_site_recommend', $this->_conf_recommend_pri );
	$tpl->assign('show_site_mutual',    $this->_conf_mutual_pri );
	$tpl->assign('show_site_rss',  $this->_conf_rss_use );
	$tpl->assign('show_atomfeed',  $this->_conf_rss_use );

	$tpl->assign('happy_linux_url',  $this->_happy_linux_url );

// search
	list($and, $or, $exact) = $this->_get_search_andor();
	$tpl->assign('search_and',     $and);
	$tpl->assign('search_or',      $or);
	$tpl->assign('search_exact',   $exact);
	$tpl->assign('search_query',   $this->_search_query);

// REQ 3110: Add in this category
	if ( isset($_GET['cid']) )
	{
		$tpl->assign('cid', intval($_GET['cid']) );
	}

// --- lang ---
	$tpl->assign('lang_home',     _HOME);
	$tpl->assign('lang_search',   _WLS_SEARCH);
	$tpl->assign('lang_all',      _SR_ALL);
	$tpl->assign('lang_any',      _SR_ANY);
	$tpl->assign('lang_exact',    _SR_EXACT);
	$tpl->assign('lang_nomatch',  _WLS_NOMATCH);

// guidance bar
	$tpl->assign('lang_main',           _WLS_MAIN);
	$tpl->assign('lang_submitlink',     _WLS_SUBMIT_NEW_LINK);
	$tpl->assign('lang_site_popular',   _WLS_SITE_POPULAR);	
	$tpl->assign('lang_site_highrate',  _WLS_SITE_HIGHRATE);
	$tpl->assign('lang_site_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_site_mutual',    _WLS_SITE_MUTUAL);

// second guidance bar
	$tpl->assign('lang_catlist',        _WLS_CATLIST);
	$tpl->assign('lang_site_rss',       _WLS_SITE_RSS);
	$tpl->assign('lang_atomfeed',       _WLS_ATOMFEED);
	$tpl->assign('lang_site_random',    _WLS_SITE_RANDOM);

// index.php
	$tpl->assign('lang_new_sitelist',   _WLS_NEW_SITELIST);
	$tpl->assign('lang_new_atomfeed',   _WLS_NEW_ATOMFEED);


}

function _assign_header_total( &$tpl )
{
	$total_site_recommend = $this->_link_handler->get_count_by_mark('recommend');
	$total_site_mutual    = $this->_link_handler->get_count_by_mark('mutual');
	$total_site_rss       = $this->_link_handler->get_count_rss_flag();
	$total_atomfeed       = $this->_atomfeed_handler->getCount();
	$total_site_topten    = "top".intval( $this->_conf_topten_links );

	$tpl->assign('total_site_recommend', $total_site_recommend);
	$tpl->assign('total_site_mutual',    $total_site_mutual);
	$tpl->assign('total_site_rss',       $total_site_rss);
	$tpl->assign('total_atomfeed',       $total_atomfeed);

// BUG 3111: timeout occurs in popular site if many top categories
	$tpl->assign('total_site_topten', $total_site_topten);
}

function _get_search_andor()
{
	$and     = '';
	$or      = '';
	$exact   = '';

	if ($this->_search_andor == 'exact') 
	{
		$exact = "selected='selected'";
	}
	elseif ($this->_search_andor == 'OR')
	{
		$or  = "selected='selected'";
	}
	else
	{
		$and = "selected='selected'";
	}

	return array($and, $or, $exact);
}

function _assign_link_common( &$tpl )
{
	$this->_linkitem_handler->load();

// system parameter
	$tpl->assign('xoops_url',       XOOPS_URL );
	$tpl->assign('xoops_language',  $this->_xoops_language );
	$tpl->assign('is_module_admin', $this->_system->is_module_admin() );
	$tpl->assign('module_name',     $this->_module_name );
	$tpl->assign('dirname',         $this->_dirname );
	$tpl->assign('country',         $this->_country );

// show ratelink
	$show_ratelink = false;
	$show_rating   = false;
	if ( $this->_menu->show_rating() )
	{
		$show_rating = true;

		$has_auth_ratelink = $this->_config_basic_handler->has_auth_ratelink();
		if ( $has_auth_ratelink )
		{
			$show_ratelink = true;
		}
	}

// menu show
	$tpl->assign('show_hits',       $this->_menu->show_hits() );
	$tpl->assign('show_rating',     $show_rating );
	$tpl->assign('show_ratelink',   $show_ratelink );
	$tpl->assign('show_brokenlink', $this->_conf_use_brokenlink );
	$tpl->assign('show_atomfeed',   $this->_conf_rss_use );

	$tpl->assign('dirname',    $this->_dirname);

// index
	$tpl->assign('lang_more',            _WLS_MORE);
	$tpl->assign('lang_image_new',       _WLS_SITE_NEW);
	$tpl->assign('lang_image_update',    _WLS_SITE_UPDATE);
	$tpl->assign('lang_image_popular',   _WLS_SITE_POPULAR);
	$tpl->assign('lang_image_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_image_mutual',    _WLS_SITE_MUTUAL);

// singlelink
	$tpl->assign('lang_visit' ,          _WLS_VISIT);
	$tpl->assign('lang_promoter',        _WLS_PROMOTER);
	$tpl->assign('lang_modify',          _WLS_MODIFY);
	$tpl->assign('lang_editthislink' ,   _WLS_EDITTHISLINK);
	$tpl->assign('lang_ratethissite',    _WLS_RATETHISSITE);
	$tpl->assign('lang_reportbroken',    _WLS_REPORTBROKEN);
	$tpl->assign('lang_tellafriend',     _WLS_TELLAFRIEND);
	$tpl->assign('lang_print',          _PRINT);

	$lang_title        = $this->_get_title_by_name('title');
	$lang_url          = $this->_get_title_by_name('url');
	$lang_description  = $this->_get_title_by_name('description');
	$lang_category     = $this->_get_title_by_name('cat');
	$lang_banner       = $this->_get_title_by_name('banner');
	$lang_name         = $this->_get_title_by_name('name');
	$lang_mail         = $this->_get_title_by_name('mail');
	$lang_zip          = $this->_get_title_by_name('zip');
	$lang_state        = $this->_get_title_by_name('state');
	$lang_city         = $this->_get_title_by_name('city');
	$lang_addr         = $this->_get_title_by_name('addr');
	$lang_addr2        = $this->_get_title_by_name('addr2');
	$lang_tel          = $this->_get_title_by_name('tel');
	$lang_fax          = $this->_get_title_by_name('fax');
	$lang_etc1         = $this->_get_title_by_name('etc1');
	$lang_etc2         = $this->_get_title_by_name('etc2');
	$lang_etc3         = $this->_get_title_by_name('etc3');
	$lang_etc4         = $this->_get_title_by_name('etc4');
	$lang_etc5         = $this->_get_title_by_name('etc5');
	$lang_usercomment  = $this->_get_title_by_name('usercomment');
	$lang_admincomment = $this->_get_title_by_name('admincomment');
	$lang_lastupdate   = $this->_get_title_by_name('time_update');
	$lang_hits         = $this->_get_title_by_name('hits');
	$lang_rating       = $this->_get_title_by_name('rating');
	$lang_votes        = $this->_get_title_by_name('votes');
	$lang_comments     = $this->_get_title_by_name('comments');

// the item which user can set up 
	$tpl->assign('lang_category' ,       $lang_category );
	$tpl->assign('lang_title',           $lang_title );
	$tpl->assign('lang_url',             $lang_url );
	$tpl->assign('lang_description',     $lang_description );
	$tpl->assign('lang_banner',          $lang_banner );
	$tpl->assign('lang_name',            $lang_name );
	$tpl->assign('lang_mail',            $lang_mail);
	$tpl->assign('lang_zip',             $lang_zip );
	$tpl->assign('lang_state',           $lang_state );
	$tpl->assign('lang_city',            $lang_city );
	$tpl->assign('lang_addr',            $lang_addr );
	$tpl->assign('lang_addr2',           $lang_addr2 );
	$tpl->assign('lang_tel',             $lang_tel );
	$tpl->assign('lang_fax',             $lang_fax );
	$tpl->assign('lang_etc1',            $lang_etc1 );
	$tpl->assign('lang_etc2',            $lang_etc2 );
	$tpl->assign('lang_etc3',            $lang_etc3 );
	$tpl->assign('lang_etc4',            $lang_etc4 );
	$tpl->assign('lang_etc5',            $lang_etc5 );
	$tpl->assign('lang_usercomment',     $lang_usercomment );

// the item which admin can set up 
	$tpl->assign('lang_admincommnet',    $lang_admincomment );

// the item which module can set up 
	$tpl->assign('lang_lastupdate',      $lang_lastupdate );
	$tpl->assign('lang_hits',            $lang_hits );
	$tpl->assign('lang_rating',          $lang_rating );
	$tpl->assign('lang_votes',           $lang_votes );
	$tpl->assign('lang_comments',        $lang_comments );

// banner
	$tpl->assign('link_image_use', $this->_conf_link_image_use );
	$tpl->assign('list_image_use', $this->_conf_list_image_use );
}

function _get_title_by_name( $name )
{
	$title = $this->_linkitem_handler->get_cache_by_name_key($name, 'title');
	$title = htmlspecialchars($title, ENT_QUOTES);
	return $title;
}

// --- class end ---
}

// === class end ===
}

?>