<?php
// $Id: weblinks_link_handler.php,v 1.4 2006/07/15 12:11:41 ohwada Exp $

// 2006-07-15 K.OHWADA
// BUG 4130: cannot show recommend mark

// 2006-06-10 K.OHWADA
// BUG 4030: cannot change recommend, mutual
//   add set_checkbox()

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base
// NOT use other handler

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// this file contain 3 class
//   weblinks_link_base
//   weblinks_link 
//   weblinks_link_handler
// 2004/01/14 K.OHWADA
//=========================================================

//---------------------------------------------------------
// TODO
// global $xoopsUser
// class language_convert convert_telafriend_xx()
//---------------------------------------------------------

// === class begin ===
if( !class_exists('weblinks_link_handler') ) 
{

//=========================================================
// class weblinks_link_base
//=========================================================
class weblinks_link_base extends weblinks_object
{

	var $_conf_desc_option = array(
		'dohtml'   => false,
		'dosmiley' => false,
		'doxcode'  => false,
		'doimage'  => false,
		'dobr'     => false,
	);

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_base()
{
	$this->weblinks_object();
}

//---------------------------------------------------------
// system
//---------------------------------------------------------
function get_system_param()
{
	global $xoopsUser;

	$uid   = 0;
	$uname = '';
	$email = '';

	if ( is_object($xoopsUser) )
	{
		$uid   = $xoopsUser->getVar('uid');
		$uname = $xoopsUser->getVar('uname');
		$email = $xoopsUser->getVar('email');
	}

	return array($uid, $uname, $email);
}

//---------------------------------------------------------
// set var
//---------------------------------------------------------
function set_var_key(&$post, $key)
{
	if ( isset($post[$key]) )
	{
		$this->setVar( $key, $post[$key] );
	}
}

function set_uid(&$post)
{
	list($uid, $name, $mail) = $this->get_system_param();

	if ( isset($post['uid']) )
	{
		$uid = $post['uid'];
	}

	$this->setVar('uid', $uid);
}

function set_desc(&$post)
{
	if ( isset($post['description']) )
	{
		$this->setVar( 'description', $post['description'] );
	}
	elseif ( isset($post['description_text']) )
	{
		$this->setVar( 'description', $post['description_text'] );
	}
}

function set_desc_option(&$post, $key)
{
	$val = 0;

	if ( $this->_conf_desc_option[$key] && isset($post[$key]) )
	{
		$val = $post[$key];
	}

	$this->setVar( $key, $val );
}

function set_conf_desc_option($arr)
{
	$this->_conf_desc_option = $arr;
}

// BUG 4030: cannot change recommend, mutual
function set_checkbox( &$post, $key )
{
	$val = 0;

	if ( isset($post[$key]) )
	{
		$val = $post[$key];
	}

	$this->setVar( $key, $val );
}

//---------------------------------------------------------
// get var
//---------------------------------------------------------
function description_disp()
{
	$dohtml   = $this->get('dohtml');
	$dosmiley = $this->get('dosmiley');
	$doxcode  = $this->get('doxcode');
	$doimage  = $this->get('doimage');
	$dobr     = $this->get('dobr');

	$text = $this->getVarTextShow('description', $dohtml, $dosmiley, $doxcode, $doimage, $dobr );
	return $text;
}

function time_create($format='l', $timeoffset='')
{
	$time = $this->get('time_create');
	$ret = formatTimestamp($time, $format, $timeoffset);
	return $ret;
}

function time_update($format='l', $timeoffset='')
{
	$time = $this->get('time_update');
	$ret = formatTimestamp($time, $format, $timeoffset);
	return $ret;
}

function rss_update($format='l', $timeoffset='')
{
	$time = $this->get('rss_update');
	$ret = formatTimestamp($time, $format, $timeoffset);
	return $ret;
}

function votes_disp()
{
	$votes = $this->get('votes');

	if ($votes == 1) 
	{
		$votes_disp = _WLS_ONEVOTE;
	} 
	else
	{
		$votes_disp = sprintf(_WLS_NUMVOTES, $votes);
	}
	return $votes_disp;
}

function rating_disp()
{
	$DECIMALS = 2;
	$rating = $this->get('rating');
	$ret = number_format($rating, $DECIMALS);
	return $ret;
}

function addr_encode()
{
// bug fix: Mapfan disregards a space or subsequent ones. 

	$state = $this->get('state');
	$city  = $this->get('city');
	$addr  = $this->get('addr');
	$addr2 = $this->get('addr2');

	$flag_addr   = 0;	
	$addr_encode = '';

	if ( $state || $city || $addr || $addr2 )
	{
		$flag_addr = 1;	
		$addr3 = $state . $city . $addr;
		$addr_encode = urlencode( $addr3 );
	}

	return array($flag_addr, $addr_encode); 
}

function name_mail_disp()
{
	$name     = $this->get('name');
	$mail     = $this->get('mail');
	$nameflag = $this->get('nameflag');
	$mailflag = $this->get('mailflag');

	$name_disp = '';
	$mail_disp = '';

	if ( $nameflag && $name && $mailflag && $mail )
	{
		$name_disp = $this->getVar('name');
		$mail_disp = $this->getVar('mail');
	}
	elseif ( $mailflag && $mail )
	{
		$name_disp = 'Email';
		$mail_disp = $this->getVar('mail');
	}
	elseif ( $nameflag && $name )
	{
		$name_disp = $this->getVar('name');
	}

	return array($name_disp, $mail_disp);
}

function name_edit_for_others()
{
	$nameflag = $this->get('nameflag');

	$name_edit     = '';
	$nameflag_edit = 0;

	if ($nameflag == 1)
	{
		$name_edit     = $this->getVar('name');
		$nameflag_edit = 1;
	}

	return array($name_edit, $nameflag_edit);
}

function mail_edit_for_others()
{
	$mailflag = $this->get('mailflag');

	$mail_edit     = '';
	$mailflag_edit = 0;

	if ($mailflag == 1)
	{
		$mail_edit     =  $this->getVar('name');
		$mailflag_edit = 1;
	}

	return array($mail_edit, $mailflag_edit);
}



//---------------------------------------------------------
// check
//---------------------------------------------------------
function isset_rss_flag()
{
	$rss_url  = $this->get('rss_url');
	$rss_flag = $this->get('rss_flag');

	if ( empty($rss_url) )
	{
		return false;
	}
	
	if ( ($rss_flag != 1) && ($rss_flag != 2) )
	{
		return false;
	}

	return true;
}

//---------------------------------------------------------
// cid array for modify
//---------------------------------------------------------
function cid_array()
{
	$cids = $this->get('cids');
	$arr  = $this->_convert_string_to_array($cids);
	return $arr;
}

function set_cids( &$post )
{
	$arr = $this->get_cid_array_by_post($post);
	$val = $this->set_cids_by_cid_array($arr);
	$this->setVar( 'cids', $val );
}

function set_cids_by_cid_array( $arr )
{
	$val = $this->_convert_array_to_string( $arr );
	$this->setVar( 'cids', $val );
}

function get_cid_array_by_post( &$post )
{
	$arr = array();

	if ( isset($post['cid']) )
	{
		$arr = $this->_build_unique_cid_array( $post['cid'] );
	}

	return $arr;
}

function _build_unique_cid_array( $cid_arr_in )
{
	$cid_arr_out = array();

	if ( is_array($cid_arr_in) )
	{
		foreach ($cid_arr_in as $cid)
		{
			$cid = intval($cid);
			if ($cid != 0)
			{
				$cid_arr_out[] = $cid;
			}
		}
	}
	else
	{
		$cid = intval($cid_arr_in);
		if ($cid != 0)
		{
			$cid_arr_out[] = $cid;
		}
	}

	$cid_arr_out = array_unique($cid_arr_out);

	return $cid_arr_out;
}

//---------------------------------------------------------
// convert array to string
// array($a, $b, $c)  ==> $a & $b & $c
//---------------------------------------------------------
function _convert_array_to_string($arr, $pattern='&')
{
	if ( is_array($arr) )
	{
		$str = $pattern;

		foreach ($arr as $value)
		{
			$str .= intval($value).$pattern;
		}
	}
	elseif ( is_int($arr) )
	{
		$str = $pattern.intval($arr).$pattern;
	}
	else
	{
		$str = $arr;
	}

	return $str;
}

function _convert_string_to_array($str, $pattern='&')
{
	$str_arr = split($pattern, $str);

	$i = 0;	
	$arr = array();
	foreach ($str_arr as $value)
	{
		$value = trim($value);

		if ($value == '')  continue;

		$arr[$i++] = $value;
	}

	return $arr;
}

//---------------------------------------------------------
// XOOPS user
//---------------------------------------------------------
function user_name_mail( $format='n' )
{
	$uid   = $this->get('uid');
	$title = $this->get('title');
	$name  = $this->get('name');
	$mail  = $this->get('mail');

	list($system_uname, $system_email) = $this->system_uname_email($format);

	if ($name)
	{
		$user_name = $name;
	}
	else
	{
		$user_name = $title;
	}

	$user_mail = '';
	if ($mail)
	{
		$user_mail = $mail;
	}
	elseif (($uid > 1) && $system_email)
	{
		$user_mail = $system_email;
	}

	return array($user_name, $user_mail);
}

function system_uname_email( $format='n' )
{
	$uname = '';
	$email = '';

	$uid = $this->get('uid');
	$user_handler =& xoops_gethandler('user');

	$user_obj = $user_handler->get( $uid );
	if ( is_object($user_obj) )
	{
		$uname = $user_obj->getVar( 'uname', $format );
		$email = $user_obj->getVar( 'email', $format );
	}

	return array($uname, $email);
}

// --- class end ---
}

//=========================================================
// class weblinks_link
//=========================================================
class weblinks_link extends weblinks_link_base
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link()
{
	$this->weblinks_link_base();

	$this->initVar('lid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('uid',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('cids',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('title',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('url',    XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('banner', XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('description',  XOBJ_DTYPE_TEXT);
	$this->initVar('name',     XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('nameflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mail',     XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('mailflag', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('company',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('addr',     XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('tel',      XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('search',     XOBJ_DTYPE_TEXT);
	$this->initVar('passwd',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('admincomment',   XOBJ_DTYPE_TEXT);
	$this->initVar('mark',         XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('time_create',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('time_update',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('hits',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rating',   XOBJ_DTYPE_FLOAT, 0.0, false);
	$this->initVar('votes',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('comments', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('width',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('height',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('recommend',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('mutual',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('broken',     XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_url',    XOBJ_DTYPE_URL, null, false, 255);
	$this->initVar('rss_flag',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('rss_xml',    XOBJ_DTYPE_TEXT);
	$this->initVar('rss_update', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('usercomment',  XOBJ_DTYPE_TEXT);
	$this->initVar('zip',    XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('state',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('city',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('addr2',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('fax',    XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('dohtml',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('dosmiley', XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doxcode',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('doimage',  XOBJ_DTYPE_INT, 1, false);
	$this->initVar('dobr',     XOBJ_DTYPE_INT, 1, false);
	$this->initVar('etc1',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('etc2',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('etc3',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('etc4',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('etc5',   XOBJ_DTYPE_STRING, null, false, 255);
}

//---------------------------------------------------------
// set var
//---------------------------------------------------------
function assign_vars_post( &$post )
{
	$this->set_var_key($post, 'lid');
	$this->set_var_key($post, 'cids');
	$this->set_var_key($post, 'title');
	$this->set_var_key($post, 'name');
	$this->set_var_key($post, 'nameflag');
	$this->set_var_key($post, 'mail');
	$this->set_var_key($post, 'mailflag');
	$this->set_var_key($post, 'company');
	$this->set_var_key($post, 'addr');
	$this->set_var_key($post, 'tel');
	$this->set_var_key($post, 'search');
	$this->set_var_key($post, 'passwd');
	$this->set_var_key($post, 'admincomment');
	$this->set_var_key($post, 'mark');
	$this->set_var_key($post, 'time_create');
	$this->set_var_key($post, 'time_update');
	$this->set_var_key($post, 'hits');
	$this->set_var_key($post, 'rating');
	$this->set_var_key($post, 'votes');
	$this->set_var_key($post, 'comments');
	$this->set_var_key($post, 'width');
	$this->set_var_key($post, 'height');

// BUG 4030: cannot change recommend, mutual
//	$this->set_var_key($post, 'recommend');
//	$this->set_var_key($post, 'mutual');

	$this->set_var_key($post, 'broken');
	$this->set_var_key($post, 'rss_flag');
	$this->set_var_key($post, 'rss_xml');
	$this->set_var_key($post, 'rss_update');
	$this->set_var_key($post, 'usercomment');
	$this->set_var_key($post, 'zip');
	$this->set_var_key($post, 'state');
	$this->set_var_key($post, 'city');
	$this->set_var_key($post, 'addr2');
	$this->set_var_key($post, 'fax');
	$this->set_var_key($post, 'etc1');
	$this->set_var_key($post, 'etc2');
	$this->set_var_key($post, 'etc3');
	$this->set_var_key($post, 'etc4');
	$this->set_var_key($post, 'etc5');
	$this->set_var_key($post, 'url');
	$this->set_var_key($post, 'banner');
	$this->set_var_key($post, 'rss_url');

	$this->set_uid($post);
	$this->set_desc($post);

// after set_conf_desc_option()
	$this->set_desc_option($post, 'dohtml');
	$this->set_desc_option($post, 'dosmiley');
	$this->set_desc_option($post, 'doxcode');
	$this->set_desc_option($post, 'doimage');
	$this->set_desc_option($post, 'dobr');

}

//---------------------------------------------------------
// default value
//---------------------------------------------------------
function &build_default( $format='n' )
{
	$URL_DEFALUT      = 'http://';
	$RSS_FLAG_DEFALUT = 3;	// auto discovery

	list($uid, $name, $mail) = $this->get_system_param();

	$this->setVar('uid',      $uid);
	$this->setVar('name',     $name);
	$this->setVar('mail',     $mail);
	$this->setVar('url',      $URL_DEFALUT);
	$this->setVar('banner',   $URL_DEFALUT);
	$this->setVar('rss_url',  $URL_DEFALUT);
	$this->setVar('rss_flag', $RSS_FLAG_DEFALUT);

	$arr =& $this->getVarAll($format);
	return $arr;
}

//---------------------------------------------------------
// show mode
//---------------------------------------------------------
function &build_show()
{
	$arr_db   =& $this->getVarAll('s');
	$arr_cont =  $this->build_show_items('s');
	$arr_out  =  array_merge($arr_db, $arr_cont);
	$arr_out['description'] = $this->description_disp();

	return $arr_out;
}

//---------------------------------------------------------
// item
//---------------------------------------------------------
function build_show_items( $format='n' )
{
	$create   = $this->time_create('m');
	$create_s = $this->time_create('s');
	$update   = $this->time_update('m');
	$update_s = $this->time_update('s');

	list($flag_addr, $addr_encode) = $this->addr_encode();
	list($name_disp, $mail_disp)   = $this->name_mail_disp( $format );

	$arr_out = array(
		'flag_addr'        => $flag_addr,
		'addr_encode'      => $addr_encode,
		'create'           => $create,
		'create_short'     => $create_s,
		'update'           => $update,
		'update_short'     => $update_s,
		'votes_disp'       => $this->votes_disp(),
		'rating_disp'      => $this->rating_disp(),
		'name_disp'        => htmlspecialchars($name_disp, ENT_QUOTES),
		'mail_disp'        => htmlspecialchars($mail_disp, ENT_QUOTES),

// BUG 4130: cannot show recommend mark
		'flag_recommend'   => $this->getVar('recommend'),
		'flag_mutual'      => $this->getVar('mutual'),
	);

	return $arr_out;
}

// --- class end ---
}

//=========================================================
// class weblinks_link_handler
// NOT use other handler
//=========================================================
class weblinks_link_handler extends weblinks_object_handler
{
	var $_system;
	var $_strings;
	var $_lang_conv;

	var $_lid_array_with_email;

// config
	var $_conf_use_hits;
	var $_conf_use_ratelink;
	var $_conf_use_broken;
	var $_conf_broken;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_link_handler( $dirname )
{
	$this->weblinks_object_handler( $dirname, 'link', 'lid' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_LINK_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

	$config_basic_handler =& weblinks_get_handler( 'config2_basic', $dirname );
	$this->_system    =& weblinks_system::getInstance();
	$this->_strings   =& weblinks_strings::getInstance();
	$this->_lang_conv =& weblinks_language_convert::getInstance();

	$conf = $config_basic_handler->get_cached();
	$this->_conf_use_hits     = $conf['use_hits'];
	$this->_conf_use_ratelink = $conf['use_ratelink'];
	$this->_conf_broken       = $conf['broken_threshold'];

}

//---------------------------------------------------------
// update
//---------------------------------------------------------
// for visit.php
function countup_hits($lid)
{
	if ( !$this->_conf_use_hits )
	{
		return true;	// no action
	}

	$sql = 'UPDATE '.$this->mTable.' SET hits = hits+1 WHERE lid='.intval($lid);
	$ret = $this->queryF($sql);
	return $ret;

}

// for link_check.php
function countup_broken($lid)
{
	$sql = 'UPDATE '.$this->mTable.' SET broken = broken+1 WHERE lid='.intval($lid);
	$ret = $this->queryF($sql);
	return $ret;
}

// for ratelink.php, admin/votedate.php
function update_rating($lid, $rating, $votes)
{
	if ( !$this->_conf_use_ratelink )
	{
		return true;	// no action
	}

	$lid = intval($lid);

	$obj =& $this->get($lid);
	if ( !is_object($obj) )
	{
		return true;	// no action
	}

	$obj->setVar('rating', $rating);
	$obj->setVar('votes',  $votes);
	$ret = $this->update($obj);
	return $ret;
}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_lid($lid)
{
	$obj = $this->get($lid);
	if ( is_object($obj) )
	{
		$ret = $this->delete($obj);
		return $ret;
	}

	return true;	// no action
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
// except broken link
function get_count_rss_flag()
{
	$sql  = 'SELECT COUNT(*) c FROM '.$this->mTable.' ';
	$sql .= 'WHERE ( rss_flag=1 OR rss_flag=2 ) AND broken<'.$this->_conf_broken.' ';
	$count = $this->getCountBySql($sql);
	return $count;
}

function get_count_non_url()
{
// XOOPS 2.2.3 dont accept value = ''

	$sql  = "SELECT COUNT(*) c FROM ".$this->mTable." WHERE (url = '') ";
	$count = $this->getCountBySql($sql);
	return $count;
}

// except broken link
function get_count_public()
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('broken', $this->_conf_broken, '<') );
	$count = $this->getCount($criteria);
	return $count;
}

// except broken link
function get_count_by_mark($mark)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('broken', $this->_conf_broken, '<') );
	$criteria->add( new weblinks_criteria($mark, 1, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_count_broken()
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('broken', 0, '>') );
	$count = $this->getCount($criteria);
	return $count;
}

function get_count_by_uid($uid)
{
	$uid = intval($uid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('uid', $uid, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
// bug fix: except broken link
// BUG 2790: not show rss site
function  &get_objects_rss_by_sort($sort, $limit=0, $start=0)
{
	$orderby = 'lid ASC';

	if ( isset($sort['sort']) && isset($sort['order']) )
	{
		$orderby = $sort['sort'].' '.$sort['order'];
	}

	$sql  = 'SELECT * FROM '.$this->mTable.' ';
	$sql .= 'WHERE ( rss_flag=1 OR rss_flag=2 ) AND broken < '.$this->_conf_broken.' ';
	$sql .= 'ORDER BY '.$orderby;
	$objs =& $this->getObjectsBySql($sql, $limit, $start);
	return $objs;
}

function &get_objects_non_url($limit=0, $start=0)
{
// XOOPS 2.2.3 dont accept value = ''

	$sql = "SELECT * FROM ".$this->mTable." WHERE (url = '') ORDER BY lid";
	$objs =& $this->getObjectsBySql($sql, $limit, $start);
	return $objs;
}

function &get_objects_all($limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_desc($limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->setSort( 'lid', 'DESC' );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

// except broken link
function &get_objects_by_mark_sort($mark, $sort, $limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria($mark, 1, '=') );
	$criteria->add( new weblinks_criteria('broken', $this->_conf_broken, '<') );

	if ( isset($sort['sort']) && isset($sort['order']) )
	{
		$criteria->setSort( $sort['sort'], $sort['order'] );
	}

	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_broken($limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('broken', 0, '>') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_by_uid($uid, $limit=0, $start=0)
{
	$uid = intval($uid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('uid', $uid, '=') );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

//---------------------------------------------------------
// get lid list
//---------------------------------------------------------
function &get_lid_array_by_random($limit=0, $start=0)
{
// except broken link & without url
// XOOPS 2.2.3 dont accept value = ''

	$sql  = "SELECT lid FROM ".$this->mTable." ";
	$sql .= "WHERE (url != '' AND broken < ".$this->_conf_broken.") ";
	$sql .= "ORDER BY rand()";
	$arr  =& $this->getFirstRowsBySql($sql, $limit, $start);
	return $arr;
}

function &get_lid_array($limit=0, $start=0)
{
	$limit = intval($limit);
	$start = intval($start);
	$criteria = new weblinks_criteria_compo();
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$arr =& $this->getList($criteria);
	return $arr;
}

//---------------------------------------------------------
// get link item
//---------------------------------------------------------
// visit.php
function get_sanitized_url_by_lid($lid)
{
	$lid = intval($lid);

	$obj =& $this->get($lid);
	if ( !is_object($obj) )  { return false; }

	$url = $obj->get('url');
	$url = $this->_strings->sanitize_html_url($url);
	return $url;
}

//---------------------------------------------------------
// search
// for search.php
//---------------------------------------------------------
function search($queryarray, $andor='AND', $limit=0, $start=0, $uid=0)
{
	list ($sql_total, $sql_links) = $this->build_sql_search($queryarray, $andor, $uid);
	$ret = $this->get_row_array_by_sql($sql_links, $limit, $start);
	return $ret;
}

// except broken link
function build_sql_search($query_array, $andor='AND', $uid=0)
{
	$where = '';
	if ( $uid != 0 ) 
	{
		$where .= "uid=$uid ";
	}

	if ( is_array($query_array) && $count = count($query_array) )
	{
		if ($where)
		{
			$where .= "AND ";
		}

		$q = addslashes( $query_array[0] );
		$where .= "( search LIKE '%$q%' ";

		for ($i=1; $i<$count; $i++)
		{
			$q = addslashes( $query_array[$i] );
			$where .= "$andor ";
			$where  .= "search LIKE '%$q%' ";
		}

		$where .= ") ";
	}

	$where .= " AND broken < $this->_conf_broken ";

	$sql_total = "SELECT COUNT(*) c FROM ".$this->mTable." WHERE ".$where;
	$sql_links = "SELECT * FROM ".$this->mTable." WHERE ".$where." ORDER BY time_update DESC";

	return array($sql_total, $sql_links);
}

//---------------------------------------------------------
// this function dont work well, when too much links
//---------------------------------------------------------
function &get_lid_array_with_email($limit=0, $start=0)
{
	$user_list            = array();
	$lid_array_with_email = array();
	$email_store          = array();

	$objs =& $this->get_objects_all($limit, $start);
	foreach ($objs as $obj)
	{
		$lid  = $obj->get('lid');
		list($name, $email) = $obj->user_name_mail();
		$user_list[$lid] = $email;
	}

	foreach ($user_list as $lid => $email)
	{
// check duplication
		if ( empty($email) )  continue;

		if ( in_array($email, $email_store) )
		{
//			echo "omit $lid $email <br />\n";
			continue;
		}

		$email_store[]  = $email;
		$lid_array_with_email[] = $lid;
	}

	return $lid_array_with_email;
}


//=========================================================
// use language_convert class
//=========================================================
// visit.php
function build_link_mail($lid)
{
	$sitename = $this->_system->get_sitename();
	$subject  = sprintf(_WLS_INTRESTLINK,  $sitename);
	$body     = sprintf(_WLS_INTLINKFOUND, $sitename).": ".$this->build_single_link($lid);

// --- effective only in Japanese environment ---
// convert EUC-JP to SJIS
	$subject = $this->_lang_conv->convert_telafriend_subject($subject);
	$body    = $this->_lang_conv->convert_telafriend_body($body);

	$subject = rawurlencode($subject);
	$body    = rawurlencode($body);

	return array($subject, $body);
}

function build_single_link($lid)
{
	$link = XOOPS_URL.'/modules/'.$this->_dirname.'/singlelink.php?lid='.$lid;
	return $link;
}

//=========================================================
// add_column_table
//=========================================================
function check_version_110()
{
	$ret = $this->existsFieldName( 'dohtml' );
	return $ret;
}

function add_column_table_110()
{
$sql1 = "
  ALTER TABLE ".$this->mTable." ADD COLUMN (
  dohtml   tinyint(1) NOT NULL default 0,
  dosmiley tinyint(1) NOT NULL default 1,
  doxcode  tinyint(1) NOT NULL default 1,
  doimage  tinyint(1) NOT NULL default 1,
  dobr     tinyint(1) NOT NULL default 1,
  etc1 varchar(255) default NULL,
  etc2 varchar(255) default NULL,
  etc3 varchar(255) default NULL,
  etc4 varchar(255) default NULL,
  etc5 varchar(255) default NULL
)";

	$ret1 = $this->query($sql1);

	$sql2 = "ALTER TABLE ".$this->mTable." MODIFY cids varchar(255) default NULL ";
	$ret2 = $this->query($sql2);

	$sql3 = "ALTER TABLE ".$this->mTable." MODIFY title varchar(255) NOT NULL default '' ";
	$ret3 = $this->query($sql3);

	$sql4 = "ALTER TABLE ".$this->mTable." MODIFY zip varchar(255) default NULL ";
	$ret4 = $this->query($sql4);

	$sql5 = "ALTER TABLE ".$this->mTable." MODIFY state varchar(255) default NULL ";
	$ret5 = $this->query($sql5);

	$sql6 = "ALTER TABLE ".$this->mTable." MODIFY city varchar(255) default NULL ";
	$ret6 = $this->query($sql6);

	if ( $ret1 && $ret2 && $ret3 && $ret4 && $ret5 && $ret6 )
	{
		return true;
	}

	return false;
}

// --- class end ---
}

// === class end ===
}

?>