<?php
// $Id: weblinks_config2_handler.php,v 1.2 2006/06/11 11:35:19 ohwada Exp $

// 2006-06-11 K.OHWADA
// BUG 4032 : cannot create table in MySQL 3.23

// 2006-05-15 K.OHWADA
// this is new file
// use new handler

//================================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_config2 
//   weblinks_config2_handler
// porting form RSSC 
// 2006-05-15 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('weblinks_config2_handler') ) 
{

//================================================================
// class weblinks_config2
// modify form system XoopsConfigItem
//================================================================
class weblinks_config2 extends weblinks_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config2()
{
	$this->weblinks_object();

	$this->initVar('id',             XOBJ_DTYPE_INT, 0, false);
	$this->initVar('conf_id',        XOBJ_DTYPE_INT, 0, true);
	$this->initVar('conf_name',      XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('conf_value',     XOBJ_DTYPE_TEXT);
	$this->initVar('conf_valuetype', XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('aux_int_1',      XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_int_2',      XOBJ_DTYPE_INT,   0);
	$this->initVar('aux_text_1',     XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('aux_text_2',     XOBJ_DTYPE_STRING, null, false, 255);

}

//---------------------------------------------------------
// set value
//---------------------------------------------------------
function setConfValueForInput(&$value, $force_slash = false)
{
	switch ( $this->getVar('conf_valuetype') ) 
	{
		case 'array':
			if (!is_array($value)) 
			{
				$value = explode('|', trim($value));
			}
			$this->setVar('conf_value', serialize($value), $force_slash);
			break;

		case 'text':
			$this->setVar('conf_value', trim($value), $force_slash);
			break;

		default:
			$this->setVar('conf_value', $value, $force_slash);
			break;
	}
}

//---------------------------------------------------------
// get value
//---------------------------------------------------------
function &getConfValueForOutput()
{
	switch ( $this->getVar('conf_valuetype') ) 
	{
		case 'int':
			$value = intval( $this->get('conf_value') );
			break;

		case 'array':
			$value = unserialize( $this->get('conf_value') );
			break;

		case 'float':
			$value = floatval( $this->get('conf_value') );
			break;

		case 'textarea':
			$value = $this->getVar('conf_value');
			break;

		case 'text':
		default:
			$value = $this->get('conf_value');
			break;
	}

	return $value; 
}

function getVarAll($format='n')
{
	$ret = parent::getVarAll($format);
	$ret['value_output'] = $this->getConfValueForOutput();
	return $ret;
}

// --- class end ---
}

//=========================================================
// class config handler
//=========================================================
class weblinks_config2_handler extends weblinks_object_handler
{
	var $_cached_by_confid = array();
	var $_cached_by_name   = array();

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_config2_handler( $dirname )
{
	$this->weblinks_object_handler( $dirname, 'config2', 'conf_id' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_CONFIG2_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

}

//---------------------------------------------------------
// load
//---------------------------------------------------------
function load()
{
	$this->_cached = array();

	$objs = $this->getObjects();

	foreach ($objs as $obj)
	{
		$arr = $obj->getVarAll('n');
		$this->_cached_by_confid[ $arr['conf_id'] ] = $arr;
		$this->_cached_by_name[ $arr['conf_name'] ] = $arr;
	}

	return $this->_cached;

}

function get_cache_by_confid($id)
{
	if ( isset( $this->_cached_by_confid[$id] ) )
	{
		$ret = $this->_cached_by_confid[$id];
		return $ret;
	}

	return false;
}

function get_cache_by_confid_key($id, $key)
{
	if ( isset( $this->_cached_by_confid[$id][$key] ) )
	{
		$ret = $this->_cached_by_confid[$id][$key];
		return $ret;
	}

	return false;
}

function get_cache_by_name($name)
{
	if ( isset( $this->_cached_by_name[$name] ) )
	{
		$ret = $this->_cached_by_name[$name];
		return $ret;
	}

	return false;
}

function get_cache_by_name_key($name, $key)
{
	if ( isset( $this->_cached_by_name[$name][$key] ) )
	{
		$ret = $this->_cached_by_name[$name][$key];
		return $ret;
	}

	return false;
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
function update_by_confid($id, $value)
{
	$id = intval($id);
	if ($id <= 0) return false;

	$obj =& $this->get_by_confid($id);

	if ( !is_object($obj) )
	{	return false;	}

	$obj->setConfValueForInput($value, true);
	$ret = $this->update($obj);
	return $ret;

}

function update_by_name($name, $value)
{
	$id =  $this->get_cache_by_name_key($name, 'conf_id');
	$ret = $this->update_by_confid($id, $value);
	return $ret;
}

//---------------------------------------------------------
// get
//---------------------------------------------------------
function &get_by_confid($id)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('conf_id', $id, '=') );
	$objs =& $this->getObjects($criteria);
	$count = count($objs);

	if ( $count <= 0 )  { return false; }

	if ( $count > 1  )  
	{
		$this->_set_errors( "table ".$this->mTable." : too many matched" );
	}

	if ( isset($objs[0]) )
	{
		$obj = $objs[0];
		return $obj;
	}

	return false;
}

//---------------------------------------------------------
// create_table
//---------------------------------------------------------
function create_table()
{
// BUG : cannot create table in MySQL 3.23
// remove last ';'
$sql = "
CREATE TABLE ".$this->mTable." (
  id smallint(5) unsigned NOT NULL auto_increment,
  conf_id smallint(5) unsigned NOT NULL default 0,
  conf_name      varchar(255) NOT NULL default '',
  conf_valuetype varchar(255) NOT NULL default '',
  conf_value text NOT NULL,
  aux_int_1 int(5) default '0',
  aux_int_2 int(5) default '0',
  aux_text_1 varchar(255) default '',
  aux_text_2 varchar(255) default '',
  PRIMARY KEY (id),
  KEY conf_id (conf_id)
) TYPE=MyISAM
";

	$ret = $this->query($sql);
	return $ret;
}

// --- class end ---
}

// === class end ===
}

?>