<?php
// $Id: weblinks_atomfeed_handler.php,v 1.2 2006/05/24 01:23:56 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// not use weblinks_module_base

// 2006-01-01 K.OHWADA
// weblinks ver 1.0
// module depulication

//=========================================================
// WebLinks Module
// this file contain 2 class
//   weblinks_atomfeed 
//   weblinks_atomfeed_handler
// 2004-11-28 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('weblinks_atomfeed_handler') ) 
{

//=========================================================
// class weblinks_atomfeed
//=========================================================
class weblinks_atomfeed extends weblinks_object
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_atomfeed()
{
	$this->weblinks_object();

	$this->initVar('aid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('lid', XOBJ_DTYPE_INT, 0, false);
	$this->initVar('site_title', XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('site_url',   XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('title',      XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('url',        XOBJ_DTYPE_URL,    null, false, 255);
	$this->initVar('entry_id',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('guid',       XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('time_modified',  XOBJ_DTYPE_INT, 0, false);
	$this->initVar('time_issued',    XOBJ_DTYPE_INT, 0, false);
	$this->initVar('time_created',   XOBJ_DTYPE_INT, 0, false);
	$this->initVar('author_name',  XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('author_url',   XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('author_email', XOBJ_DTYPE_STRING, null, false, 255);
	$this->initVar('content', XOBJ_DTYPE_TEXT);

}

//---------------------------------------------------------
// item
//---------------------------------------------------------
function time_modified_disp( $format='m' )
{
	$time = $this->get('time_modified');
	$ret  = formatTimestamp($time, $format);
	return $ret;
}

function title_disp( $mode_title=0, $default='---')
{
	$title = $this->get('title');

// some site have title with html tag
	if ( !$mode_title )
	{
		$title = strip_tags( $title );
		$title = $this->sanitize_text($title);
	}

	if ( empty($title) )
	{
		$title = $default;
	}

	return $title;
}

function content_disp( $mode_content=0, $max=100 )
{
// allow HTML tag
	if ( $mode_content )
	{
		$content = $this->get('content');
	}
	else
	{
		$content = $this->summary_disp($max);
	}

	return $content;
}

function summary_disp( $max=100 )
{
	$summary = $this->get('content');
	$summary = $this->prepare_strip_tags( $summary );
	$summary = strip_tags( $summary );
	$summary = $this->shorten_text( $summary, $max );
	$summary = $this->sanitize_text($summary);

	return $summary;
}

function prepare_strip_tags($text)
{
	$text = str_replace(">", "> ", $text);
	return $text;
}

function sanitize_text($text)
{
	$ret = htmlspecialchars($text, ENT_QUOTES);
	return $ret;
}

//---------------------------------------------------------
// multi byte
//---------------------------------------------------------
function shorten_text($text, $max=100)
{
	if ( strlen($text) > $max)
	{
		if (function_exists('mb_strcut'))
		{
			$text = mb_strcut( $text, 0, $max )." ...";
		}
		else
		{
			$text = substr( $text, 0, $max )." ...";
		}
	} 

	return $text;
}

// --- class end ---
}

//=========================================================
// class weblinks_atomfeed_handler
//=========================================================
class weblinks_atomfeed_handler extends weblinks_object_handler
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function weblinks_atomfeed_handler( $dirname )
{
	$this->weblinks_object_handler( $dirname, 'atomfeed', 'aid' );

	$this->set_debug_sql(   WEBLINKS_DEBUG_ATOMFEED_SQL );
	$this->set_debug_error( WEBLINKS_DEBUG_ERROR );

}

//---------------------------------------------------------
// delete
//---------------------------------------------------------
function delete_by_lid($lid, $force=false)
{ 
	$lid = intval($lid);
	$sql = 'DELETE FROM '.$this->mTable.' WHERE lid='.$lid;

	if ( !$this->query($sql, 0, 0, $force) )
	{	return false;	}

	return true;
}

//---------------------------------------------------------
// get count
//---------------------------------------------------------
function get_count_by_lid($lid)
{
	$lid = intval($lid);
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid', $lid, '=') );
	$count = $this->getCount($criteria);
	return $count;
}

//---------------------------------------------------------
// get objects
//---------------------------------------------------------
function &get_objects_latest($limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->setSort( 'time_modified', 'DESC' );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

function &get_objects_latest_by_lid($lid, $limit=0, $start=0)
{
	$criteria = new weblinks_criteria_compo();
	$criteria->add( new weblinks_criteria('lid', $lid, '=') );
	$criteria->setSort( 'time_modified', 'DESC' );
	$criteria->setStart($start);
	$criteria->setLimit($limit);
	$objs =& $this->getObjects($criteria);
	return $objs;
}

// --- class end ---
}

// === class end ===
}

?>