<?php
// $Id: bulk_manage.php,v 1.1 2006/05/24 01:16:13 ohwada Exp $

// 2006-05-15 K.OHWADA
// new handler
// use token ticket

//=========================================================
// WebLinks Module
// 2006-05-15 K.OHWADA
//=========================================================

include 'admin_header.php';


//=========================================================
// class admin_bulk_manage
//=========================================================
class admin_bulk_manage
{
// handlder
	var $_link_edit_handler;
	var $_category_handler;
	var $_catlink_handler;

	var $_strings;
	var $_bulk_form;

// local variable
	var $_split_pattern = ',';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_bulk_manage()
{

// handlder
	$this->_link_edit_handler =& weblinks_get_handler( 'link_edit', WEBLINKS_DIRNAME );
	$this->_category_handler  =& weblinks_get_handler( 'category',  WEBLINKS_DIRNAME );
	$this->_catlink_handler   =& weblinks_get_handler( 'catlink',   WEBLINKS_DIRNAME );

	$this->_strings   =& weblinks_strings::getInstance();
	$this->_bulk_form =& admin_bulk_form::getInstance();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_bulk_manage();
	}
	return $instance;
}


//=========================================================
// public
//=========================================================
//---------------------------------------------------------
// init
//---------------------------------------------------------
function init()
{
	$this->_category_handler->load();
}

//---------------------------------------------------------
// print
//---------------------------------------------------------
function print_menu()
{
	$script = xoops_getenv('PHP_SELF');

	$script_cat       = $script.'?op=form_cat';
	$script_link      = $script.'?op=form_link';
	$script_file_cat  = $script.'?op=form_file_cat';
	$script_file_link = $script.'?op=form_file_link';

	echo "<h3>". _AM_WEBLINKS_BULK_IMPORT ."</h3>\n";
	echo "<ul>\n";
	echo "<li><a href='$script_cat'>". _AM_WEBLINKS_BULK_CAT ."</a><br /><br /></li>\n";
	echo "<li><a href='$script_link'>". _AM_WEBLINKS_BULK_LINK ."</a><br /><br /></li>\n";
//	echo "<li><a href='$script_file_cat'>". _AM_WEBLINKS_BULK_CAT ."</a><br /><br /></li>\n";
//	echo "<li><a href='$script_file_link'>". _AM_WEBLINKS_BULK_LINK ."</a><br /><br /></li>\n";
	echo "</ul>\n";
}

function print_form_file($title, $dsc, $file, $op)
{
	$this->_print_title( $title );

	if ( !file_exists($file) )
	{
		$this->_print_error("file not exists: $file");
		return false;
	}

	echo $dsc."<br />\n";
	$this->_bulk_form->print_file_in_form($file);
	$this->_bulk_form->print_form_exec($file, $op);
}

function print_setting_file($file)
{
	$file_html = $this->_sanitize_text($file);

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=<?php echo _CHARSET; ?>" />
<title><?php echo $file_html; ?></title>
</head>
<body>
<h3><?php echo $file_html; ?></h3>
<?php

	if ( file_exists($file) )
	{
		$this->_bulk_form->print_file_in_form($file);
	}
	else
	{
		$this->_print_error("file not exists: $file");
	}

?>
<br />
<input value='CLOSE' type='button' onclick='javascript:window.close();' />
</head>
</html>
<?php

}

function print_form_category($file)
{
	$this->init();
	$selbox = $this->_build_selbox(1);
	$this->_bulk_form->print_form_category($file, $selbox);
}

function print_form_link($file)
{
	$this->_bulk_form->print_form_link($file);
}

//---------------------------------------------------------
// add category & link
//---------------------------------------------------------
function add_cat($cid, $line_arr)
{
	echo "<h4>". _AM_WEBLINKS_BULK_CAT ."</h4>\n";

// proc lines
	$ret = $this->_proc_cat($cid, $line_arr);
	if ( !$ret )
	{
		echo "<br />\n";
		$this->_print_error( _AM_WEBLINKS_BULK_ERROR_FINISH );
	}

	echo "<br />\n";
	echo "<h4>". _WLS_NEWCATADDED ."</h4>\n";
	echo "<hr />\n";
}

function add_link($line_arr)
{
	echo "<h4>". _AM_WEBLINKS_BULK_LINK ."</h4>\n";

	$ret = $this->_proc_link($line_arr);
	if ( !$ret )
	{
		echo "<br />\n";
		$this->_print_error( _AM_WEBLINKS_BULK_ERROR_FINISH );
	}

	echo "<br />\n";
	echo "<h4>". _WLS_NEWLINKADDED ."</h4>\n";
	echo "<hr />\n";
}

//---------------------------------------------------------
// file category & link
//---------------------------------------------------------
function file_cat($file)
{
	$this->_print_title( _AM_WEBLINKS_BULK_CAT );

	if ( !file_exists($file) )
	{
		$this->_print_error("file not exists: $file");
		return false;
	}

	$line_arr = file($file);

// parent category
	$this->set_split_pattern("\t");

	$line = array_shift($line_arr);
	$line = trim($line);

	list($depth, $arr) = $this->_get_cat($line);

	if ( !$this->_check_cat($arr) )
	{
		echo "<br />\n";
		echo "<b>". _AM_WEBLINKS_BULK_ERROR_FINISH ."</b><br />\n";
		return;
	}

	$cid = $this->_get_cid_by_title( $arr['title'] );
	if ( $cid == -1 )
	{
		echo "<br />\n";
		echo "<b>". _AM_WEBLINKS_BULK_ERROR_FINISH ."</b><br />\n";
		return;
	}

// proc lines
	$ret = $this->_proc_cat($cid, $line_arr);
	if ( !$ret )
	{
		echo "<br />\n";
		$this->_print_error( _AM_WEBLINKS_BULK_ERROR_FINISH );
	}

	echo "<br />\n";
	echo "<b>". _WLS_NEWCATADDED ."</b><br />\n";
	echo "<hr />\n";
}

function file_link($file)
{
	$this->_print_title( _AM_WEBLINKS_BULK_LINK );

	if ( !file_exists($file) )
	{
		$this->_print_error("file not exists: $file");
		return false;
	}

	$line_arr = file($file);

	$this->set_split_pattern("\t");

	$ret = $this->_proc_link($line_arr);
	if ( !$ret )
	{
		echo "<br />\n";
		$this->_print_error( _AM_WEBLINKS_BULK_ERROR_FINISH );
	}

	echo "<br />\n";
	echo "<b>". _WLS_NEWLINKADDED ."</b><br />\n";
	echo "<hr />\n";
}

//=========================================================
// private
//=========================================================
//---------------------------------------------------------
// category
//---------------------------------------------------------
function _proc_cat($pid_first, $line_arr)
{
// category
	$pid_arr    = array();
	$pid_arr[0] = $pid_first;
	$pid        = $pid_first;
	$depth_prev = 0;

	foreach ($line_arr as $line)
	{
		$line = trim($line);
	 	if (empty($line))  continue;

		list($depth, $arr) = $this->_get_cat($line);

	 	if ( !$this->_check_cat($arr) )
	 	{
	 		continue;
		}

// under one level, or above level
		if ( ( $depth == ($depth_prev + 1) ) || ( $depth < $depth_prev ) )
		{
			$pid = $pid_arr[$depth];
		}
// under two or more level
		elseif ( $depth > $depth_prev )
		{
			$this->_print_error( _AM_WEBLINKS_BULK_ERROR_LAYER );
			return false;
		}

		$newid = $this->_insert_cat($pid, $arr);
		if ( !$newid )
		{
			return false;
		}

		$pid_arr[$depth+1] = $newid;
		$depth_prev        = $depth;
	}

	return true;
}

function _get_cat($line)
{
	$depth = 0;
	$arrow = '';
	$title = '';

	if ( preg_match ("/^>/", $line) )
	{
		list($arrow, $title) = preg_split("/\s+/", $line, 2);
		$depth = substr_count($arrow, ">");
	}
	else
	{
		$title = $line;
	}

	echo $this->_str_trim_html("$arrow $title");
	echo "<br />\n";

	$arr = array(
		'title'       => $title,
	);

	return array($depth, $arr);
}

function _check_cat($arr)
{
	if ( !isset($arr['title']) || empty($arr['title']) )
	{
		$this->_print_error( _NO_TITLE );
		return false;
	}

	return true;
}

function _insert_cat($pid, $arr)
{
	$pid = intval($pid);
	if ( $pid < 0 )
	{
		$this->_print_error( _AM_WEBLINKS_BULK_ERROR_PID );
		return false;
	}

	$arr['pid']   = $pid;
	$arr['lflag'] = 1;

	$obj =& $this->_category_handler->create();
	$obj->assign_vars_post( $arr );

	$newid = $this->_category_handler->insert($obj);
	if ( !$newid )
	{
		$this->_print_error( $this->_category_handler->getErrors(1) );
		return false;
	}

	return $newid;
}

function _get_cid_by_title($title)
{
	if ($title == 'TOP')
	{
		return 0;
	}

	$cid_arr =& $this->_category_handler->get_cid_array_by_title($title);

	$count   = count($cid_arr);
	$title_s = $this->_str_trim_html($title);

	if ( !is_array($cid_arr) || ($count == 0))
	{
		$this->_print_error( _NO_MATCH_RECORD.": ".$title_s );
		echo "$err_html <br />\n";
		return -1;
	}
	elseif ($count > 1)
	{
		$this->_print_error( _MANY_MATCH_RECORD.": ".$title_s );
		echo "$err_html <br />\n";
		return -1;
	}

	return $cid_arr[0];
}

function _build_selbox()
{
	$selbox = $this->_category_handler->build_selbox( 0, 1, "cid", '', "TOP", 0 );
	return $selbox;
}

//---------------------------------------------------------
// link
//---------------------------------------------------------
function _proc_link($line_arr)
{
	$flag_line = 0;
	$cid       = -1;	// dummy

	foreach ($line_arr as $line)
	{
		$line = trim($line);

// blank
		if (empty($line))  continue;

// pause
		if ( $this->_check_line_pause($line) )
		{
			echo "<br />\n";
			$flag_line = 0;
		}

// category
		elseif ($flag_line == 0)
		{
			$category_title = $line;

			if ( !$this->_check_cat($category_title) )
			{
				return false;
			}

			$cid = $this->_get_cid_by_title($category_title);
			if ( $cid == -1 )
			{
				return false;
			}

			echo "$cid: $category_title <br />\n";
			$flag_line = 1;
		}

// link
		elseif ($flag_line == 1)
		{
			$link_arr = $this->_get_link($line);

		 	if ( !$this->_check_link($link_arr) )
		 	{
		 		continue;
			}

			$ret = $this->_insert_link($cid, $link_arr);
			if ( !$ret )
			{
				return false;
			}
		}
 		else
		{
			$this->_print_error("system error");
			return false;
		}

	}

	return true;
}

function _get_link($line)
{
	$title = '';
	$url   = '';
	$description = '';

	list($title, $url, $description) = $this->_split_line($line);

	$str = "$title, $url, $description";
	echo $this->_str_trim_html($str);
	echo "<br />\n";

	$description = $this->_str_replace_crlf($description);

	$arr = array(
		'title'       => $title,
		'url'         => $url,
		'description' => $description,
	);

	return $arr;
}

function _check_link($arr)
{
	if ( !isset($arr['title']) || empty($arr['title']) )
	{
		$this->_print_error( _NO_TITLE );
		return false;
	}

	if ( !isset($arr['url']) || empty($arr['url']) )
	{
		$this->_print_error( _NO_URL );
		return false;
	}

	if ( !isset($arr['description']) || empty($arr['description']) )
	{
		$this->_print_error( _NO_DESCRIPTION );
		return false;
	}

 	return true;
}

function _insert_link($cid, $arr)
{
	$cid = intval($cid);

	if ( $cid <= 0 )
	{
		$this->_print_error( _AM_WEBLINKS_BULK_ERROR_CID );
		return false;
	}

// link obj
	$newid =& $this->_link_edit_handler->add_link_to_link( $arr );
	if ( !$newid )
	{
		$this->_print_error( $this->_link_edit_handler->getErrors(1) );
		return false;
	}

// catlink_obj
	$catlink_obj =& $this->_catlink_handler->create();
	$catlink_obj->setVar('cid', $cid );
	$catlink_obj->setVar('lid', $newid );
	$ret = $this->_catlink_handler->insert($catlink_obj);
	if ( !$ret )
	{
		$this->_print_error( $this->_link_edit_handler->getErrors(1) );
		return false;
	}

 	return true;
}

//-----------------------------------------------
// check or split line
//-----------------------------------------------
function _check_line_pause($line)
{
	if ( preg_match ("/^---/", $line) )
	{
		return true;
	}

	return false;
}

function _split_line($line)
{
	$item_arr = split($this->_split_pattern, $line);

	foreach ($item_arr as $key => $item)
	{
		$item_arr[$key] = trim($item);
	}

	return $item_arr;
}

function set_split_pattern($value)
{
	$this->_split_pattern = $value;
}

//-----------------------------------------------
// convert strings
//-----------------------------------------------
function _str_trim_html($str, $max=100)
{
	$str = $this->_strings->shorten_text($str, $max);
	$str = $this->_sanitize_text($str);
	return $str;
}

function _str_replace_crlf($str)
{
	$str = $this->_strings->replace_crlf($str);
	return $str;
}

function _sanitize_text($str)
{
	$str = htmlspecialchars($str, ENT_QUOTES);
	return $str;
}

//-----------------------------------------------
// print
//-----------------------------------------------
function _print_title($title)
{
	echo $this->_bulk_form->_build_html_title($title);
}

function _print_error($msg)
{
	echo $this->_strings->highlight($msg);
}

//---------------------------------------------------------
// token ticket
//---------------------------------------------------------
function check_token( $name='' )
{
	$ret = $this->_bulk_form->check_token($name);
	return $ret;
}


// --- class end ---
}


//=========================================================
// class admin_bulk_form
//=========================================================
class admin_bulk_form extends weblinks_form
{
	var $ROWS = 40;
	var $COLS = 80;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_bulk_form()
{
	$this->weblinks_form();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_bulk_form();
	}
	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function print_form_category($file, $selbox)
{
	echo $this->_build_table_begin( _AM_WEBLINKS_BULK_CAT );

// add category
	echo $this->make_form_start( 'add_cat' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'add_cat');

	echo "&nbsp;"._WLS_IN."&nbsp;".$selbox."<br /><br />\n";
	echo _AM_WEBLINKS_BULK_CAT_DSC1."<br />\n";
	echo _AM_WEBLINKS_BULK_CAT_DSC2."<br /><br />\n";

	echo $this->make_form_textarea('catlist', '', $this->ROWS, $this->COLS );
	echo "<br />\n";
	echo $this->make_form_submit('submit', _ADD );
	echo $this->make_form_cancel_button('cancel', _BACK );
	echo $this->make_form_end();

// view file 
	$this->_print_view_file('view_cat', $file);

	echo $this->_build_table_end();

}

function print_form_link($file)
{
	echo $this->_build_table_begin( _AM_WEBLINKS_BULK_LINK );

// add link
	echo $this->make_form_start( 'add_link' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op', 'add_link');

	echo _AM_WEBLINKS_BULK_LINK_DSC1."<br />\n";
	echo _AM_WEBLINKS_BULK_LINK_DSC2."<br />\n";
	echo _AM_WEBLINKS_BULK_LINK_DSC3."<br /><br />\n";

	echo $this->make_form_textarea('linklist', '',  $this->ROWS, $this->COLS );
	echo "<br />\n";
	echo $this->make_form_submit('submit', _ADD );
	echo $this->make_form_cancel_button('cancel', _BACK );
	echo $this->make_form_end();

// view file 
	$this->_print_view_file('view_link', $file);

	echo $this->_build_table_end();

}

function print_file_in_form($file, $rows=40, $cols=80 )
{
	echo "<form>\n";
	echo "<textarea rows='".$rows."' cols='".$cols."'>\n";

	readfile($file);

	echo "\n</textarea>\n";
	echo "</form>\n";
}

function print_form_exec($file, $op, $button='')
{
	if (empty($button))
	{
		$button = _EXECUTE;
	}

	echo $this->make_form_start( 'add_link' );
	echo $this->make_form_token();
	echo $this->make_form_hidden('op',   $op);
	echo $this->make_form_hidden('file', $file);
	echo $this->make_form_submit('submit', $button );
	echo $this->make_form_cancel_button('cancel', _BACK );

}

//---------------------------------------------------------
// private
//---------------------------------------------------------
function _print_view_file($form_name, $file)
{
	$action = '';
	echo $this->make_form_start( $form_name, $action, 'post', 'target' );
	echo $this->make_form_hidden('op',  'view');
	echo $this->make_form_hidden('file', $file);
	echo $this->make_form_submit('submit', _SAMPLE );
	echo $this->make_form_end();

}

function _build_table_begin( $title )
{
	$text  = "<table width='100%' border='0' cellspacing='1' class='outer'>\n";
	$text .= "<tr class='odd'><td>\n";
	$text .= $this->_build_html_title($title);
	return $text;
}

function _build_table_end()
{
	$text = "</td></tr></table><br />\n";
	return $text;
}

function _build_html_title($title)
{
	$text = "<h4>$title</h4>\n";
	return $text;
}

// --- class end ---
}


//=========================================================
// main start
//=========================================================
$XOOPS_LANGUAGE = $xoopsConfig['language'];

// for local
$FILE_CAT = WEBLINKS_ROOT_PATH."/language/".$XOOPS_LANGUAGE."/bulk/cat_cvs.txt";
if ( !file_exists( $FILE_CAT ) ) 
{
	$FILE_CAT = WEBLINKS_ROOT_PATH."/language/english/bulk/cat_cvs.txt";
}

$FILE_LINK = WEBLINKS_ROOT_PATH."/language/".$XOOPS_LANGUAGE."/bulk/link_cvs.txt";
if ( !file_exists( $FILE_LINK ) ) 
{
	$FILE_CAT = WEBLINKS_ROOT_PATH."/language/english/bulk/link_cvs.txt";
}

$FILE_FILE_CAT = WEBLINKS_ROOT_PATH."/language/".$XOOPS_LANGUAGE."/bulk/cat_tab.txt";
if ( !file_exists( $FILE_FILE_CAT ) ) 
{
	$FILE_FILE_CAT = WEBLINKS_ROOT_PATH."/language/english/bulk/cat_tab.txt";
}

$FILE_FILE_LINK = WEBLINKS_ROOT_PATH."/language/".$XOOPS_LANGUAGE."/bulk/link_tab.txt";
if ( !file_exists( $FILE_FILE_LINK ) ) 
{
	$FILE_FILE_LINK = WEBLINKS_ROOT_PATH."/language/english/bulk/link_tab.txt";
}

$post =& weblinks_post::getInstance();
$bulk_manage =& admin_bulk_manage::getInstance();

$op   = $post->get_post_get('op');
$file = $post->get_post('file');

switch ($op)
{
	case 'view':
		$bulk_manage->print_setting_file( $file );
		break;

	case 'add_cat':
		if( !( $bulk_manage->check_token() ) ) 
		{
			redirect_header( "bulk.php", 5, "Token Error");
			exit();
		}

		$cid       = $post->get_post_int("cid");
		$cat_lines = $post->get_post_text_split("catlist");

		if (count($cat_lines) == 0) 
		{
			redirect_header("bulk.php", 2, _NO_CATEGORY);
			exit();
		}

		xoops_cp_header();
		$bulk_manage->add_cat($cid, $cat_lines);
		weblinks_admin_print_menu();
		xoops_cp_footer();
		break;

	case 'add_link':
		if( !( $bulk_manage->check_token() ) ) 
		{
			redirect_header( "bulk.php", 5, "Token Error");
			exit();
		}

		$link_lines = $post->get_post_text_split("linklist");

		if (count($link_lines) == 0) 
		{
			redirect_header("index.php", 2, _NO_LINK);
			exit();
		}

		xoops_cp_header();
		$bulk_manage->add_link($link_lines);
		weblinks_admin_print_menu();
		xoops_cp_footer();
		break;

	case 'file_cat':
		xoops_cp_header();
		$bulk_manage->file_cat($file);
		xoops_cp_footer();
		break;

	case 'file_link':
		xoops_cp_header();
		$bulk_manage->file_link($file);
		xoops_cp_footer();
		break;

	case 'form_link':
		xoops_cp_header();
		weblinks_admin_print_header();
		weblinks_admin_print_menu();
		$bulk_manage->print_menu();
		$bulk_manage->print_form_link( $FILE_LINK );
		xoops_cp_footer();
		break;

	case 'form_file_cat':
		xoops_cp_header();
		weblinks_admin_print_header();
		weblinks_admin_print_menu();
		echo "<h3>". _AM_WEBLINKS_BULK_IMPORT ."</h3>\n";
		$bulk_manage->print_form_file($TITLE_FILE_CAT, $DESC_FILE_CAT, $FILE_FILE_CAT, 'file_cat');
		xoops_cp_footer();
		break;

	case 'form_file_link':
		xoops_cp_header();
		weblinks_admin_print_header();
		weblinks_admin_print_menu();
		echo "<h3>". _AM_WEBLINKS_BULK_IMPORT ."</h3>\n";
		$bulk_manage->print_form_file($TITLE_FILE_LINK, $DESC_FILE_LINK, $FILE_FILE_LINK, 'file_link');
		xoops_cp_footer();
		break;

	case 'form_cat':
	case 'menu':
	default:
		xoops_cp_header();
		weblinks_admin_print_header();
		weblinks_admin_print_menu();
		$bulk_manage->print_menu();
		$bulk_manage->print_form_category( $FILE_CAT );
		xoops_cp_footer();
		break;	
}

exit();
// --- end of main ---

?>