<?php
ob_start();
if (!is_object($xoopsUser) || !isset($xoopsModule) || !is_object($xoopsModule) || !$xoopsUser->isAdmin($xoopsModule->getVar('mid'))) {
	header("Location: admin/index.php");
	exit();
}
ob_end_clean();

/*
 * Turn down the error reporting to just critical errors for now.
 * In v1.2, we know that we'll have lots and lots of warnings if
 * error reporting is turned all the way up.  We'll fix this in v2.0
 */
error_reporting(E_ALL & ~E_NOTICE);

/* emulate part of register_globals = on */
extract($_GET); 
extract($_POST);
extract($_COOKIE);

if (substr(PHP_OS, 0, 3) == 'WIN') {
	include("platform/fs_win32.php");
	if (fs_file_exists("SECURE")) {
?>
Gallery is in secure mode and cannot be configured.
If you want to configure it, you must run the <b>configure.bat</b>
script in the gallery directory then reload this page.
<?php
		exit;
	}
} else {
	include("platform/fs_unix.php");
}

/* 
 * Turn off magic quotes runtime as they interfere with saving and
 * restoring data from our file-based database files
 */
set_magic_quotes_runtime(0);

/*
 * Init prepend file for setup directory.
 */
$GALLERY_DIR = '../'.dirname(dirname(__FILE__));
if (!strcmp($GALLERY_DIR, ".") || !strcmp($GALLERY_DIR, "/")) {
    $tmp = $_SERVER["PATH_TRANSLATED"];
    if (!$tmp) {
	$tmp = $_ENV["PATH_TRANSLATED"];
    }
    if (!$tmp) {
	$tmp = getenv("SCRIPT_FILENAME");
    }
    $GALLERY_DIR = dirname(dirname($tmp));
}

$tmp = $_SERVER["PHP_SELF"];
if (!$tmp) {
	$tmp = $_ENV["PHP_SELF"];
}
if (!$tmp) {
	$tmp = getenv("SCRIPT_NAME");
}

$GALLERY_URL = dirname(dirname($tmp));
// Make sure GALLERY_URL doesn't end in a slash
$GALLERY_URL = ereg_replace("\/$", "", $GALLERY_URL);

$MIN_PHP_MAJOR_VERSION = 4;

if ($init_mod_rewrite) {
	$GALLERY_REWRITE_OK = 1;
	if (strstr($init_mod_rewrite, "ampersandbroken")) {
		$GALLERY_REWRITE_SEPARATOR = "\&";
	} else {
		$GALLERY_REWRITE_SEPARATOR = "&";
	}
} else {
	$GALLERY_REWRITE_OK = 0;
}

?>
