<?php
// $Id: rss_auto.php,v 1.1.1.2 2005/06/10 18:28:55 ohwada Exp $

// 2004-09-01 K.OHWADA
// use whatsnew_convert_array_array_from_utf8()

//=========================================================
// What's New Module
// RSS auto discovery and and view
// 2004-08-22 K.OHWADA
//=========================================================

include "../../mainfile.php";
include_once XOOPS_ROOT_PATH.'/class/xml/rss/xmlrss2parser.php';
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/include/func.rss_atom_auto.php';
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/include/func.lang.php';

include XOOPS_ROOT_PATH."/header.php";

$TEMPLATE = 'db:whatsnew_rss_view.html';

$op = '';
$url_html = '';
$url_rss  = '';

if ( isset($_POST['op']) )  $op = $_POST['op'];

if ( $op != 'rss' )
{
	$url_html = XOOPS_URL."/";
}

if ( isset($_POST['html']) ) $url_html = $_POST['html'];
if ( isset($_POST['rss']) )  $url_rss  = $_POST['rss'];

?>
<h3><?php echo _WHATSNEW_NAME; ?></h3>
<h4><?php echo _WHATSNEW_RSS_AUTO; ?></h4>
<hr>
<form action="rss_auto.php" method="post">
<input type="hidden" name="op" value="html">
HTML URL: <input type="text" name="html" value="<?php echo $url_html; ?>" size="100">
<input type="submit" value="<?php echo _WHATSNEW_AUTO; ?>">
</form>
HTML URL: <a href="<?php echo $url_html; ?>" target="_blank"><?php echo $url_html; ?></a><br>
<hr>
<?php

if ( $op != 'rss' )
{
	$data_html = get_remote_file($url_html);
	if ($data_html == false)
	{
		print "<h4><font color='red'>"._WHATSNEW_ERROR_CONNCET."</font></h4>\n";
		print "$url_html<br />\n";
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}

	list($url_rss, $url_atom) = get_rss_atom_link($data_html);
}

?>
<form action="rss_auto.php" method="post">
<input type="hidden" name="op" value="rss">
RSS URL: <input type="text" name="rss" value="<?php echo $url_rss; ?>" size="100">
<input type="submit" value="<?php echo _WHATSNEW_SET; ?>">
</form>
RSS URL: <a href="<?php echo $url_rss; ?>" target="_blank"><?php echo $url_rss; ?></a><br>
<hr>
<?php

if (empty($url_rss))
{
	print "<h4><font color='red'>"._WHATSNEW_ERROR_RSS_AUTO."</font></h4>";
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$data_rss = get_remote_file($url_rss);
if ($data_rss == false)
{
	print "<h4><font color='red'>"._WHATSNEW_ERROR_CONNCET."</font></h4>\n";
	print "$url_rss<br />\n";
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

if (empty($data_rss))
{
	print "<h4><font color='red'>"._WHATSNEW_ERROR_RSS_GET."</font></h4>";
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$parser = new XoopsXmlRss2Parser($data_rss);

$result = $parser->parse();
if (!$result) 
{
	print "<h4><font color='red'>"._WHATSNEW_ERROR_PARSE."</font></h4>";

	$error_arr = $parser->getErrors(false);
	foreach ($error_arr as $error)
	{
		print "$error<br />\n";
	}

	print "<pre>-----\n";
	print htmlspecialchars($data_rss);
	print "-----</pre>\n";

	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$channel_data = whatsnew_convert_array_from_utf8( $parser->getChannelData() );
$image_data   = whatsnew_convert_array_from_utf8( $parser->getImageData() );
$items        = whatsnew_convert_array_array_from_utf8( $parser->getItems() );

$tpl = new XoopsTpl();
$tpl->assign_by_ref('channel', $channel_data);
$tpl->assign_by_ref('image',   $image_data);

$tpl->assign(
	array(
		'lang_lastbuild'   => _WHATSNEW_LASTBUILD,
		'lang_language'    => _WHATSNEW_LANGUAGE,
		'lang_description' => _WHATSNEW_DESCRIPTION,
		'lang_webmaster'   => _WHATSNEW_WEBMASTER,
		'lang_category'    => _WHATSNEW_CATEGORY,
		'lang_generator'   => _WHATSNEW_GENERATOR,
		'lang_title'       => _WHATSNEW_TITLE,
		'lang_pubdate'     => _WHATSNEW_PUBDATE,
		'lang_description' => _WHATSNEW_DESCRIPTION,
		'lang_more'        => _MORE
	));

$count = count($items);
for ($i = 0; $i < $count; $i++)
{
	$tpl->append_by_ref('items', $items[$i]);
}

print $tpl->fetch($TEMPLATE);

include XOOPS_ROOT_PATH.'/footer.php';
exit();

?>
