<?php
// $Id: func.pda.php,v 1.2 2005/06/23 11:51:52 ohwada Exp $

//=========================================================
// What's New Module
// build template for PDA 
// 2005-06-20 K.OHWADA
//=========================================================

include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/class/xoopsuser.php';
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/include/func.whatsnew.php';

function whatsnew_build_pda($cache_time=0)
{
	$TEMPLATE = 'db:whatsnew_pda.html';

// no output encode
	if (function_exists('mb_http_output')) 
	{	mb_http_output('pass');	}

	header("Content-Type: text/html");

	$tpl = new XoopsTpl();

	if ($cache_time > 0)
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime($cache_time);
	}

	if ( !$tpl->is_cached($TEMPLATE) || ($cache_time == 0) )
	{
		whatsnew_assign_pda( $tpl );
	}

	$tpl->display($TEMPLATE);
}

function whatsnew_assign_pda( &$tpl )
{
	$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";

	if ( file_exists($FILE_CONFIG) ) 
	{
		include $FILE_CONFIG;
	}
	else
	{
		whatsnew_print_pda_warning();
		return;
	}

	$tpl->assign('xoops_charset', _CHARSET);

	$site_name = htmlspecialchars( $whatsnew_config['site_name'], ENT_QUOTES);
	$tpl->assign('site_name', $site_name);

	$site_desc = htmlspecialchars( $whatsnew_config['site_desc'], ENT_QUOTES);
	$tpl->assign('site_desc', $site_desc);

	$site_url = $whatsnew_config['site_url'];
	$tpl->assign('site_url', $site_url);

	if ( isset($whatsnew_config['image_url']) )
	{
		$tpl->assign('image_url', $whatsnew_config['image_url'] );
	}

	$art_arr = whatsnew_get_new($whatsnew_module, 'new_show', 'new_limit', $whatsnew_new_limit_show);

	$i = 0;
	foreach ($art_arr as $art)
	{
		$line['title'] = htmlspecialchars( $art['title'], ENT_QUOTES );

		if ( isset($art['pda']) )
		{
			$line['link']  = $art['pda'];
		}
		else
		{
			$line['link']  = $art['link'];
		}

		$line['date']  = formatTimestamp( $art['time'], 's' );

// set image width & height
		list($image, $width, $height) = whatsnew_set_image($art, $whatsnew_new_image, $whatsnew_new_max_width, $whatsnew_new_max_height);

		$line['image']  = $image;
		$line['width']  = $width;
		$line['height'] = $height;

// set short description
		$line['desc'] = '';
		if ($i < $whatsnew_new_limit_summary)
		{
			$line['desc'] = whatsnew_set_desc_short($art['description'], $whatsnew_new_max_summary);
		}

		$block[] = $line;
		$i ++;
	}

	$tpl->assign('whatsnew', $block);
}

function whatsnew_print_pda_warning()
{

$xoops_charset = _CHARSET;
$warning = _WHATSNEW_WARNING_NOT_EXIST;

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=<?php echo $xoops_charset; ?>" />
<title>whats new warning</title>
</head>
<body>
<font color="red"><?php echo $warning; ?></font>
</body>
</html>
<?php

}

function whatsnew_clear_pda()
{
	$TEMPLATE = 'db:whatsnew_pda.html';

	$tpl = new XoopsTpl();
	$tpl->clear_cache($TEMPLATE);
}

?>