<?php // vim: ts=4 sw=4 sts=4 fdm=marker ai noet:
/********************************************************
 * B-Wiki ȼδؿ
 * $Id: bwiki.php,v 1.1 2004/12/13 23:22:10 ishii Exp $
 ********************************************************/

define('USE_DB', FALSE);
define('USE_DEBUG', TRUE);
define('DEBUG_LOG_FILE', XOOPS_ROOT_PATH.'/modules/bwiki/log/bwiki.debug.log');

// {{{ debug_log($text)

/**
 * ǥХåѤΥϴؿ
 * @access public
 * @param Mixed $text
 */
function debug_log($text)
{
	if(USE_DEBUG)
	{
		if(!isset($text) || $text =='')
		{
			$text = 'NULL String... :P';
		} else
		if(is_object($text) || is_array($text))
		{
			ob_start();
			print_r($text);
			$text = ob_get_contents();
			ob_end_clean();
			$text = "\033[31mDump Object start =====>\033[0m\n$text";
		}

		$file = DEBUG_LOG_FILE.'-'.date('Ymd');
		$text = trim(date('[Y/m/d H:i:s] ').$text)."\n";

		$fp = @fopen($file, 'a');
		@fwrite($fp, $text);
		@fclose($fp);
	}
}

// }}}
// {{{ hasEditPermission()

/**
 * XOOPS ѤԽ¥å
 * @access public
 * @return Boolean
 */
function hasEditPermission()
{
	global $editable_group_id, $xoopsUser;

	// XXX ̤ξˤïˤԽʤ
	if(!isset($editable_group_id) || !is_array($editable_group_id))
	{
		return false;
	}

	if(isset($xoopsUser) && is_object($xoopsUser))
	{
		foreach($xoopsUser->_groups as $_gid)
		{
			foreach($editable_group_id as $g)
			{
				if($g == $_gid) return true;
			}
		}
	}
	else
	{
		foreach($editable_group_id as $g)
		{
			// XXX Anonymous  3äƷդƤ뤱ɤä(^^;;
			if($g == 3) return true;
		}
	}
	return false;
}

// }}}
// {{{ x_file($filename)

/**
 * ƥȥե֤
 * @access public
 * @param String $filename
 * @return Array
 */
function x_file($filename)
{
	global $xoopsDB;

	if(USE_DB)
	{
		$name = basename($filename);
		$dir = preg_replace("/.*(attach|backup|cache|counter|diff|wiki|trackback)$/", "\\1", dirname($filename));

		$sql = 'select * from '.$xoopsDB->prefix('bwiki_'.$dir).' where name="'.$name.'"';
		$result = $xoopsDB->query($sql);
		$contents = $xoopsDB->fetchArray($result);
		$file = explode("\x08", preg_replace("/\n/", "\n\x08", $contents['value']));

	}
	else
	{
		$file = @file($filename);
	}
	return $file;
}

// }}}
// {{{ add_xoops_facemark()

/**
 * XOOPSѤfacemarkȤ褦ˤ롣
 * @access public
 */
function add_xoops_facemark()
{
	global $xoopsDB;
	global $facemark_rules;

	if( ! is_object($xoopsDB)) return;
	$sql = 'select * from ' . $xoopsDB->prefix('smiles');
	$result = $xoopsDB->query($sql);
	while($row = $xoopsDB->fetchArray($result))
	{
		$row['code'] = preg_replace('/(\:|\(|\)|\?)/', "\\\\\\1", $row['code']);
		$row['code'] = '\s(' . $row['code'] . ')';
		$a = array($row['code'] => '<img src="../../uploads/' . $row['smile_url'] . '" alt="$1" title="' . $row['emotion'] . '" />');

		$facemark_rules = array_merge($a, $facemark_rules);
	}

}

// }}}
// {{{ bwiki_init()

function bwiki_init()
{
	global $xoopsUser;

	if(isset($xoopsUser) && is_object($xoopsUser))
	{
		define('XOOPS_UNAME', $xoopsUser->vars['uname']['value']);
	}
	else if( function_exists('xoops_gethandler') )
	{
		$config_handler =& xoops_gethandler('config');
		$config = $config_handler->getConfigsByCat(1);
		define('XOOPS_UNAME', $config['anonymous']);
	}
}

// }}}

bwiki_init();

?>
