<?php
// $Id: search.php,v 1.2 2005/09/02 20:08:53 ohwada Exp $

// 2005-09-01 K.OHWADA
// REQ 2933: easy to understand error message
// not use extract

// 2005-01-20 K.OHWADA
// w3c validation: "selected='selected'"

// 2004-11-28 K.OHWADA
// write fair, delete unnecessary comments

// 2004-10-20 K.OHWADA
// use system lang file
// _WLS_SR_xx -> _SR_xx

// 2004/08/10 K.OHWADA
// enable to install this module two or more. 
// use class ConvertLanguage

//================================================================
// search
// use class weblinksCategory, weblinksLink
// porting from system
// 2004/01/14 K.OHWADA
//================================================================

include "header.php";

$lang =& language_convert::getInstance();

// not use extract
$action = get_post_get('action', 'search');
$andor  = get_post_get('andor', 'AND');
$query  = trim( get_post_get('query') );
$start  = get_post_get_int('start');

$min   = $xoopsModuleConfig['search_min'];
$limit = $xoopsModuleConfig['search_links'];

// enable to install this module two or more. 
$xoopsOption['template_main'] = $MODULE_DIRNAME."_search.html";

// --- template start ---
include XOOPS_ROOT_PATH."/header.php";

assignIndex();
assignDisplayLink();
$xoopsTpl->assign('lang_result',  _SR_SEARCHRESULTS);
$xoopsTpl->assign('lang_showall', _SR_SHOWALLR);
$xoopsTpl->assign('lang_prev',    _SR_PREVIOUS);
$xoopsTpl->assign('lang_next',    _SR_NEXT);
$xoopsTpl->assign('lang_keyword', _SR_KEYWORDS.':');
$xoopsTpl->assign('lang_ignore', sprintf(_SR_IGNOREDWORDS, $min) );

// search form
if (($action == '') || ($action == 'search'))
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', '');
	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

// if no query
// REQ 2933: easy to understand error message
if ( (($action == "results")||($action == "showall")) && ($query == "") ) 
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', _SR_PLZENTER);
	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

$keyword = '';
$ignore  = '';
$and     = '';
$or      = '';
$exact   = '';
$queries_arr = array();
$ignored_arr = array();

if ( $andor != "OR" && $andor != "exact" && $andor != "AND" ) 
{	$andor = "AND";	}

if ($andor != 'exact') 
{
	$query_han = $lang->convert_space_zen_to_han($query);
	$temp_queries = preg_split('/[\s,]+/', $query_han);

	foreach ($temp_queries as $q) 
	{
		$q = trim($q);
		if (strlen($q) >= $min) 
		{	$queries_arr[] = $myts->addSlashes($q);	} 
		else 
		{	$ignored_arr[] = $myts->addSlashes($q);	}
	}

	foreach ($queries_arr as $q) 
	{	$keyword .= ' <b>'.htmlspecialchars(stripslashes($q)).'</b>';	}

	if (!empty($ignored_arr)) 
	{
		foreach ($ignored_arr as $q) 
		{	$ignore .= ' <b>'.htmlspecialchars(stripslashes($q)).'</b>';	}
	}

	if ($andor == 'OR') $or  = "selected='selected'";
	else                $and = "selected='selected'";

}
else 
{
	$queries_arr = array($myts->addSlashes($query));
	$keyword .= ' "<b>'.htmlspecialchars(stripslashes($queries_arr[0])).'</b>"';	
	$exact = "selected='selected'";
}

$xoopsTpl->assign('search_query',   htmlspecialchars($query) );
$xoopsTpl->assign('search_and',     $and);
$xoopsTpl->assign('search_or',      $or);
$xoopsTpl->assign('search_exact',   $exact);
$xoopsTpl->assign('search_keyword', $keyword);
$xoopsTpl->assign('search_ignore',  $ignore);

// if no queriy
// REQ 2933: easy to understand error message
if (count($queries_arr) == 0) 
{
	$xoopsTpl->assign('search_show', 0);
	$xoopsTpl->assign('search_not_show_result', sprintf(_SR_KEYTOOSHORT, $min));
	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

$xoopsTpl->assign('search_show', 1);

list ($sql1,$sql2) = $tbl_link->makeSqlSearch($queries_arr, $andor);
$count = $tbl_link->get_num_by_sql($sql1);
if ($count < 1)
{
	$xoopsTpl->assign('search_found_show', 0);
	$xoopsTpl->assign('search_not_found_result', _SR_NOMATCH);	
	include XOOPS_ROOT_PATH."/footer.php";
	exit();
}

$xoopsTpl->assign('search_found_show', 1);
$xoopsTpl->assign('search_found', sprintf(_SR_FOUND,$count));

// link list
$records = $tbl_link->get_row_array_by_sql($sql2, $limit, $start);
$count1  = count($records);
foreach ($records as $record) 
{
	$xoopsTpl->append('links', $tbl_link->makeDisplay($record));
}

// next page
if ($count > $limit)
{
	$search_showing = sprintf(_SR_SHOWING, $start+1, $start + $count1);

	$search_url  = $MODULE_URL."/search.php?query=";
	$search_url .= urlencode( stripslashes( implode( ' ', $queries_arr )));
	$search_url .= "&action=results&andor=$andor";
	$search_url_list = "<table><tr>";

	if ( $start > 0 ) 
	{
		$prev = $start - $limit;
		if ($prev < 0)  $prev = 0;

		$search_url_prev = $search_url."&start=$prev";
		$search_url_prev = htmlspecialchars($search_url_prev);
		$search_url_list .= "<td align=\"left\"><a href=\"$search_url_prev\">"._SR_PREVIOUS."</a></td>";
	}
	else
	{	$search_url_list .= "<td align=\"left\">"._SR_PREVIOUS."</td>";	}

	$search_url_list .= "<td align=\"center\">$search_showing</td>";

	$next = $start + $limit;
	if ($count > $next) 
	{
		$search_url_next = $search_url."&start=$next";
		$search_url_next = htmlspecialchars($search_url_next);
		$search_url_list .= "<td align=\"right\"><a href=\"$search_url_next\">"._SR_NEXT."</a></td>";
	}
	else
	{	$search_url_list .= "<td align=\"right\">"._SR_NEXT."</td>";	}

	$search_url_list .= "</tr></table>\n";
	$xoopsTpl->assign('search_url', $search_url_list);
}
else
{	$xoopsTpl->assign('search_url', '');	}

include XOOPS_ROOT_PATH."/footer.php";

?>