<?php
// $Id: atomfeed.inc.php,v 1.1.1.1 2005/02/16 17:32:35 ohwada Exp $

// 2005-01-20 K.OHWADA
// remote_file.php, class.image_size.php

//=========================================================
// view ATOM feed called by custom block
// created from v0.9
// 2004-11-28 K.OHWADA
//=========================================================

include_once XOOPS_ROOT_PATH."/class/snoopy.php";

$MODULE_DIRNAME = 'weblinks';
$MODULE_ROOT    = XOOPS_ROOT_PATH."/modules/".$MODULE_DIRNAME;

global $xoopsConfig;
$XOOPS_LANGUAGE = $xoopsConfig['language'];

// file include
include_once $MODULE_ROOT."/include/file_include.php";
file_include_weblinks_basic( $MODULE_DIRNAME, $XOOPS_LANGUAGE );

include_once $MODULE_ROOT."/class/table_atomfeed.php";
include_once $MODULE_ROOT."/class/table_config.php";
include_once $MODULE_ROOT."/class/language_base.php";
include_once $MODULE_ROOT."/class/class.image_size.php";
include_once $MODULE_ROOT."/class/remote_file.php";

file_include_module_convert( $MODULE_DIRNAME, $XOOPS_LANGUAGE );	

include_once $MODULE_ROOT.'/class/class.rss_atom_parser_base.php';
include_once $MODULE_ROOT.'/class/class.rss_parser.php';
include_once $MODULE_ROOT.'/class/class.atom_parser.php';
include_once $MODULE_ROOT.'/class/rss_atom_collect.php';

file_include_module_lang( 'main.php',   $MODULE_DIRNAME, $XOOPS_LANGUAGE );
file_include_module_lang( 'blocks.php', $MODULE_DIRNAME, $XOOPS_LANGUAGE );

function weblinks_view_blog($lid=0, $num_feed=10, $num_content=1, $max_summary=200)
{

	if ($lid == 0)
	{
		echo "<font color='red'>"._MB_WEBLINKS_NO_LINK_ID."</font>";
	}
	else
	{
		$collect = new rss_atom_collect();
		$collect->set_num_feed(     $num_feed );
		$collect->set_max_summary(  $max_summary );
		$collect->set_mode_content( 1 );

		$feeds   = $collect->parse_xml_for_block($lid);
		$count   = count($feeds);

		if ( $count == 0 )
		{
			echo "<font color='red'>"._MB_WEBLINKS_NO_ATOMFEED."</font>";
		}
		else
		{
			$site_title = $feeds[0]['site_title'];
			$site_url   = $feeds[0]['site_url'];

			echo "<a href='$site_url' target='_blank'>$site_title</a>\n";
			echo "<ul>";

			for ($i=0; $i<$count; $i++)
			{
				$feed = $feeds[$i];

				echo "<li>";
				echo "<a href='${feed['url']}' target='_blank'>${feed['title']}</a>&nbsp;";

    			if ( $feed['date'] )
    			{
      				echo "(${feed['date']})&nbsp;";
				}

    			echo "<br />\n";

				if ($i < $num_content)
				{
    				if ( $feed['content'] )
					{
      					echo $feed['content'];
      	   				echo "<br />\n";
      				}
      			}
      			else	
				{
    				if ( $feed['summary'] )
					{
      					echo $feed['summary'];
      	   				echo "<br />\n";
      				}
				}

				echo "<br />\n";
				echo "</li>\n";
			}

		}
	}

}

?>
