<?php
/***********************************************************************************/
/*                                                                                 */
/* XP-Weather version 1.3a(J2)                                                     */
/*         Edited by nao-pon (nao-pon@hypweb.net)                                  */
/*         http://hypweb.net/                                                      */
/* - Created Japanese Station database                                             */
/* - The addition and change of a script by having created the database.           */
/* - The Japanese display of the name of a place.                                  */
/*                                                                                 */
/* XP-Weather version 1.3a(J)                                                      */
/*         Edited by nao-pon (nao-pon@hypweb.net)                                  */
/*         http://hypweb.net/                                                      */
/* - added Japanese languege pack                                                  */
/* - and edited                                                                    */
/*    Japanese-izing of a wind direction.                                          */
/*    Wind velocity is changed into m/s from km/h.                                 */
/*    Updating time is changed at Japan Standard Time                              */
/*     (summer time consideration has not been carried out).                       */
/*                                                                                 */
/***********************************************************************************/
/*                                                                                 */
/* XP-Weather version 1.3                                                          */
/*                                                                                 */
/* 8/4/2002 - davidd                                                               */
/* - moved weather data collection to Weather class for supporting new feeds       */
/* - added proxy server support using snoopy class                                 */
/* - added unlimited value to visibility                                           */
/* - fixed flushcache test                                                         */
/* - removed hard-coded font tags for better display with dark themes              */
/* - added new unavailable messages when data is not available                     */
/*                                                                                 */
/* XP-Weather version 1.2                                                          */
/*                                                                                 */
/* 7/31/2002 - davidd                                                              */
/* msnbc.com changed weather sources from Accuweather to weather.com               */
/* - fixed forcast parsing offsets were changed                                    */
/* - added humidity and precipitation to detailed forecast                         */
/*                                                                                 */
/*                                                                                 */
/* XP-Weather version 1.1                                                          */
/* XP-Weather version 1.0                                                          */
/* XP-Weather version 0.98d                                                        */
/*         Modified again by davidd (dk@axarosenberg.com)                          */
/*         http://www.axarosenberg.com                                             */
/*                                                                                 */
/* 6/18/2002 - davidd                                                              */
/* - Added adjustable persistent cache to block and main module                    */
/* - Code Cleanup                                                                  */
/*                                                                                 */
/* 6/13/2002 - davidd                                                              */
/* - added conText weather condition text                                          */
/* - re-worked table output                                                        */
/* - added radar and percipitation map links                                       */
/* - fixed header and footer includes for template main/cblock                     */
/* - moved embeded French out to language/main.php file                            */
/*                                                                                 */
/***********************************************************************************/
/*                                                                                 */
/* XP-Weather version 0.71b                                                        */
/*         Converted by Bidou (bidou@lespace.org                                   */
/*         http://www.lespace.org                                                  */
/*                                                                                 */
/***********************************************************************************/
/*                                                                                 */
/* Based on MyWeather version 1.0                                                  */
/*         PHP and mySQL Code changes by Richard Benfield aka PcProphet            */
/*         http://www.pc-prophet.com                                               */
/*         http://www.benfield.ws                                                  */
/*                                                                                 */
/*         Html and Graphic work by Chris Myden                                    */
/*         http://www.chrismyden.com/                                              */
/*                                                                                 */
/* MyWeather version 1.0 based on World_Weather version 1.1                        */
/*         By NukeTest.com team                                                    */
/*         http://www.nuketest.com                                                 */
/*                                                                                 */
/***********************************************************************************/
/*                                                                                 */
/* Previously part of PHP-NUKE Add-On 5.0 : Weather AddOn                          */
/* ======================================================                          */
/* Brought to you by PHPNuke Add-On Team                                           */
/* Copyright (c) 2001 by Richard Tirtadji AKA King Richard (rtirtadji@hotmail.com) */
/* http://www.nukeaddon.com                                                        */
/*                                                                                 */
/***********************************************************************************/
/*                                                                                 */
/* Original code based on METEO live v1.0                                          */
/* By Martin Bolduc at martin.bolduc@littera.com                                   */
/* License : Free, do what you want, but please, let my name in reference.         */
/*                                                                                 */
/***********************************************************************************/

include_once("header.php");
$func = (isset($_POST['func']))? $_POST['func'] : "" ;
$flushcache = (isset($flushcache))? $flushcache : "" ;
$index = 0;

if ( $xoopsConfig['startpage'] == $xoopsModule->dirname() ) {

	$xoopsOption['show_rblock'] =1;
	include(XOOPS_ROOT_PATH."/header.php");
	if ( empty($HTTP_GET_VARS['start']) ) {
		make_cblock();
		echo "<br />";
	}
} else {
	$xoopsOption['show_rblock'] =0;
	include(XOOPS_ROOT_PATH."/header.php");
}
$weather_url = explode("?", $weather_url);
$weather_url = $weather_url[0];
//OpenTable();
echo "<link rel=\"stylesheet\" href=\"./style.css\" type=\"text/css\" media=\"screen\" charset=\"shift_jis\">\n";
echo "<div class=\"xp_weather_body\">\n";
switch($func) {

	case "usedefault":
		WeatherIndex(1, $flushcache);
		break;
	default:
		WeatherIndex(0, $flushcache);
		break;
}
echo "</div>\n";
//CloseTable();
include_once(XOOPS_ROOT_PATH."/footer.php");


function WeatherIndex($usedefault=0, $flushcache=0) {
	global $xoopsConfig, $xoopsModule, $module_name, $cache_time, $gifdir, $xoopsUser, $xoopsDB, $xp_weather_var;
	global $weather_url, $response_maxlength, $proxy_host, $proxy_port, $proxy_user, $proxy_pwd;

	$language = $xoopsConfig['language'];
	$outbuf = "";
	$mywd = new WeatherData;

	if ($usedefault == 0 and $xoopsUser) {
		$username = $xoopsUser->uname();

		list($userid) = mysql_fetch_row($xoopsDB->query("select uid from ".$xoopsDB->prefix("users")." where uname= '$username'"));

		list($accid, $wcid, $statype, $tpc, $tps) = mysql_fetch_row($xoopsDB->query("select accid, wcid, station_type, tpc, tps from ".$xoopsDB->prefix("userweather")." where userid='$userid'"));

	}else {
		list($accid, $wcid, $statype, $tpc, $tps) = mysql_fetch_row($xoopsDB->query("select accid, wcid, station_type, tpc, tps from ".$xoopsDB->prefix("userweather")." where userid='0'"));
	}
	if (!IsSet($accid)) {
		list($accid, $wcid, $statype, $tpc, $tps) = mysql_fetch_row($xoopsDB->query("select accid, wcid, station_type, tpc, tps from ".$xoopsDB->prefix("userweather")." where userid='0'"));
	}
	if ( !IsSet($accid) ) {
		if ( $xoopsUser->isAdmin() ) {
			echo "<br>"._UNAVAIL.""._RAISON."<br><br>\n";
			echo ""._INSTALL." <a href=\"install.php\">"._ICI."</a>.";
		} else {
			echo "<br>"._UNAVAIL._ERRORTRYAGAIN;
		}
	} else {
		$cache_file = "".XOOPS_ROOT_PATH."/modules/".$xoopsModule->dirname()."/cache/main_$language.$accid";
		$block_cache_file = "".XOOPS_ROOT_PATH."/modules/".$xoopsModule->dirname()."/cache/block_$language.$accid";
		$time = split(" ", microtime());
		srand((double)microtime()*1000000);
		$cache_time_rnd	=	300 - rand(0, 600);

		if ( $flushcache == 1 ) {
			if (file_exists($cache_file)) { unlink( $cache_file ); }
			if (file_exists($block_cache_file)) { unlink( $block_cache_file ); }
		}
		if ( (!(file_exists($cache_file))) || (((filectime($cache_file) + $cache_time - $time[1]) + $cache_time_rnd < 0) || (!(filesize($cache_file))) && $cache_time != -1) ) {
			if ( IsSet($wcid) && ($statype == "TWC" || $statype == "WMO" || $statype == "JPN") ) {
				$saved_stationid = $wcid;
				$weather_url .="?acid=$wcid";
			} else {
				$saved_stationid = $accid;
            	$weather_url .= "?acid=$accid";
            }
			$mywd->maxlength = $response_maxlength;
			if ( !empty($proxy_host) ) {
				$mywd->proxyHost = $proxy_host;
				if ( !empty($proxy_port) ) { $mywd->proxyPort = $proxy_port; }
				if ( !empty($proxy_user) ) { $mywd->User = $proxy_user; }
				if ( !empty($proxy_pwd) ) { $mywd->Pass = $proxy_pwd; }
			}
			$mywd->fetchData($weather_url);
			if ( IsSet($mywd->feedError) && !empty($mywd->feedError) ) {
				$failuremessage = "<h4><b>$module_name</b></h4>\n"._UNAVAIL.": $mywd->feedResponse ($mywd->feedError)\n";
			} else {
				$mywd->processData();
				$v_City    = $mywd->v_City;
				$v_SubDiv  = $mywd->v_SubDiv;
				$v_Country = $mywd->v_Country;
				$v_Region  = $mywd->v_Region;
				$v_Temp    = $mywd->v_Temp;
				$v_CIcon   = $mywd->getIcon($mywd->v_CIcon);
				$v_WindS   = $mywd->v_WindS;
				$v_WindD   = $mywd->v_WindD;
				$v_Baro    = $mywd->v_Baro;
				$v_Humid   = $mywd->v_Humid;
				$v_Real    = $mywd->v_Real;
				$v_UV      = $mywd->v_UV;
				$v_Vis     = $mywd->v_Vis;
				$v_LastUp  = $mywd->v_LastUp;
				$v_ConText = $mywd->v_ConText;
				$v_Fore    = explode("|", $mywd->v_Fore);
				$v_Acid    = $mywd->v_Acid;
				$v_week_correct=$mywd->v_week_correct;
				for ($i = 0; $i <= 4; $i++){
					$v_Fore[$i] = $v_Fore[$i]+$v_week_correct;
					if ($v_Fore[$i] > 7) $v_Fore[$i] = 1; 
				}
				//JapanOnly
				if ( $statype == "JPN" ){
					list($city_name) = mysql_fetch_row($xoopsDB->query("SELECT city_name from ".$xoopsDB->prefix("xpweather_city_jp")." where station_name = '$v_City'"));
					$v_City = $city_name;
				}
				if ($v_City != "" and ($v_Temp == "" and $v_CIcon == "")) {
					$failuremessage = "<h4><b>$module_name</b></h4>\n"._UNAVAIL.": $str_error ($num_error)\n";
//				} else if ($v_City == "") {
//                	$failuremessage = "<h4><b>$module_name</b></h4>\n<center>"._UNAVAIL." </center>\n<center>"._NODATA."</center>\n";
                } else {
                	if ( $v_SubDiv == "" ) {
                		if ( $statype == "JPN" ) {
                			list($wsubdiv) = mysql_fetch_row($xoopsDB->query("select subdiv.subdiv_title from ".$xoopsDB->prefix("subdiv")." subdiv inner join ".$xoopsDB->prefix("xpweather_city_jp")." jpn on subdiv.subdiv_id = jpn.subdiv_id and jpn.icao_code ='$accid'"));
							$mywd->setSubDiv($wsubdiv);
						} elseif ( $statype == "WMO" ) {
                			list($wsubdiv) = mysql_fetch_row($xoopsDB->query("select subdiv.subdiv_title from ".$xoopsDB->prefix("subdiv")." subdiv inner join ".$xoopsDB->prefix("wmo_stations")." wmo on subdiv.subdiv_id = wmo.subdiv_id and wmo.icao_code ='$accid'"));
							$mywd->setSubDiv($wsubdiv);
						} else {
                			list($wsubdiv) = mysql_fetch_row($xoopsDB->query("select subdiv.subdiv_title from ".$xoopsDB->prefix("subdiv")." subdiv inner join ".$xoopsDB->prefix("city")." city on subdiv.subdiv_id = city.subdiv_id and city.accid ='$accid'"));
							$mywd->setSubDiv($wsubdiv);
						}
					}
					if ($v_Temp == "" || $v_Temp == "0") {
						$v_Temp = ConvTemp($v_Fore[20],$tpc);
						$v_CIcon = $mywd->getIcon($v_Fore[10]);
						$v_WindS = "n/a";
						$v_WindD = "n/a";
						$v_Baro = "n/a";
						$v_Humid = "n/a";
						$v_Real = $v_Temp;
						$v_UV = "n/a";
						$v_Vis = "n/a";
					}
					$fpwrite = fopen($cache_file, 'w');
					if(!$fpwrite) {
						$failuremessage = _WRITEFAIL ." ".$cache_file;
					} else {
						if ( $v_Vis == "" ) {
							$v_Vis = _UNLIMITED;
						}
						$outbuf .= "<h4><b>$module_name "._WDETAILED."</b></h4>\n"
						._REG.": $v_Region<br>\n"
						."<b>".$mywd->getLocation2($v_City)."</b> "
						."[<a href=\"change.php\"><small>"._CHNGSET."</small></a>]\n"
						._LASTUP. " " .$v_LastUp."<br>"
						."<a href=\"http://www.weather.com/outlook/travel/local/".$saved_stationid."\" target=\"_brank\">˾ܤ....</a>"
						."<hr><table cellpadding=\"4\" cellspacing=\"0\" border=\"0\" style=\"width:auto;\"><tr><td style=\"vertical-align:top;\">\n"
						."<img src=\"images/$gifdir/current_cond.gif\" align=\"top\" alt=\""._CURCOND."\">\n"
						."<font face=\"Arial\" style=\"color:red;font-size:24px;\">".ConvTemp($v_Temp, $tpc)."</font> \n"
						."<img src=\"images/$gifdir/".$v_CIcon."\" class=\"xp_forecast\"><br>\n"
						."</td><td><table cellpadding=\"4\" cellspacing=\"5\" border=\"0\"><tr><td>\n"
						._WIND.": ".$v_WindD." ".ConvSpeed($v_WindS,$tps)."</td><td>\n"
						._BARO.": ".ConvPress($v_Baro,$tpc)." </td><td>\n"
						._HUMID.": ".$v_Humid."%</td></tr><tr><td>".$v_ConText."</td><td>\n"
						._BARO_PRES.": ".ConvPress($v_Baro,0)."</td></tr><tr><td>\n"
						._UV.": ".$v_UV."</td><td>\n"
						._REFE.": ".ConvTemp($v_Real,$tpc)."</td><td>\n"
						._VIS.": ".ConvLength($v_Vis,$tps)."</td></tr>\n"
						."</table></td></tr></table><br><table cellpadding=\"4\" cellspacing=\"0\" border=\"0\" style=\"width:auto;\">\n"
						."<tr><td valign=\"top\" class=\"xp_forecast\"><img src=\"images/$gifdir/forecast.gif\" alt=\""._FOREC."\"></td><td>&nbsp;</td><td class=\"xp_forecast\">\n"
//						._Tonight."<br><img src=\"images/$gifdir/".$mywd->getIcon($v_Fore[10])."\"></td><td class=\"xp_forecast\">\n"
						.Fore($v_Fore[0])."<br><img src=\"images/$gifdir/".$mywd->getIcon($v_Fore[10])."\"></td><td class=\"xp_forecast\">\n"
						.Fore($v_Fore[1])."<br><img src=\"images/$gifdir/".$mywd->getIcon($v_Fore[11])."\"></td><td class=\"xp_forecast\">\n"
						.Fore($v_Fore[2])."<br><img src=\"images/$gifdir/".$mywd->getIcon($v_Fore[12])."\"></td><td class=\"xp_forecast\">\n"
						.Fore($v_Fore[3])."<br><img src=\"images/$gifdir/".$mywd->getIcon($v_Fore[13])."\"></td><td class=\"xp_forecast\">\n"
						.Fore($v_Fore[4])."<br><img src=\"images/$gifdir/".$mywd->getIcon($v_Fore[14])."\"></td></tr>\n"
						."<tr><td>&nbsp;</td><td colspan=\"6\"><hr></td></tr>\n"
						."<tr><td>&nbsp;</td><td><font face=\"Arial\" color=\"red\" size=\"\">"._WHIGH.":</font></td><td class=\"xp_forecast\">\n"
						."<font face=\"Arial\" color=\"red\" size=\"\">".ConvTemp($v_Fore[20],$tpc)."</font></td><td class=\"xp_forecast\">\n"
						."<font face=\"Arial\" color=\"red\" size=\"\">".ConvTemp($v_Fore[21],$tpc)."</font></td><td class=\"xp_forecast\">\n"
						."<font face=\"Arial\" color=\"red\" size=\"\">".ConvTemp($v_Fore[22],$tpc)."</font></td><td class=\"xp_forecast\">\n"
						."<font face=\"Arial\" color=\"red\" size=\"\">".ConvTemp($v_Fore[23],$tpc)."</font></td><td class=\"xp_forecast\">\n"
						."<font face=\"Arial\" color=\"red\" size=\"\">".ConvTemp($v_Fore[24],$tpc)."</font></td></tr>\n"
						."<tr><td>&nbsp;</td><td colspan=\"6\"><hr></td></tr>\n"
						."<tr><td>&nbsp;</td><td>"._WLOW.":</td><td class=\"xp_forecast\">\n"
						.ConvTemp($v_Fore[40],$tpc)."</td><td class=\"xp_forecast\">\n"
						.ConvTemp($v_Fore[41],$tpc)."</td><td class=\"xp_forecast\">\n"
						.ConvTemp($v_Fore[42],$tpc)."</td><td class=\"xp_forecast\">\n"
						.ConvTemp($v_Fore[43],$tpc)."</td><td class=\"xp_forecast\">\n"
						.ConvTemp($v_Fore[44],$tpc)."</td</tr>\n"
						."<tr><td>&nbsp;</td><td colspan=\"6\"><hr></td></tr>\n"
						."<tr><td>&nbsp;</td><td>"._PRECIP.":</td><td class=\"xp_forecast\">\n"
						."$v_Fore[25]%</td><td class=\"xp_forecast\">\n"
						."$v_Fore[26]%</td><td class=\"xp_forecast\">\n"
						."$v_Fore[27]%</td><td class=\"xp_forecast\">\n"
						."$v_Fore[28]%</td><td class=\"xp_forecast\">\n"
						."$v_Fore[29]%\n"
						."</td></tr></table><hr><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:auto;\"><tr><td class=\"xp_forecast\">\n"
						."<table cellspacing=\"1\" cellpadding=\"0\" class='property'><tr class=\"bg3\"><td class='property'>\n"
						."<B><small>"._CURSETT.":</small></B> \n"
						."<td class='property'><a href=\"change.php\"><small>"._CHNGSET."</small></a>\n"
						."</td><tr class=\"bg3\"><td class='property'><b><small>"._REG.":</small></b></td><td class='property'><small>$v_Region</small></td></tr><tr class=\"bg3\"><td class='property'>\n"
						."<b><small>"._WCNTRY.":</small></b></td><td class='property'><small>$v_Country</small></td></tr><tr class=\"bg3\"><td class='property'>\n"
						."<b><small>"._WSUBDIV.":</small></b></td><td class='property'><small>".$mywd->getLocation()."</small></td></tr><tr class=\"bg3\"><td class='property'>\n"
						."<b><small>"._WCITY.":</small></b></td><td class='property'><small>$v_City ($saved_stationid)</small></td></tr><tr class=\"bg3\"><td class='property'>\n";
						$outbuf .= "<b><small>"._WTEMP.":</small></b></td><td class='property'><small>".ConvTemp($v_Temp,$tpc)."</small></td></tr><tr class=\"bg3\"><td class='property'>\n";
						$outbuf .= "<b><small>"._WINDSPD.":</small></b></td><td class='property'><small>".ConvSpeed($v_WindS,$tps)."</small></td></tr></TABLE>\n";
						$outbuf .= "</td>\n"
						."<td width=72 VALIGN=top><center><b>"._RADAR."</b><a href=\"http://www.wni.co.jp/cww/docs/radar.html\" target=\"_blank\"><img src=\"images/radar.gif\" width=62 height=64 ALT="._RADAR."></a></center></td>\n"
						."<td width=72 VALIGN=top><center><b>"._SATELL."</b><a href=\"http://www.wni.co.jp/cww/docs/gms/index.html\" target=\"_blank\"><img src=\"images/satellite.gif\" width=62 height=64 ALT="._SATELL."></a></center></td>\n"
						."<td width=72 VALIGN=top><center><b>"._PRECIP."</b><a href=\"http://www.wni.co.jp/cww/docs/amedas.html\" target=\"_blank\"><img src=\"images/precipitation.gif\" width=62 height=64 ALT="._PRECIP."></a></center></td>\n"
						."</tr></table>\n"
						."<div style=\"text-align:right\"><a href=\"http://hypweb.net/xoops/\"><small>XP-Weather $xp_weather_var</small></a></div>";
						fputs($fpwrite, $outbuf);
//						$outbuf .= "Cache-Miss";
					}
					fclose($fpwrite);
				}
			}
		} else {
    		if (file_exists($cache_file)) {
				$wfread	= fopen($cache_file, 'r');
				if(!$wfread) {
					$failuremessage = _READFAIL ." ". $cache_file;
				} else {
					$outbuf = fread($wfread,filesize($cache_file));
					fclose($wfread);
//					$outbuf .= "<small>From Cache</small>";
				}
    		}
    	}
        if (isset($failuremessage)) {
			$outbuf = $failuremessage;
			$outbuf .= "<br /><center>[<a href=\"change.php\"><small>"._CHNGSET."</small></a>]</center>\n";
    	}
	}
    echo $outbuf;
}
?>