<?php
// $Id: func.rss.php,v 1.3 2005/08/09 02:17:10 ohwada Exp $

// 2005-08-08 K.OHWADA
// description became one line

// 2005-06-20 K.OHWADA
// add whatsnew_view_rss()
// use ConvertLanguage()
// use version.php

//=========================================================
// What's New Module
// build RSS 
// 2004/08/20 K.OHWADA
//=========================================================

include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/include/func.whatsnew.php';
include_once XOOPS_ROOT_PATH."/modules/whatsnew/include/version.php";
include_once XOOPS_ROOT_PATH.'/modules/whatsnew/class/base_language.php';

// for local language
$file_convert = XOOPS_ROOT_PATH.'/modules/whatsnew/language/'.$xoopsConfig['language'].'/convert_language.php';

if (file_exists( $file_convert )) 
{
	include_once $file_convert;
}
else
{
	include_once XOOPS_ROOT_PATH.'/modules/whatsnew/language/english/convert_language.php';
}

function whatsnew_build_rss($cache_time=0)
{
	$TEMPLATE    = 'db:whatsnew_rss.html';
	$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";

	if ( file_exists($FILE_CONFIG) ) 
	{
		include $FILE_CONFIG;
	}
	else
	{
		return;
	}

// no output encode
	if (function_exists('mb_http_output')) 
	{	mb_http_output('pass');	}

	header ('Content-Type:text/xml; charset=utf-8');

	$tpl = new XoopsTpl();

	if ($cache_time > 0)
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime($cache_time);
	}

	if ( !$tpl->is_cached($TEMPLATE) || ($cache_time == 0) ) 
	{
		$article_arr = whatsnew_get_new($whatsnew_module, 'rss_show', 'rss_limit', $whatsnew_rss_limit_show);
		whatsnew_assign_rss( $tpl, $article_arr, $whatsnew_config );
	}

	$tpl->display($TEMPLATE);
}

function whatsnew_view_rss()
{
	$TEMPLATE    = 'db:whatsnew_rss.html';
	$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";

	if ( file_exists($FILE_CONFIG) ) 
	{
		include $FILE_CONFIG;
	}
	else
	{
		return;
	}

	header ('Content-Type:text/html; charset=utf-8');

	$tpl = new XoopsTpl();

	$article_arr = whatsnew_get_new($whatsnew_module, 'rss_show', 'rss_limit', $whatsnew_rss_limit_show);
	whatsnew_assign_rss( $tpl, $article_arr, $whatsnew_config );

	$xml  = $tpl->fetch($TEMPLATE);
	$body = htmlspecialchars( $xml, ENT_QUOTES );

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>whats new rss</title>
</head>
<body>
<pre>
<?php echo $body; ?>
</pre>
</body>
</html>
<?php

}

//---------------------------------------------------------
// http://blogs.law.harvard.edu/tech/rss
// required paramter
// channel elements 
//   - title
//   - link
//   - description
// item elements
//   - title
//   - link
//   - description
//---------------------------------------------------------
function whatsnew_assign_rss( &$tpl, $article_arr, $config )
{
	$lang = new ConvertLanguage();

	$CATEGORY  = "Whats New";
	$GENERATOR = 'XOOPS WhatsNew '._WHATSNEW_VERSION;

	$site_name_utf8 = $lang->convert_to_utf8( htmlspecialchars( $config['site_name'], ENT_QUOTES) );
	$tpl->assign('channel_title', $site_name_utf8 );

	$site_url = $config['site_url'];
	$tpl->assign('channel_link', $site_url);

	$tpl->assign('channel_desc', $lang->convert_to_utf8( htmlspecialchars( $config['site_desc'], ENT_QUOTES) ) );

	$lastbuild = date("r");
	$tpl->assign('channel_lastbuild', $lastbuild);

	if ( isset($config['site_email']) )
	{
		$tpl->assign('channel_webmaster', $config['site_email'] );
		$tpl->assign('channel_editor',    $config['site_email'] );
	}

	$tpl->assign('channel_category',  $CATEGORY);
	$tpl->assign('channel_generator', $GENERATOR);
	$tpl->assign('channel_language', _LANGCODE);

	if ( isset($config['image_url']) )
	{
		$tpl->assign('image_url',    $config['image_url'] );
		$tpl->assign('image_width',  $config['image_width'] );
		$tpl->assign('image_height', $config['image_height'] );
		$tpl->assign('image_title',  $site_name_utf8 );
		$tpl->assign('image_link',   $site_url );
	}

	$max_summary = $config['rss_max_summary'];

	foreach ($article_arr as $article)
	{
		$title = $lang->convert_to_utf8( htmlspecialchars ($article['title'], ENT_QUOTES) );
		$link  = $article['link'];

		$pubdate = '';
		if ( isset($article['time']) )
		{
			$pubdate = date("r", $article['time']);
		}

		$desc = '';
		if ( isset($article['description']) )
		{
			$desc = $article['description'];
			$desc = whatsnew_sanitize_control_code($desc);

// description became one line
			$desc = whatsnew_sanitize_crlf( $desc );

			$desc = strip_tags($desc);
			$desc = whatsnew_shorten_text( $desc, $max_summary );
			$desc = whatsnew_htmlspecialchars($desc);
			$desc = $lang->convert_to_utf8( $desc );
		}

		$tpl->append('items', 
			array(
				'title'       => $title,
				'link'        => $link,
				'guid'        => $link,
				'pubdate'     => $pubdate, 
				'description' => $desc
			));
	}

}

function whatsnew_clear_rss()
{
	$TEMPLATE = 'db:whatsnew_rss.html';

	$tpl = new XoopsTpl();
	$tpl->clear_cache($TEMPLATE);
}

?>
