<?php
// $Id: func.ping.php,v 1.1.1.2 2005/06/10 18:28:56 ohwada Exp $

// 2005-06-06 K.OHWADA
// get and set encode

//=========================================================
// What's New Module
// send weblog update ping
// 2004/08/20 K.OHWADA
//=========================================================

include_once XOOPS_ROOT_PATH."/modules/whatsnew/class/base_language.php";
include_once XOOPS_ROOT_PATH."/modules/whatsnew/class/class.weblog_updates.php";
include_once XOOPS_ROOT_PATH."/modules/whatsnew/class/class.http_client.php";

function whatsnew_send_ping($flag_print=0)
{
	$FILE_CONFIG = XOOPS_ROOT_PATH."/modules/whatsnew/cache/conf.php";
	$FILE_PING   = XOOPS_ROOT_PATH."/modules/whatsnew/cache/ping.time.log";

	$PING_TIMEOUT = 3;	// 3 sec

	if ( file_exists($FILE_CONFIG) ) 
	{
		include $FILE_CONFIG;
	}
	else
	{
		return;
	}

	$today = date("Y/m/d H:i:s");

	if ($whatsnew_ping_log)
	{
		$fp = fopen($FILE_PING, "a");
		fwrite($fp,"$today \n");
	}

	$blog_name = $whatsnew_config['site_name'];
	$blog_url  = $whatsnew_config['site_url'];

	$ping_arr = split("\n", $whatsnew_ping_servers);

// get encode
	$lang = new ConvertLanguage();
	$encode = $lang->get_encode();

// set encode
	$ping = new weblog_updates();
	$ping->set_encode( $encode );

	if ($flag_print >= 2)
	{
		$ping->set_debug();
	}

	foreach ($ping_arr as $url)
	{
	 	if (empty($url))  continue;

  		$ping->set_blog_data($blog_name, $blog_url);
  		$ping->send_ping($url, $PING_TIMEOUT, $PING_TIMEOUT);
		$result = $ping->make_result( $ping->get_result() );

		if ($flag_print >= 1)
		{
			print $result;
		}

		if ($whatsnew_ping_log)
		{
			fwrite($fp,$result);
		}
	}

	if ($whatsnew_ping_log)
	{
		fclose($fp);
	}
}


function whatsnew_check_ping($time_article)
{
	$FILE_PING   = XOOPS_ROOT_PATH."/modules/whatsnew/cache/ping.time.log";

	if ( !file_exists($FILE_PING) )
	{
		$time_ping = 0;
	}
	else
	{
		$time_ping = filemtime($FILE_PING);
	}

	if ( $time_article > $time_ping )
	{
		return true;	// OK
	}

	touch($FILE_PING);

	return false;	// NG
}

?>
