<?php
/*
 * $Id: entry.php,v 1.6 2005/03/20 11:20:20 tohokuaiki Exp $
 * Copyright (c) 2003 by Hiro SAKAI (http://wellwine.zive.net/)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting
 * source code which is considered copyrighted (c) material of the
 * original comment or credit authors.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

include_once(XOOPS_ROOT_PATH.'/class/xoopsobject.php');

class WeblogEntry extends XoopsObject {
    /**
     * Constructs an instance of this class
     */
    function WeblogEntry() {
        global $xoopsModuleConfig ;
        $default_dohtml = ( $xoopsModuleConfig['default_dohtml'] ) ? 0 : 1 ;
        $default_private = ( $xoopsModuleConfig['default_private'] ) ? "Y" : "N" ;
        $default_updateping = ( $xoopsModuleConfig['default_updateping'] ) ? 1 : 0 ;
        
        $this->XoopsObject();

        $this->initVar("blog_id", XOBJ_DTYPE_INT, 0, false);
        $this->initVar("user_id", XOBJ_DTYPE_INT, 0, true);
        $this->initVar("cat_id", XOBJ_DTYPE_INT, 0, true);
        $this->initVar("created", XOBJ_DTYPE_INT, 0, true);
        $this->initVar("title", XOBJ_DTYPE_TXTBOX, null, true, 128, true);
        $this->initVar("contents", XOBJ_DTYPE_TXTAREA, null, true, null, true);
        $this->initVar("comments", XOBJ_DTYPE_INT, 0, false);
        $this->initVar("reads", XOBJ_DTYPE_INT, 0, false);
        $this->initVar("trackbacks", XOBJ_DTYPE_INT, 0, false);
        $this->initVar("dohtml", XOBJ_DTYPE_INT, $default_dohtml, false);
        $this->initVar("private", XOBJ_DTYPE_TXTBOX, $default_private, true, 1, true);
        $this->initVar("updateping", XOBJ_DTYPE_INT, $default_updateping, false);
        $this->initVar("ent_trackbackurl", XOBJ_DTYPE_TXTBOX, null, false);

        $this->initVar("uname", XOBJ_DTYPE_TXTBOX, null, false);
        $this->initVar("user_avatar", XOBJ_DTYPE_TXTBOX, null, false);
    }

    function isPrivate() {
        return ($this->getVar('private', 'n')=='Y') ? true : false;
    }

    function doHtml() {
        return ($this->getVar('dohtml')==1) ? true : false;
    }

    function isUpdateping() {
        return ($this->getVar('updateping')==1) ? true : false;
    }
}

class WeblogEntryHandler extends XoopsObjectHandler {

    function &create() {
        return new WeblogEntry();
    }
    
    function &get($blog_id) {
        $blog_id = intval($blog_id);
        if ($blog_id > 0 ) {
            $sql = sprintf('SELECT bl.blog_id, bl.user_id, bl.cat_id, bl.created, bl.title, bl.contents, bl.private, bl.comments, bl.reads, bl.dohtml, bl.trackbacks, u.uname, u.user_avatar FROM %s as bl, %s as u WHERE blog_id=%d AND bl.user_id=u.uid',
                           $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY),
                           $this->db->prefix(WEBLOG_DB_PREFIX_USERS), $blog_id);
            if ($result = $this->db->query($sql)) {
                if ($this->db->getRowsNum($result)==1) {
                    $entry = $this->create();
                    $entry->assignVars($this->db->fetchArray($result));
                    return $entry;
                }
            }
        }
        return false;
    }

    function insert(&$entry) {
        if (get_class($entry) != 'weblogentry') {  // must be lowercase only
            return false;
        }
        if (!$entry->isDirty()) {
            return true;
        }
        if (!$entry->cleanVars()) {
            return false;
        }

        foreach ($entry->cleanVars as $k => $v) {
            ${$k} = $v;
        }

        $count = $this->getCount(new Criteria('blog_id', $blog_id));
        if ($blog_id > 0 && $count > 0) {
            $sql = sprintf('UPDATE %s SET user_id=%d, cat_id=%d, created=%d, title=%s, contents=%s, private=%s, dohtml=%d WHERE blog_id=%d',
                           $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY),
                           $user_id, $cat_id, $created,
                           $this->db->quoteString($title),
                           $this->db->quoteString($contents),
                           $this->db->quoteString($private),
                           $dohtml,
                           $blog_id );
        } else {
            $sql = sprintf('INSERT INTO %s (user_id, cat_id, created, title, contents, private, dohtml) VALUES (%d, %d, %d, %s, %s, %s, %d)',
                           $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY),
                           $user_id, $cat_id, $created,
                           $this->db->quoteString($title),
                           $this->db->quoteString($contents),
                           $this->db->quoteString($private),
                           $dohtml );
        }
        if (!$result = $this->db->queryF($sql)) {  // must be queryF()
            return false;
        }

        if (empty($blog_id)) {
            $entry->setVar('blog_id', $this->db->getInsertId());
        }

        return true;
    }
    
    function delete(&$entry) {
        if (get_class($entry) != 'weblogentry') {
            return false;
        }

        $sql = sprintf('DELETE FROM %s WHERE blog_id=%d LIMIT 1',
                       $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY), $entry->getVar('blog_id'));
        if (!$result = $this->db->queryF($sql)) {  // must be queryF()
            return false;
        }
        return true;
    }

    function getCount($criteria=null) {
        $sql = sprintf('SELECT count(*) as count FROM %s', $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY));
        if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) {
            $sql .= sprintf(' %s', $criteria->renderWhere());
        }
        if (!$result = $this->db->query($sql)) {
            return 0;
        }
        $count = $this->db->fetchArray($result);
        return $count['count'];
    }

    function &getObjects($criteria=null, $id_as_key=false) {
        $ret = array();
        $limit = $start = 0;

        $sql = sprintf('SELECT bl.blog_id, bl.user_id, bl.cat_id, bl.created, bl.title, bl.contents, bl.private, bl.comments, bl.reads, bl.trackbacks, bl.dohtml, bl.trackbacks, u.uname, u.user_avatar FROM %s as bl, %s as u',
                       $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY),
                       $this->db->prefix(WEBLOG_DB_PREFIX_USERS));
        if (isset($criteria) && is_subclass_of($criteria, 'criteriaelement')) {
            $sql .= sprintf(' %s %s', $criteria->renderWhere(), 'AND bl.user_id=u.uid');
            //$groupby = trim(str_replace('GROUP BY', "", $criteria->getGroupby()));
            //$sql .= ($groupby=='')?'':sprintf(' %s', $criteria->getGroupby());
            $sort = ($criteria->getSort()!='') ? $criteria->getSort() : 'blog_id';
            $sql .= sprintf(' ORDER BY %s %s', $sort, $criteria->getOrder());
            $limit = $criteria->getLimit();
            $start = $criteria->getStart();
        } else {
            $sql .= sprintf(' %s', 'WHERE bl.user_id=u.uid');
        }
        if (!$result = $this->db->query($sql, $limit, $start)) {
            return $ret;
        }
        while ($myrow = $this->db->fetchArray($result)) {
            $entry = $this->create();
            $entry->assignVars($myrow);
            if ($id_as_key) {
                $ret[$myrow['blog_id']] =& $entry;
            } else {
                $ret[] =& $entry;
            }
            unset($entry);
        }
        return $ret;
    }

    function incrementReads($blog_id) {
        $blog_id = intval($blog_id);
        $sql = sprintf('UPDATE %s SET reads = reads + 1 WHERE blog_id=%d',
                       $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY), $blog_id);
        if (!$result = $this->db->queryF($sql)) {  // must be queryF()
            return -1;
        }
        $sql = sprintf('SELECT reads FROM %s WHERE blog_id=%d',
                       $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY), $blog_id);
        if (!$result = $this->db->query($sql)) {
            return -1;
        }
        $reads = $this->db->fetchArray($result);
        return $reads['reads'];
    }

    function incrementTrackbacks($blog_id , $increment_num=1) {
        $blog_id = intval($blog_id);
		if( $increment_num > 0 ){
			$increment_num = "+" . $increment_num ;
		}elseif( $increment_num < 0 ){
			$increment_num = "-" . abs($increment_num) ;
		}else{
			return true ;
		}
        $sql = sprintf('UPDATE %s SET trackbacks = trackbacks %s WHERE blog_id=%d',
                       $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY), $increment_num , $blog_id);
        if (!$result = $this->db->queryF($sql)) {  // must be queryF()
            return -1;
        }
		return true ;
    }

    function updateComments($blog_id, $total_num) {
        $blog_id = intval($blog_id);
        $total_num = intval($total_num);
        $sql = sprintf('UPDATE %s SET comments=%d WHERE blog_id=%d',
                       $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY),
                       $total_num, $blog_id);
        if (!$result = $this->db->queryF($sql)) {  // must be queryF()
            return -1;
        }

        $sql = sprintf('SELECT comments FROM %s WHERE blog_id=%d',
                       $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY), $blog_id);
        if (!$result = $this->db->query($sql)) {
            return -1;
        }
        $comments = $this->db->fetchArray($result);
        return $comments['comments'];
    }

    function getPrevNextBlog_id($blog_id , $extra=null) {
        $return_id = array() ;
        $blog_id = intval($blog_id);
        $sql_prev = sprintf('SELECT max(blog_id) as prev FROM %s where blog_id<%d', $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY) , $blog_id );
        $sql_next = sprintf('SELECT min(blog_id) as next FROM %s where blog_id>%d', $this->db->prefix(WEBLOG_DB_PREFIX_ENTRY) , $blog_id );
        if ( isset($extra) ) {
            $sql_prev .= $extra ;
            $sql_next .= $extra ;
        }
        if ($result = $this->db->query($sql_prev)) {
            if($prev = $this->db->fetchArray($result)){
				$return_id['prev'] = $prev['prev'] ;
			}
        }
        if ($result = $this->db->query($sql_next)) {
            if( $next = $this->db->fetchArray($result) ){
				$return_id['next'] = $next['next'] ;
			}
        }
        return $return_id;
    }
}
?>