<?php
// $Id: file_include.php,v 1.1.1.1 2005/02/16 17:32:35 ohwada Exp $

// 2005-01-20 K.OHWADA
// remote_file.php, class.image_size.php

//================================================================
// function for file include
// created since v0.9
// 2004-11-28 K.OHWADA
//================================================================

//---------------------------------------------------------
// function
//---------------------------------------------------------
function file_include_weblinks_basic( $dirname='weblinks', $language='english' )
{
	$module_root = XOOPS_ROOT_PATH."/modules/".$dirname;

	include_once $module_root."/conf.php";	// this line is first

	include_once $module_root."/class/module_base.php";
	include_once $module_root."/class/table_link_base.php";
	include_once $module_root."/class/table_link.php";

}

function file_include_weblinks( $dirname='weblinks', $language='english' )
{
	$module_root = XOOPS_ROOT_PATH."/modules/".$dirname;

// include files
	file_include_weblinks_basic( $dirname, $language );

	include_once $module_root."/include/functions.php";
	include_once $module_root."/class/table_modify.php";
	include_once $module_root."/class/table_category.php";
	include_once $module_root."/class/table_broken.php";
	include_once $module_root."/class/table_votedata.php";
	include_once $module_root."/class/table_catlink.php";
	include_once $module_root."/class/table_atomfeed.php";
	include_once $module_root."/class/table_config.php";
	include_once $module_root."/class/remote_file.php";
	include_once $module_root."/class/language_base.php";
	include_once $module_root."/class/class.image_size.php";

	file_include_module_convert( $dirname, $language );	

}

function file_include_module_convert( $dirname='weblinks', $language='english' )
{
	$module_root = XOOPS_ROOT_PATH."/modules/".$dirname;

// dummy for non multibyte environment
	if (!extension_loaded('mbstring') && !function_exists('mb_convert_encoding'))
	{
		include_once $module_root."/include/mb_dummy.php";
	}

// for local language
	$file_convert = $module_root."/language/".$language."/language_convert.php";

	if (file_exists( $file_convert )) 
	{
		include_once $file_convert;
	}
	else
	{
		include_once $module_root."/language/english/language_convert.php";
	}
}

function file_include_module_lang( $filename, $dirname='weblinks', $language='english' )
{
	$module_root = XOOPS_ROOT_PATH."/modules/".$dirname;

	$file_lang = $module_root."/language/".$language."/".$filename;
	if ( file_exists($file_lang) ) 
	{
		include_once $file_lang;
	}
	else 
	{
		include_once $module_root."/language/english/".$filename;
	}
}

function file_include_system_lang( $filename, $language='english' )
{
	$file_lang = XOOPS_ROOT_PATH."/language/".$language."/".$filename;
	if ( file_exists($file_lang) ) 
	{
		include_once $file_lang;
	}
	else
	{
		include_once XOOPS_ROOT_PATH."/language/english/".$filename;
	}
}

function file_include_system_module_lang( $filename, $language='english' )
{

	$file_lang = XOOPS_ROOT_PATH."/modules/system/language/".$language."/".$filename;
	if ( file_exists($file_lang) ) 
	{
		include_once $file_lang;
	}
	else
	{
		include_once XOOPS_ROOT_PATH."/modules/system/language/english/".$filename;
	}
}


?>