<?php
// $Id: table_link.php,v 1.7 2005/07/25 12:33:35 ohwada Exp $

// 2005-07-25 K.OHWADA
// BUG 2793: Fatal error: Call to undefined function: _print_sql_error()

// 2005-07-20 K.OHWADA
// BUG 2790: not show rss site

// 2005-06-13 K.OHWADA
//  bug fix: _make_desc_short(): display BB code in short description

// 2005-03-12 K.OHWADA
// bug fix: getLidArrayByRssFlag(): except broken link

// 2005-02-18 K.OHWADA
// bug fix: except broken link in getLidArrayByCid()
// bug fix: misjudge to check url

// 2005-02-03 K.OHWADA
// bug fix: Mapfan disregards a space or subsequent ones. 

// 2005-01-20 K.OHWADA
// add updateImageSize()
// add $config_newdays
// add zip, state, city, addr2, fax
// add _check_fill(), _check_url()

// 2004-11-28 K.OHWADA
// use table_link_base

// 2004-11-20 K.OHWADA
// HTML tag become effective in link list display.
// cutoff of double byte code is not sometimes right.

// 2004-10-24 K.OHWADA
// recommend site, mutual site
//   add variable recommend, mutual
// broken link check
//   add variable broken, limit_broken
//   add function countupBroken(), getNumByMark(), getLidArrayByMark()
//       getNumPublic(), 
// URL-less mode
//   add variable flag_url_check
//   add function blankHttpPostUrl()
// enable to modeify the display layout of a category path in the template 
//   add function getCatPath()
// change procedure of banner image
// newid cannot be got in advance
// addr map
// RSS/ATOM URL
// user comment
// bug fix: cannot be set individually image use in list mode and detail mode

// 2004/08/10 K.OHWADA
// use class weblinksCatlink
// remove cids
// save banner size to link table
// enable to install this module two or more. 
// convert EUC-JP to SJIS at telafreind

// 2004/02/05 K.OHWADA
// not public mode of name & mail when edit

// 2004/01/31 K.OHWADA
// makeDescShort strip_tags

//=========================================================
// class table_link
// 2004/01/14 K.OHWADA
//=========================================================

class table_link extends table_link_base
{
// display
	var $flag_admin;
	var $flag_url;
	var $flag_new;
	var $flag_update;
	var $flag_pop;
	var $flag_addr;
	var $name_disp;
	var $mail_disp;
	var $votes_disp;
	var $rating_disp;
	var $addr_encode;
	var $catpaths;
	var $update;
	var $update_short;
	var $mail_subject;
	var $mail_body;

// user list
	var $lid_user_arr;
	var $uid_user_arr;

// check
	var $error_msg_flag_lid_full;
	var $error_msg_flag_lid_part;
	var $error_msg_lid_arr_full;
	var $error_msg_lid_arr_part;

// xoopsModuleConfig
	var $config_popular;
	var $config_newdays;
	var $config_descshort;
	var $config_broken;

//	weblinksConfig;
	var $config_check_double;
	var $config_use_ratelink;
	var $config_is_auth_ratelink;

// local

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function table_link()
{

	table_link_base::table_link_base( 'link' );

	global $xoopsModuleConfig;
	$this->config_popular     = $xoopsModuleConfig['popular'];
	$this->config_newdays     = $xoopsModuleConfig['newdays'];
	$this->config_descshort   = $xoopsModuleConfig['descshort'];

// BUG 2793: Fatal error: Call to undefined function: _print_sql_error()
// use broken in command line
	$BROKEN_DEFAULT = 5;
	if ( isset($xoopsModuleConfig['broken']) )
	{
		$this->config_broken = $xoopsModuleConfig['broken'];
	}
	else
	{
		$this->config_broken = $BROKEN_DEFAULT;
	}

	global $weblinksConfig;
	$this->config_check_double     = $weblinksConfig['check_double'];
	$this->config_use_ratelink     = $weblinksConfig['use_ratelink'];
	$this->config_is_auth_ratelink = $weblinksConfig['is_auth_ratelink'];

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new table_link();
	}

	return $instance;
}

//---------------------------------------------------------
// insert
//---------------------------------------------------------
// for addLinkLink()
function insert()
{ 
	$passwd = $this->make_passwd_md5();

	$time = time();
	$time_create = $time;
	$time_update = $time;

	$sql  = "INSERT INTO $this->table (";

	$sql .= "uid, ";
	$sql .= "title, url, ";
	$sql .= "name, nameflag, ";
	$sql .= "mail, mailflag, ";
	$sql .= "company, ";
	$sql .= "zip, state, city, ";
	$sql .= "addr, addr2, ";
	$sql .= "tel, fax, ";
	$sql .= "description, ";
	$sql .= "usercomment, ";
	$sql .= "admincomment, ";
	$sql .= "rss_url, rss_flag, ";
	$sql .= "recommend, mutual, ";
	$sql .= "passwd, ";
	$sql .= "search, ";
	$sql .= "banner, width, height, ";
	$sql .= "time_create, time_update ";

	$sql .= ") VALUES (";

	$sql .= "$this->uid, ";
	$sql .= "'$this->title', '$this->url', ";
	$sql .= "'$this->name', $this->nameflag, ";
	$sql .= "'$this->mail', $this->mailflag, ";
	$sql .= "'$this->company', ";
	$sql .= "'$this->zip', '$this->state', '$this->city',";
	$sql .= "'$this->addr', '$this->addr2', ";
	$sql .= "'$this->tel', '$this->fax', ";
	$sql .= "'$this->description', ";
	$sql .= "'$this->usercomment', ";
	$sql .= "'$this->admincomment', ";
	$sql .= "'$this->rss_url', $this->rss_flag, ";
	$sql .= "$this->recommend, $this->mutual, ";
	$sql .= "'$passwd', ";
	$sql .= "'$this->search', ";
	$sql .= "'$this->banner', $this->width, $this->height, ";
	$sql .= "$time_create, $time_update ";

	$sql .= ")";

	return $this->query_insert($sql);
}

//---------------------------------------------------------
// update
//---------------------------------------------------------
// for admin/modify.php: 
function update($lid)
{
	$passwd = $this->make_passwd_md5();

	$sql  = "UPDATE $this->table SET ";

	$sql .= "uid=$this->uid, ";
	$sql .= "title='$this->title', ";
	$sql .= "url='$this->url', ";
	$sql .= "name='$this->name', ";
	$sql .= "nameflag=$this->nameflag, ";
	$sql .= "mail='$this->mail', ";
	$sql .= "mailflag=$this->mailflag, ";
	$sql .= "company='$this->company', ";
	$sql .= "zip='$this->zip', ";
	$sql .= "state='$this->state', ";
	$sql .= "city='$this->city', ";
	$sql .= "addr='$this->addr', ";
	$sql .= "addr2='$this->addr2', ";
	$sql .= "tel='$this->tel', ";
	$sql .= "fax='$this->fax', ";
	$sql .= "description='$this->description', ";
	$sql .= "usercomment='$this->usercomment', ";
	$sql .= "admincomment='$this->admincomment', ";
	$sql .= "rss_url='$this->rss_url', ";
	$sql .= "rss_flag=$this->rss_flag, ";
	$sql .= "recommend=$this->recommend, ";
	$sql .= "mutual=$this->mutual, ";
	$sql .= "passwd='$passwd', ";
	$sql .= "search='$this->search', ";
	$sql .= "banner='$this->banner', ";
	$sql .= "width=$this->width, ";
	$sql .= "height=$this->height, ";
	$sql .= "time_update=$this->time_update, ";

	$sql .= "rss_update=0, ";
	$sql .= "rss_xml='', ";
	$sql .= "broken=$this->broken ";

	$sql .= " WHERE lid = $lid";

	return $this->query_false($sql);
}

function updateImageSize($lid, $width, $height)
{
	$sql = "UPDATE $this->table SET width=$width, height=$height WHERE lid=$lid";
	return $this->query_false($sql);
}

// for lostpass.php
function updatePasswd($lid, $passwd)
{
	$passwd = md5($passwd);
	$sql = "UPDATE $this->table SET passwd='$passwd' WHERE lid=$lid";
	return $this->query_false($sql);
}

// for ratelink.php:
function updateRating($lid, $rating, $votes)
{
	$sql = "UPDATE $this->table SET rating=$rating, votes=$votes WHERE lid=$lid";
	return $this->query_false($sql);
}

// RSS feed
// for singlelink.php
function updateRssUrl($lid, $rss_flag, $rss_url)
{
	$sql = "UPDATE $this->table SET rss_flag=$rss_flag, rss_url='$rss_url' WHERE lid=$lid";
	return $this->query_false($sql);
}

// for singlelink.php
function updateRssXml($lid, $rss_update, $rss_xml )
{
	$sql = "UPDATE $this->table SET rss_update=$rss_update, rss_xml='$rss_xml' WHERE lid=$lid";
	return $this->query_false($sql);
}

function updateRssUpdate($lid, $rss_update)
{
	$sql = "UPDATE $this->table SET rss_update=$rss_update WHERE lid=$lid";
	return $this->query_false($sql);
}

// for visit.php
function countupHits($lid)
{
	$sql = "UPDATE $this->table SET hits = hits+1 WHERE lid=$lid";
	return $this->query_false($sql);
}

// for class.link_broken.php
function countupBroken($lid)
{
	$sql = "UPDATE $this->table SET broken = broken+1 WHERE lid=$lid";
	return $this->query_false($sql);
}

// for future
function updateComment($lid, $comments)
{
	$sql = "UPDATE $this->table SET comments=$comments WHERE lid=$lid";
	return $this->query_false($sql);
}
//---------------------------------------------------------
// delete
//---------------------------------------------------------
// for admin/link.php
function delete($lid)
{
	$sql = "DELETE FROM $this->table WHERE lid= $lid";
	return $this->query_false($sql);
}

//---------------------------------------------------------
// select
//---------------------------------------------------------
// for admin/index.php, others
function getNumAll()
{
	$sql = "SELECT count(*) FROM $this->table";
    return $this->get_num_by_sql($sql);
}

// for index.php
// except broken link
function getNumPublic()
{
	$sql = "SELECT count(*) FROM $this->table WHERE broken < $this->config_broken";
	return $this->get_num_by_sql($sql);
}

// for checkFormAddLink()
function getNumByUrl($url)
{
	$sql = "SELECT count(*) FROM $this->table WHERE url='$url'";
	return $this->get_num_by_sql($sql);
}

// for viewmark.php:
// except broken link
function getNumByMark($mark)
{
	$sql = "SELECT count(*) FROM $this->table WHERE ($mark=1 AND broken < $this->config_broken )";
	return $this->get_num_by_sql($sql);
}

// for admin/index.php, others
function getNumBroken()
{
	$sql = "SELECT count(*) FROM $this->table WHERE broken > 0";
	return $this->get_num_by_sql($sql);
}


function getNumRssFlag()
{
	$sql = "SELECT count(*) FROM $this->table WHERE ( rss_flag=1 OR rss_flag=2 )";
	return $this->get_num_by_sql($sql);
}

function getNumNoUrl()
{
	$sql = "SELECT count(*) FROM $this->table WHERE url=''";
	return $this->get_num_by_sql($sql);
}

// for func.link_check.php
function getRowsAll($limit=0,$offset=0)
{
	$sql = "SELECT * FROM $this->table ORDER BY lid";
	return $this->get_row_array_by_sql($sql,$limit,$offset);
}

// for class.link_broken.php
function getLidArrayAll($limit=0,$offset=0)
{
	$sql = "SELECT lid FROM $this->table ORDER BY lid";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

function getLidArrayAllDesc($limit=0,$offset=0)
{
	$sql = "SELECT lid FROM $this->table ORDER BY lid DESC";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

// for singlelink.php, others
function getRowByLid($lid)
{
	$sql = "SELECT * FROM $this->table WHERE lid=$lid";
	return $this->get_row_by_sql($sql);
}

// for index.php
function getRowsLatest($limit=0,$offset=0)
{
	return $this->getRowsByOrderby("time_update DESC",$limit,$offset);
}

// except broken link
function getRowsByOrderby($orderby="time_update DESC",$limit=0,$offset=0)
{
	$sql = "SELECT * FROM $this->table WHERE broken < $this->config_broken ORDER BY $orderby";
	return $this->get_row_array_by_sql($sql,$limit,$offset);
}

// for viewmark.php
// except broken link
function getLidArrayByMark($mark,$orderby,$limit=0,$offset=0)
{
	$sql = "SELECT lid FROM $this->table WHERE ( $mark=1 AND broken < $this->config_broken ) ORDER BY $orderby";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

// bug fix: except broken link
function getLidArrayByRssFlag($orderby="lid", $limit=0,$offset=0)
{
	$sql = "SELECT lid FROM $this->table WHERE  ( rss_flag=1 OR rss_flag=2 ) AND broken < $this->config_broken ORDER BY $orderby";

// BUG 2790: not show rss site
// mistake to delete necessary line
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

// for random.php
function getLidArrayByRandom()
{
	$lids = $this->getLidArrayPublic();

	srand( (float)microtime()*1000000 );
	shuffle($lids);

	return $lids;
}

// for viewrandom.php
function getRowsByRandom($limit=1)
{
	$lids = $this->getLidArrayByRandom();

	$rows = array();
	for ($i=0; $i<$limit; $i++)
	{
		$rows[$i] = $this->getRowByLid( $lids[$i] );
	}

	return $rows;
}

// for visit.php
function getSaniUrlByLid($lid)
{
	$this->getRowByLid($lid);
	$url = $this->conv_js($this->url);
	$url = htmlspecialchars($url);
	return $url;
}

function getLidArrayBroken($limit=0,$offset=0)
{
	$sql = "SELECT lid FROM $this->table WHERE broken > 0 ORDER BY lid";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

function getLidArrayNoUrl($limit=0,$offset=0)
{
	$sql = "SELECT lid FROM $this->table WHERE url='' ORDER BY lid";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

function getLidArrayByUrl($url, $limit=0, $offset=0)
{
	$sql = "SELECT lid FROM $this->table WHERE url='$url'";
	return $this->get_first_row_by_sql($sql, $limit, $offset);
}

// for future
// except broken link
function getLidArrayPublic($limit=0,$offset=0)
{
	$sql = "SELECT lid FROM $this->table WHERE broken < $this->config_broken ORDER BY lid";
	return $this->get_first_row_by_sql($sql,$limit,$offset);
}



//---------------------------------------------------------
// search
// for search.php
//---------------------------------------------------------
function search($queryarray, $andor='AND', $limit=0, $offset=0, $uid=0)
{
	list ($sql1,$sql2) = $this->makeSqlSearch($queryarray, $andor, $uid);
	return $this->get_row_array_by_sql($sql2, $limit, $offset);
}

// except broken link
function makeSqlSearch($queryarray, $andor='AND', $uid=0)
{
	$where = '';
	if ( $uid != 0 ) 
	{	$where .= "uid=$uid ";	}

	if ( is_array($queryarray) && $count = count($queryarray) )
	{
		if ($where)  $where .= "AND ";
		$where .= "( search LIKE '%$queryarray[0]%' ";

		for ($i=1; $i<$count; $i++)
		{
			$where .= "$andor ";
			$where  .= "search LIKE '%$queryarray[$i]%' ";
		}
		$where .= ") ";
	}

	$where .= " AND broken < $this->config_broken ";

	$sql1 = "SELECT count(*) FROM $this->table WHERE $where";
	$sql2 = "SELECT * FROM $this->table WHERE $where ORDER BY time_update DESC";

	return array($sql1,$sql2);
}

//---------------------------------------------------------
// add new link
// for submit.php
//---------------------------------------------------------
function checkFormAddLink($arr)
{
	$url  = $arr['url'];
	$flag = 0;

	$this->clear_error_msg();

	$this->error_msg_flag_lid_full = 0;
	$this->error_msg_flag_lid_part = 0;
	$this->error_msg_lid_arr_full  = array();
	$this->error_msg_lid_arr_part  = array();

	if ( $this->checkFormModLink($arr, 1) )
	{	$flag = 1;	}	// error

	if ( $this->config_check_double >= 1 )
	{
		if ( $this->_check_url_full( $url ) )
		{	$flag = 1;	}	// error
	}

	if ($flag)  return 1;

	if ( $this->config_check_double == 2 )
	{
		if ( $this->_check_url_part( $url ) )
		{	return 2;	}	// warning
	}

	return 0;	// OK
}

function getErrorMsgAddLink()
{
	$text = '';

	if ( $this->error_msg_flag )
	{
		$text .= $this->get_error_msg();
	}

	if ( $this->error_msg_flag_lid_full ) 
	{
		$text .= $this->make_error_msg(_WLS_ERROR_URL_EXIST );
		$text .= $this->_make_error_url( $this->error_msg_lid_arr_full );
	}

	if ( $this->error_msg_flag_lid_part ) 
	{
		$text .= $this->make_error_msg(_WLS_WARNING_URL_EXIST );
		$text .= $this->_make_error_url( $this->error_msg_lid_arr_part );
	}

	return $text;
}

function addLink( $post )
{
	$ret = $this->addLinkLink( $post );
	if (!$ret) return FALSE;

	$ret = $this->_add_catlink($this->newid, $this->cid_arr);
	if (!$ret) return FALSE;

	return TRUE;
}

function addLinkAppove( $post )
{
	$ret = $this->addLinkLinkAppove( $post );
	if (!$ret) return FALSE;

	$ret = $this->_add_catlink($this->newid, $this->cid_arr);
	if (!$ret) return FALSE;

	return TRUE;
}

function blankHttpPostUrl()
{
	global $HTTP_POST_VARS;

	$url = $HTTP_POST_VARS['url'];

	if ($url == "http://")
	{	$url = '';	}

	if ($url == "https://")
	{	$url = '';	}

	$HTTP_POST_VARS['url'] = $url;
}

function _check_url_full($url)
{
	if (( $url == "" )||( $url == "http://" ))
	{	return 0;	}	// no check

	$this->error_msg_lid_arr_full = $this->getLidArrayByUrl($url);
	if ( count($this->error_msg_lid_arr_full) > 0 ) 
	{
		$this->error_msg_flag_lid_full = 1;
		return 1;	// NG
	}

	return 0;	// OK
}

function _check_url_part($url)
{
	if (( $url == "" )||( $url == "http://" ))
	{	return 0;	}	// no check

	$arr_out = array();

	$lid_arr = $this->getLidArrayAll();
	foreach ($lid_arr as $lid)
	{
		$flag = 0;

		$this->getRowByLid($lid);
		$url_db   = $this->url;
		$url_db_r = str_replace("|", '\|', $url_db);
		$url_r    = str_replace("|", '\|', $url);

		if ( preg_match("|$url_db_r|", $url) )
		{	$flag = 1;	}

		if ( preg_match("|$url_r|", $url_db) )
		{	$flag = 1;	}

		if ($flag)
		{
			$arr_out[] = $lid;
		}
	}

	$this->error_msg_lid_arr_part = $arr_out;
	if ( count($this->error_msg_lid_arr_part) > 0 ) 
	{
		$this->error_msg_flag_lid_part = 1;
		return 1;	// NG
	}

	return 0;	// OK
}

function _make_error_url($lid_arr)
{
	$text = "<ul>";

	foreach( $lid_arr as $lid )
	{
		$text .= $this->_make_error_url_single($lid);
	}

	$text .= "</ul>\n";

	return $text;
}

function _make_error_url_single($lid)
{
	$this->getRowByLid($lid);
	$url   = $this->get_field_value_text('url',   'S');
	$title = $this->get_field_value_text('title', 'S');
	$text  = "<li><a href='$url' target='_blank'>$title</a></li>\n";
	return $text;
}

//---------------------------------------------------------
// modify link
// for modlink.php
//---------------------------------------------------------
function checkFormModLink($arr, $owner=0)
{
	global $weblinksConfig;
	$post_desc = $weblinksConfig['post_desc'];

	$this->clear_error_msg();

// check fill
	$this->_check_fill($arr['title'],   'post_title',   _WLS_SITETITLE);
	$this->_check_fill($arr['company'], 'post_company', _WLS_COMPANY);
	$this->_check_fill($arr['zip'],     'post_zip',     _WLS_ZIP);
	$this->_check_fill($arr['state'],   'post_state',   _WLS_STATE);
	$this->_check_fill($arr['city'],    'post_city',    _WLS_CITY);
	$this->_check_fill($arr['addr'],    'post_addr',    _WLS_ADDR);
	$this->_check_fill($arr['addr2'],   'post_addr2',   _WLS_ADDR2);
	$this->_check_fill($arr['tel'],     'post_tel',     _WLS_TEL);
	$this->_check_fill($arr['fax'],     'post_fax',     _WLS_FAX);

	if ($owner)
	{
		$this->_check_fill($arr['name'],    'post_name',    _WLS_NAME);
		$this->_check_fill($arr['mail'],    'post_mail',    _WLS_EMAIL);
		$this->_check_fill($arr['usercomment'], 'post_usercomment', _WLS_USER_COMMENT);
	}

// url check
	$this->_check_url($arr['url'],     'post_url',     _WLS_SITEURL);
	$this->_check_url($arr['banner'],  'post_banner',  _WLS_BANNERURL);
	$this->_check_url($arr['rss_url'], 'post_rss_url', _WLS_RSS_URL);

// check description'
	$flag_desc = 0;

	if ( isset( $arr['description'] ) && $arr['description'] )
	{	$flag_desc = 1;	}

	if ( isset( $arr['description_text'] ) && $arr['description_text'] )
	{	$flag_desc = 1;	}

	if (( $post_desc == 2 )&&( !$flag_desc ))
	{
		$msg = sprintf(_WLS_ERROR_FILL, _WLS_DESCRIPTION);
		$this->set_error_msg( $msg );
	}

// cid check
	$flag_cid = false;
	foreach ($arr['cid'] as $cid)
	{
		if ($cid != 0)  $flag_cid = true;
	}

	if ( !$flag_cid )
	{
		$this->set_error_msg( _WLS_ERROR_CID );
	}

	return $this->error_msg_flag;
}

function checkFormModLinkAdmin($arr)
{
	$this->checkFormModLink($arr, 1);
}

function getErrorMsgModLink()
{
	return $this->get_error_msg();
}

function modLink( $post )
{
	$this->clear_items(); 
	$this->set_items( $post );
	$this->uid = $this->xoops_user_uid;	// new owner

	$this->make_tbox_data_4_save();
	$this->get_and_set_banner_size();

	$ret = $this->update( $this->lid );
	if (!$ret) return false;

	return $this->_mod_catlink($this->lid, $this->cid_arr);
}

function modLinkAdmin( $post )
{
	$this->clear_items(); 
	$this->set_items( $post );

	$this->make_tbox_data_4_save();
	$this->get_and_set_banner_size();

	$ret = $this->update( $this->lid );
	if (!$ret) return false;

	return $this->_mod_catlink($this->lid, $this->cid_arr);
}

function _check_fill($text, $post, $msg)
{
	global $weblinksConfig;
	$post_check = $weblinksConfig[$post];

	if ( ($post_check == 2) && ($text == "") )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $msg);
		$this->set_error_msg( $msg );
	}
}

function _check_url($url, $post, $msg)
{
	global $weblinksConfig;
	$post_check = $weblinksConfig[$post];

// bug fix: misjudge to check url
	$flag_empty    = false;
	$flag_illegal = false;

	if ( ($url == "") || ($url == "http://") )
	{
		$flag_empty = true;
	}
	elseif ( !preg_match("|^https?://|", $url) || preg_match("/javascript:/si", $url) )
	{
		$flag_illegal = true;
	}

	if ( ( $post_check == 2 ) && $flag_empty )
	{
		$msg = sprintf(_WLS_ERROR_FILL, $msg);
		$this->set_error_msg( $msg );
	}

	if ( $flag_illegal )
	{
		$msg = sprintf(_WLS_ERROR_ILLEGAL, $msg);
		$this->set_error_msg( $msg );
	}

}

//---------------------------------------------------------
// display to template
//---------------------------------------------------------
// for index.php, others
function makeDisplay($arr_rec='')
{
	if (!empty($arr_rec))  $this->make_field_value($arr_rec);

	$this->make_addional_data_for_display();

	$cid_arr  = $this->get_cid_array_from_catlink();
	$catpaths = $this->_get_cat_path($cid_arr);

	$arr_out = array(
		'catpaths'       => $catpaths,

		'flag_admin'     => $this->flag_admin,
		'flag_url'       => $this->flag_url,
		'flag_new'       => $this->flag_new,
		'flag_update'    => $this->flag_update,
		'flag_pop'       => $this->flag_pop,
		'flag_addr'      => $this->flag_addr,
		'votes_disp'     => $this->votes_disp,
		'rating_disp'    => $this->rating_disp,
		'addr_encode'    => $this->addr_encode,
		'update'         => $this->update,
		'update_short'   => $this->update_short,
		'mail_subject'   => $this->mail_subject,
		'mail_body'      => $this->mail_body,
		'image_link_width'   => $this->image_link_width,
		'image_link_height'  => $this->image_link_height,
		'image_list_width'   => $this->image_list_width,
		'image_list_height'  => $this->image_list_height,
		'image_list_width_5' => $this->image_list_width_5,

		'image_url'      => $this->makeData4Show($this->image_url),

		'name_disp'      => $this->xoops_myts->makeTboxData4Show($this->name_disp),
		'mail_disp'      => $this->xoops_myts->makeTboxData4Show($this->mail_disp),

		'desc_short'     => $this->xoops_myts->makeTareaData4Show($this->desc_short, 0),

// table field
		'lid'            => $this->lid,
		'uid'            => $this->uid,
		'hits'           => $this->hits,
		'rating'         => $this->rating,
		'hits'           => $this->hits,
		'votes'          => $this->votes,
		'comments'       => $this->comments,
		'flag_recommend' => $this->recommend,
		'flag_mutual'    => $this->mutual,
		'rss_flag'       => $this->rss_flag,
		'width'          => $this->width,
		'height'         => $this->height,
		'time_create'    => $this->time_create,
		'time_update'    => $this->time_update,
		'rss_update'     => $this->rss_update,

		'url'          => $this->makeData4Show($this->url),
		'banner'       => $this->makeData4Show($this->banner),
		'rss_url'      => $this->makeData4Show($this->rss_url),

		'title'        => $this->xoops_myts->makeTboxData4Show($this->title),
		'company'      => $this->xoops_myts->makeTboxData4Show($this->company),
		'zip'          => $this->xoops_myts->makeTboxData4Show($this->zip),
		'state'        => $this->xoops_myts->makeTboxData4Show($this->state),
		'city'         => $this->xoops_myts->makeTboxData4Show($this->city),
		'addr'         => $this->xoops_myts->makeTboxData4Show($this->addr),
		'addr2'        => $this->xoops_myts->makeTboxData4Show($this->addr2),
		'tel'          => $this->xoops_myts->makeTboxData4Show($this->tel),
		'fax'          => $this->xoops_myts->makeTboxData4Show($this->fax),

		'description'  => $this->xoops_myts->makeTareaData4Show($this->description,  0),
		'admincomment' => $this->xoops_myts->makeTareaData4Show($this->admincomment, 0),

	);

	return $arr_out;
}

function make_data_4_preview()
{

	$catpaths = $this->_get_cat_path($this->cid_arr);

	$arr_out = array(
		'catpaths'       => $catpaths,

		'flag_admin'     => $this->flag_admin,
		'flag_url'       => $this->flag_url,
		'flag_new'       => $this->flag_new,
		'flag_update'    => $this->flag_update,
		'flag_pop'       => $this->flag_pop,
		'flag_addr'      => $this->flag_addr,
		'votes_disp'     => $this->votes_disp,
		'rating_disp'    => $this->rating_disp,
		'addr_encode'    => $this->addr_encode,
		'update'         => $this->update,
		'update_short'   => $this->update_short,
		'mail_subject'   => $this->mail_subject,
		'mail_body'      => $this->mail_body,
		'image_link_width'   => $this->image_link_width,
		'image_link_height'  => $this->image_link_height,
		'image_list_width'   => $this->image_list_width,
		'image_list_height'  => $this->image_list_height,
		'image_list_width_5' => $this->image_list_width_5,

		'name_disp'      => $this->xoops_myts->makeTboxData4Preview($this->name_disp),
		'mail_disp'      => $this->xoops_myts->makeTboxData4Preview($this->mail_disp),
		'image_url'      => $this->xoops_myts->makeTboxData4Preview($this->image_url),

		'desc_short'     => $this->xoops_myts->makeTareaData4Preview($this->desc_short, 0),

// table field
		'lid'            => $this->lid,
		'hits'           => $this->hits,
		'comments'       => $this->comments,
		'flag_recommend' => $this->recommend,
		'flag_mutual'    => $this->mutual,
		'rss_flag'       => $this->rss_flag,

		'title'        => $this->xoops_myts->makeTboxData4Preview($this->title),
		'company'      => $this->xoops_myts->makeTboxData4Preview($this->company),
		'zip'          => $this->xoops_myts->makeTboxData4Preview($this->zip),
		'state'        => $this->xoops_myts->makeTboxData4Preview($this->state),
		'city'         => $this->xoops_myts->makeTboxData4Preview($this->city),
		'addr'         => $this->xoops_myts->makeTboxData4Preview($this->addr),
		'addr2'        => $this->xoops_myts->makeTboxData4Preview($this->addr2),
		'tel'          => $this->xoops_myts->makeTboxData4Preview($this->tel),
		'fax'          => $this->xoops_myts->makeTboxData4Preview($this->fax),
		'rss_url'      => $this->xoops_myts->makeTboxData4Preview($this->rss_url),

		'description'  => $this->xoops_myts->makeTareaData4Preview($this->description,  0),
		'admincomment' => $this->xoops_myts->makeTareaData4Preview($this->admincomment, 0),
	);

	return $arr_out;
}

function make_addional_data_for_display()
{
	$this->flag_admin  = 0;
	$this->flag_url    = 0;
	$this->flag_new    = 0;
	$this->flag_update = 0;
	$this->flag_pop    = 0;
	$this->flag_addr   = 0;

	$this->addr_encode        = '';
	$this->name_disp          = '';
	$this->mail_disp          = '';
	$this->votes_disp         = '';
	$this->rating_disp        = '';
	$this->update             = '';
	$this->update_short       = '';
	$this->image_url          = '';
	$this->image_link_width   = '';
	$this->image_link_height  = '';
	$this->image_list_width   = '';
	$this->image_list_height  = '';
	$this->image_list_width_5 = '';
	$this->mail_subject       = '';
	$this->mail_body          = '';

	$this->catpaths = array();

	if ( $this->is_xoops_user_admin ) 
	{	$this->flag_admin = 1;	}

	if ( $this->url )
	{	$this->flag_url = 1;	}

	if ($this->state || $this->city || $this->addr || $this->addr2)
	{
		$this->flag_addr = 1;	

// bug fix: Mapfan disregards a space or subsequent ones. 
		$addr = $this->state.$this->city.$this->addr;

		$this->addr_encode = urlencode( $addr );
	}

	if ($this->votes == 1) 
	{	$this->votes_disp = _WLS_ONEVOTE;	} 
	else
	{	$this->votes_disp = sprintf(_WLS_NUMVOTES, $this->votes);	}

	$this->rating_disp = number_format($this->rating, 2);

// image
	if ( $this->config_newdays > 0 )
	{
		$startdate = time() - (86400 * $this->config_newdays);

		if ( $startdate < $this->time_create ) 
		{
			$this->flag_new = 1;
		}
		elseif ( $startdate < $this->time_update )
		{
			$this->flag_update = 1;
		}
	}

	if ( $this->config_popular > 0 )
	{
		if ( $this->hits >= $this->config_popular )
		{
			$this->flag_pop = 1;
		}
	}

// name & mail
	if ($this->nameflag && $this->name && $this->mailflag && $this->mail )
	{
		$this->name_disp = $this->name;
		$this->mail_disp = $this->mail;
	}
	elseif ($this->mailflag && $this->mail )
	{
		$this->name_disp = 'Email';
		$this->mail_disp = $this->mail;
	}
	elseif ($this->nameflag && $this->name )
	{
		$this->name_disp = $this->name;
	}

	$this->update       = formatTimestamp($this->time_update, "m");
	$this->update_short = formatTimestamp($this->time_update, "s");

	$this->_make_desc_short();
	$this->make_image();
	$this->makeMail($this->lid);

}

function _make_desc_short($text='')
{
	if (empty($text)) $text = $this->description;

	$text = preg_replace("/[\n|\r]/",' ',$text);

	if (strlen($text) > $this->config_descshort)
	{
// bug fix: display BB code in short description 
// rendering before shorten text
		$text = $this->xoops_myts->makeTareaData4Show($text);

		$text = strip_tags($text);
		$text = $this->shorten_text($text, $this->config_descshort);
	}

	$this->desc_short = $text;

//	$text = $this->xoops_myts->makeTareaData4Show($text,0);

	return $text;
}

//---------------------------------------------------------
// display to form
//---------------------------------------------------------
function make_preview_in_form()
{
//	$selbox = $this->tbl_category->makeEditCidSelbox($this->cid_arr);

	$arr_out = array(
// for submit
		'linkhead'    => '',
		'post'        => '',
		'passwd'      => '',
		'request'     => '',
		'notify_show'      => 0,

// user
		'nameflag'  => $this->nameflag,
		'mailflag'  => $this->mailflag,
		'uid'       => $this->uid,
		'name'      => $this->xoops_myts->makeTboxData4PreviewInForm($this->name),
		'mail'      => $this->xoops_myts->makeTboxData4PreviewInForm($this->mail),

// table field
		'lid'       => $this->lid,
		'recommend' => $this->recommend,
		'mutual'    => $this->mutual,
		'rss_flag'  => $this->rss_flag,

		'url'       => $this->xoops_myts->makeTboxData4PreviewInForm($this->url),
		'banner'    => $this->xoops_myts->makeTboxData4PreviewInForm($this->banner),
		'rss_url'   => $this->xoops_myts->makeTboxData4PreviewInForm($this->rss_url),
		'title'     => $this->xoops_myts->makeTboxData4PreviewInForm($this->title),
		'company'   => $this->xoops_myts->makeTboxData4PreviewInForm($this->company),
		'zip'       => $this->xoops_myts->makeTboxData4PreviewInForm($this->zip),
		'state'     => $this->xoops_myts->makeTboxData4PreviewInForm($this->state),
		'city'      => $this->xoops_myts->makeTboxData4PreviewInForm($this->city),
		'addr'      => $this->xoops_myts->makeTboxData4PreviewInForm($this->addr),
		'addr2'     => $this->xoops_myts->makeTboxData4PreviewInForm($this->addr2),
		'tel'       => $this->xoops_myts->makeTboxData4PreviewInForm($this->tel),
		'fax'       => $this->xoops_myts->makeTboxData4PreviewInForm($this->fax),

		'description'  => $this->xoops_myts->makeTareaData4PreviewInForm($this->description),
		'usercomment'  => $this->xoops_myts->makeTareaData4PreviewInForm($this->usercomment),
		'admincomment' => $this->xoops_myts->makeTareaData4PreviewInForm($this->admincomment),

// arrenge
//		'selbox'   => $selbox,
		'cid_arr'  => $this->cid_arr,

// admin
		'mid'          => '',
		'time_create'  => '',
		'time_update'  => '',

		);

	return $arr_out;
}

//---------------------------------------------------------
// display for edit
//---------------------------------------------------------
function makeEditDisplay($arr_rec='', $owner=0)
{
	if (!empty($arr_rec))  $this->make_field_value($arr_rec);

	$this->make_name_mail_edit($owner);

	$arr_out = $this->make_data_4_edit();
	$arr_out['linkhead'] = _WLS_REQUESTMOD;
	$arr_out['post']     = _EDIT;
	$arr_out['cid_arr']  = $this->get_cid_array_from_catlink( $this->lid );

	return $arr_out;
}

function makeEditDisplayAdmin($arr_rec='')
{
	if (!empty($arr_rec))  $this->make_field_value($arr_rec);

	$this->make_name_mail_edit_for_owner();

	$arr_1 = $this->make_data_4_edit();
	$arr_2 = $this->make_data_4_edit_admin();

	$arr_out = array_merge($arr_1, $arr_2);
	$arr_out['linkhead'] = _WLS_REQUESTMOD;
	$arr_out['post']     = _EDIT;
	$arr_out['cid_arr']  = $this->get_cid_array_from_catlink( $this->lid );
	return $arr_out;
}

function makeEditDisplayApprove($arr_rec)
{
	$this->make_field_value($arr_rec);
	$this->make_name_mail_edit_for_owner();

	$arr_1 = $this->make_data_4_edit();
	$arr_2 = $this->make_data_4_edit_admin();

	$arr_out = array_merge($arr_1, $arr_2);
	$arr_out['linkhead'] = _WLS_REQUESTMOD;
	$arr_out['post']     = _EDIT;
	$arr_out['cid_arr']  = $this->get_cid_array_from_catlink( $this->lid );

	return $arr_out;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function _get_single_link($lid=0)
{
	if (empty($lid)) $lid = $this->lid;

	$link = $this->module_url."/singlelink.php?lid=".$lid;
	return $link;
}

//---------------------------------------------------------
// user list
//---------------------------------------------------------
function get_lid_user_list()
{
	$lid_user_arr  = array();

	$uid_user_list = $this->get_xoops_user_list();

	$lid_arr = $this->getLidArrayAll();
	foreach ($lid_arr as $lid)
	{
		$row   = $this->getRowByLid($lid);
		$uid   = $row['uid'];
		$name  = $row['name'];
		$email = $row['mail'];
		$title = $row['title'];
		$url   = $row['url'];

		$uid_uname = $uid_user_list[$uid]['uname'];
		$uid_email = $uid_user_list[$uid]['email'];

		if ($name)
		{
			$name_disp = $name;
		}
		else
		{
			$name_disp = $title;
		}

		$email_disp = '';
		if ($email)
		{
			$email_disp = $email;
		}
		elseif (($uid > 1) && $uid_email)
		{
			$email_disp = $uid_email;
		}

		$lid_user_arr[$lid] = array(
			'lid'        => $lid,
			'uid'        => $uid,
			'name'       => $name,
			'email'      => $email,
			'title'      => $title,
			'url'        => $url,
			'uid_uname'  => $uid_uname,
			'uid_email'  => $uid_email,
			'name_disp'  => $name_disp,
			'email_disp' => $email_disp,
		);

		$uid_user_list[$uid]['use'] = 1;

		if ($uid > 1)
		{
			$uid_user_list[$uid]['lid'][] = $lid;
		}

	}

	$this->lid_user_arr  = $lid_user_arr;
	$this->uid_user_list = $uid_user_list;

	return $lid_user_arr;
}

function get_lid_email_list()
{
	$lid_email_arr = array();
	$email_arr     = array();

	if ( !$this->lid_user_arr )
	{
		$this->get_lid_user_list();
	}

	foreach ($this->lid_user_arr as $lid => $user)
	{

		$email = $user['email_disp'];

// check duplication
		if ( empty($email) )  continue;
		if ( in_array($email, $email_arr) )
		{
//			echo "omit $lid $email <br />\n";
			continue;
		}

		$email_arr[]     = $email;
		$lid_email_arr[] = $lid;
	}

	return $lid_email_arr;
}

function get_uid_use_list()
{
	return $this->uid_use_arr;
}

function get_uid_user_list()
{
	return $this->uid_user_list;
}

//=========================================================
// use tabel_cateogry class
//=========================================================
function _get_cat_path($cid_arr='')
{
	if (empty($cid_arr)) $cid_arr = $this->cid_arr;

	$this->tbl_category->getAll();

	$path_array = array();

	foreach ($cid_arr as $cid)
	{
		$path_array[] = $this->tbl_category->getParentPath($cid);
	}

	return $path_array;
}


//=========================================================
// use table_catlink class
//=========================================================
// for topten.php, viewcat.php
// except broken link
function getLidArrayByCid($cid,$orderby,$limit=0,$offset=0)
{
	$sql = "SELECT DISTINCT l.lid FROM $this->table l, $this->tbl_catlink_table c WHERE ( c.cid=$cid AND l.broken < $this->config_broken AND l.lid=c.lid ) ORDER BY l.$orderby";

	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

// for topten.php, viewcat.php
// except broken link
function getLidArrayByCidArray($arr,$orderby,$limit=0,$offset=0)
{
	$count = count($arr);

	if ($count == 0 ) return array();

	$where = " ( c.cid=$arr[0] ";
	for ($i=1; $i<$count; $i++){
		$where .= " OR c.cid=$arr[$i] ";
	}
	$where .= " ) ";

	$sql = "SELECT DISTINCT l.lid FROM $this->table l, $this->tbl_catlink_table c WHERE ( $where AND l.broken < $this->config_broken AND l.lid=c.lid ) ORDER BY l.$orderby";

	return $this->get_first_row_by_sql($sql,$limit,$offset);
}

function _add_catlink($lid=0, $cid_arr='')
{
	if (empty($lid))     $lid     = $this->lid;
	if (empty($cid_arr)) $cid_arr = $this->cid_arr;

	foreach ($cid_arr as $cid)
	{	$ret = $this->tbl_catlink->insert($cid, $lid);
		if (!$ret) return FALSE;
	}

	return TRUE;
}

function _mod_catlink($lid=0, $cid_arr='')
{
	if (empty($lid))     $lid     = $this->lid;
	if (empty($cid_arr)) $cid_arr = $this->cid_arr;

	$ret = $this->_del_catlink($lid);
	if (!$ret) return FALSE;

	return $this->_add_catlink($lid, $cid_arr);
}

function _del_catlink($lid=0)
{
	if (empty($lid))  $lid = $this->lid;

	return $this->tbl_catlink->deleteByLid($lid);
}

//=========================================================
// use language_convert class
//=========================================================
// for myheader.php
function makeMail($lid=0)
{
	if (empty($lid)) $lid = $this->lid;

	$subject = sprintf(_WLS_INTRESTLINK,  $this->xoops_site_name);
	$body    = sprintf(_WLS_INTLINKFOUND, $this->xoops_site_name).": ".$this->_get_single_link($lid);

// --- effective only in Japanese environment ---
// convert EUC-JP to SJIS
	$subject = $this->lang->convert_telafriend_subject($subject);
	$body    = $this->lang->convert_telafriend_body($body);

	$subject = rawurlencode($subject);
	$body    = rawurlencode($body);

	$this->mail_subject = $subject;
	$this->mail_body    = $body;

	return array($subject,$body);
}

//=========================================================
// use XoopsTpl class
//=========================================================
function assignDisplayLink(&$tpl)
{
	$tpl->assign('module_url', $this->module_url);

// index
	$tpl->assign('lang_lastupdate',      _WLS_LASTUPDATE);
	$tpl->assign('lang_hits',            _WLS_HITS);
	$tpl->assign('lang_rating',          _WLS_RATING);
	$tpl->assign('lang_more',            _WLS_MORE);
	$tpl->assign('lang_image_new',       _WLS_SITE_NEW);
	$tpl->assign('lang_image_update',    _WLS_SITE_UPDATE);
	$tpl->assign('lang_image_popular',   _WLS_SITE_POPULAR);
	$tpl->assign('lang_image_recommend', _WLS_SITE_RECOMMEND);
	$tpl->assign('lang_image_mutual',    _WLS_SITE_MUTUAL);

// singlelink
	$tpl->assign('lang_visit' ,          _WLS_VISIT);
	$tpl->assign('lang_category' ,       _WLS_CATEGORY);
	$tpl->assign('lang_promoter',        _WLS_PROMOTER);
	$tpl->assign('lang_zip',             _WLS_ZIP);
	$tpl->assign('lang_addr',            _WLS_ADDR);
	$tpl->assign('lang_tel',             _WLS_TEL);
	$tpl->assign('lang_fax',             _WLS_FAX);
	$tpl->assign('lang_description',     _WLS_DESCRIPTION);
	$tpl->assign('lang_admincommnet',    _WLS_ADMINCOMMENT);
	$tpl->assign('lang_modify',          _WLS_MODIFY);
	$tpl->assign('lang_editthislink' ,   _WLS_EDITTHISLINK);
	$tpl->assign('lang_ratethissite',    _WLS_RATETHISSITE);
	$tpl->assign('lang_reportbroken',    _WLS_REPORTBROKEN);
	$tpl->assign('lang_tellafriend',     _WLS_TELLAFRIEND);
	$tpl->assign('lang_comments' ,       _COMMENTS);

//	$tpl->assign('lang_latestlistings' , _WLS_LATESTLIST);

// use_ratelink
	if ( $this->config_use_ratelink )
	{
		$tpl->assign('ratelink_show', 1 );
		$tpl->assign('ratelink_post', $this->config_is_auth_ratelink );
	}
	else
	{
		$tpl->assign('ratelink_show', 0);
		$tpl->assign('ratelink_post', 0);
	}

// language
	$tpl->assign('xoops_language', $this->xoops_site_language );
	$tpl->assign('country',        $this->lang->get_country() );

// banner
	global $xoopsModuleConfig;
	$tpl->assign('link_image_use', $xoopsModuleConfig['linkimage_use']);
	$tpl->assign('list_image_use', $xoopsModuleConfig['listimage_use']);

}

//---------------------------------------------------------
}
?>
