<?php
/**
 *
 * @package XCube
 * @version $Id: XCube_Utils.class.php,v 1.1.2.5.2.3 2007/03/05 03:22:46 minahito Exp $
 * @copyright Copyright 2005, 2006 XOOPS Cube Project <http://xoopscube.org/>
 * @license http://xoopscube.sourceforge.net/bsd_licenses.txt Modified BSD license
 *
 */

/**
 * The utility class.
 */
class XCube_Utils
{
	/**
	Display redirect message and execute redirect.
	You can not continue your routine, because this method call exit().
	
	@todo I must solve direct HTML code.
	@param $url string
	@param $time intval
	@param $message If you want to multiline message, you must set message as array.
	
	@deprecated Don't use static function of XCube layer for redirect.
	 */
	function redirectHeader($url, $time, $messages = null)
	{
		$root =& XCube_Root::getSingleton();
		$root->mController->executeRedirect($url, $time, $messages);
	}

	/**
	 * @static
	 * @brief Formats string with special care for international.
	 * @remark This method doesn't implement the provider which knows how to
	 *         format for each locales. So, this method is interim implement.
	 */
	function formatString()
	{
		$arr = func_get_args();
		
		if(count($arr)==0)
			return null;
		
		$message = $arr[0];
		
		$variables = array();
		if (is_array($arr[1])) {
			$variables = $arr[1];
		}
		else {
			$variables = $arr;
			array_shift($variables);
		}
		
		for ($i = 0; $i < count($variables); $i++) {
			$message = str_replace("{" . ($i) . "}", $variables[$i], $message);
			
			// Temporary....
			$message = str_replace("{" . ($i) . ":ucFirst}", ucfirst($variables[$i]), $message);
			$message = str_replace("{" . ($i) . ":toLower}", strtolower($variables[$i]), $message);
			$message = str_replace("{" . ($i) . ":toUpper}", strtoupper($variables[$i]), $message);
		}
		
		return $message;
	}

	/**
	 * @deprecated
	 * @see XCube_Utils::formatString()
	 */	
	function formatMessage()
	{
		$arr = func_get_args();
		
		if (count($arr) == 0) {
			return null;
		}
		else if (count($arr) == 1) {
			return XCube_Utils::formatString($arr[0]);
		}
		else if (count($arr) > 1) {
			$vals = $arr;
			array_shift($vals);
			return XCube_Utils::formatString($arr[0], $vals);
		}
	}
	
	/**
	 * @deprecated
	 */
	function formatMessageByMap($subject,$arr)
	{
		$searches=array();
		$replaces=array();
		foreach($arr as $key=>$value) {
			$searches[]="{".$key."}";
			$replaces[]=$value;
		}

		return str_replace($searches,$replaces,$subject);
	}
}

?>