<?php
/**
 *
 * @package Legacy
 * @version $Id: modifier.xoops_escape.php,v 1.1.2.2 2006/12/16 14:10:29 nobunobu Exp $
 * @copyright Copyright 2005, 2006 XOOPSCube.org <http://xoopscube.org/> 
 * @license http://www.gnu.org/licenses/gpl.txt GNU GENERAL PUBLIC LICENSE Version 2
 *
 */

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     modifier
 * Name:     xoops_escape
 * Author:   nobunobu
 * Purpose:  Escape the string according to escapement type(XOOPS custom version)
 * @param string
 * @param show|edit|plain|link
 * @return string
 * 
 * Examples: {$msg|xoops_excape}
 * -------------------------------------------------------------
 */

function smarty_modifier_xoops_escape($string, $esc_type = 'show')
{
    $root =& XCube_Root::getSingleton();
    $textFilter =& $root->getTextFilter();
    switch ($esc_type) {
        case 'show':
            return $textFilter->ToShow($string);

        case 'edit':
            return $textFilter->ToEdit($string);

        case 'plain':
        case 'link':
            return htmlspecialchars($string, ENT_QUOTES);

        default:
            return $string;
    }
}
?>
