<?php
// $Id: module.textsanitizer.php,v 1.2.8.9.2.3 2006/12/09 14:11:48 nobunobu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (http://www.myweb.ne.jp/, http://jp.xoops.org/)        //
//         Goghs Cheng (http://www.eqiao.com, http://www.devbeez.com/)       //
// Project: The XOOPS Project (http://www.xoops.org/)                        //
// ------------------------------------------------------------------------- //

/**
 * Class to "clean up" text for various uses
 *
 * <b>Singleton</b>
 *
 * @package     kernel
 * @subpackage  core
 *
 * @author      Kazumi Ono  <onokazu@xoops.org>
 * @author      Goghs Cheng
 * @copyright   (c) 2000-2003 The Xoops Project - www.xoops.org
 */
class MyTextSanitizer
{
    /**
     *
     */
    var $censorConf;

	/**
	 * @var XCube_TextFilter
	 */
	var $mTextFilter = null;

	/**
	 * @var XCube_Delegate
     * @deprecated
	 */
	var $mMakeClickablePostFilter = null;
	
	/**
	 * @var XCube_Delegate
     * @deprecated
	 */
	var $mXoopsCodePostFilter = null;
	
    /*
    * Constructor of this class
    *
    * Gets allowed html tags from admin config settings
    * <br> should not be allowed since nl2br will be used
    * when storing data.
    *
    * @access   private
    *
    * @todo Sofar, this does nuttin' ;-)
    */
    function MyTextSanitizer()
    {
		
		$this->mMakeClickablePostFilter =& new XCube_Delegate();
		$this->mMakeClickablePostFilter->register('MyTextSanitizer.MakeClickablePostFilter');
		
		$this->mXoopsCodePostFilter =& new XCube_Delegate();
		$this->mXoopsCodePostFilter->register('MyTextSanitizer.XoopsCodePostFilter');

        $root =& XCube_Root::getSingleton();
        $this->mTextFilter =& $root->getTextFilter();

    }

    /**
     * Access the only instance of this class
     *
     * @return  object
     *
     * @static
     * @staticvar   object
     */
    function &getInstance()
    {
        static $instance;
        if (!isset($instance)) {
            $instance = new MyTextSanitizer();
        }
        return $instance;
    }

    /**
     * Get the smileys
     *
     * @return  array
     */
    function getSmileys()
    {
        return $this->mTextFilter->getSmileys();
    }

    /**
     * Replace emoticons in the message with smiley images
     *
     * @param   string  $message
     *
     * @return  string
     */
    function &smiley($text)
    {
        $text = $this->mTextFilter->Smiley($text);
        return $text;
    }

    /**
     * Make links in the text clickable
     *
     * @param   string  $text
     * @return  string
     **/
    function &makeClickable(&$text)
    {
        $text = $this->mTextFilter->MakeClickable($text);

        // RaiseEvent : 'MyTextSanitizer.MakeClickablePostFilter'
        //  Delegate may convert output text with quickApplyFilter rule
        //  Args : 
        //      'string'       [I/O] : Text to convert;
        //
        $this->mMakeClickablePostFilter->call(new XCube_Ref($text));
        return $text;
    }

    /**
     * Replace XoopsCodes with their equivalent HTML formatting
     *
     * @param   string  $text
     * @param   bool    $allowimage Allow images in the text?
     *                              On FALSE, uses links to images.
     * @return  string
     **/
    function &xoopsCodeDecode(&$text, $allowimage = 1)
    {
        $text = $this->mTextFilter->ConvertXCode($text, $allowimage);
        
        // RaiseEvent : 'MyTextSanitizer.XoopsCodePostFilter'
        //  Delegate may convert output text with quickApplyFilter rule
        //  Args : 
        //      'string'       [I/O] : Text to convert;
        //      'allowimage'   [I]   : xoopsCodeDecode $allowimage parameter
        //
        $this->mXoopsCodePostFilter->call(new XCube_Ref($text), $allowimage);
        return $text;
    }

    /**
     * Convert linebreaks to <br /> tags
     *
     * @param   string  $text
     *
     * @return  string
     */
    function &nl2Br($text)
    {
        $ret = $this->mTextFilter->Nl2Br($text);
        return $ret;
    }

    /**
     * Add slashes to the text if magic_quotes_gpc is turned off.
     *
     * @param   string  $text
     * @return  string
     **/
    function &addSlashes($text)
    {
        if (!get_magic_quotes_gpc()) {
            $text = addslashes($text);
        }
        return $text;
    }
    /*
    * if magic_quotes_gpc is on, stirip back slashes
    *
    * @param    string  $text
    *
    * @return   string
    */
    function &stripSlashesGPC($text)
    {
        if (get_magic_quotes_gpc()) {
            $text = stripslashes($text);
        }
        return $text;
    }

    /*
    *  for displaying data in html textbox forms
    *
    * @param    string  $text
    * @param    bool    $forEdit (experimental)
    *
    * @return   string
    */
    function &htmlSpecialChars($text, $forEdit=false)
    {
        if (!$forEdit) {
            $ret = $this->mTextFilter->ToShow($text, true);
        } else {
            $ret = $this->mTextFilter->ToEdit($text);
        }
		return $ret;
    }

    /**
     * Reverses {@link htmlSpecialChars()}
     *
     * @param   string  $text
     * @return  string
     * @deprecated
     **/
    function &undoHtmlSpecialChars(&$text)
    {
        $ret = preg_replace(array("/&gt;/i", "/&lt;/i", "/&quot;/i", "/&#039;/i"), array(">", "<", "\"", "'"), $text);
		return $ret;
    }

    /**
     * Filters textarea form data in DB for display
     *
     * @param   string  $text
     * @param   bool    $html   allow html?
     * @param   bool    $smiley allow smileys?
     * @param   bool    $xcode  allow xoopscode?
     * @param   bool    $image  allow inline images?
     * @param   bool    $br     convert linebreaks?
     * @return  string
     **/
    function &displayTarea(&$text, $html = 0, $smiley = 1, $xcode = 1, $image = 1, $br = 1)
    {
        $text = $this->mTextFilter->ToShowTarea($text, $html, $smiley, $xcode, $image, $br, true);
        return $text;
    }

    /**
     * Filters textarea form data submitted for preview
     *
     * @param   string  $text
     * @param   bool    $html   allow html?
     * @param   bool    $smiley allow smileys?
     * @param   bool    $xcode  allow xoopscode?
     * @param   bool    $image  allow inline images?
     * @param   bool    $br     convert linebreaks?
     * @return  string
     **/
    function &previewTarea(&$text, $html = 0, $smiley = 1, $xcode = 1, $image = 1, $br = 1)
    {
        $text =& $this->stripSlashesGPC($text);
        $text = $this->mTextFilter->ToShowTarea($text, $html, $smiley, $xcode, $image, $br, true);
        return $text;
    }

    /**
     * Replaces banned words in a string with their replacements
     *
     * @param   string $text
     * @return  string
     *
     * @deprecated
     **/
    function &censorString(&$text)
    {
        if (!isset($this->censorConf)) {
            $config_handler =& xoops_gethandler('config');
            $this->censorConf =& $config_handler->getConfigsByCat(XOOPS_CONF_CENSOR);
        }
        if ($this->censorConf['censor_enable'] == 1) {
            $replacement = $this->censorConf['censor_replace'];
            foreach ($this->censorConf['censor_words'] as $bad) {
                if ( !empty($bad) ) {
                    $bad = quotemeta($bad);
                    $patterns[] = "/(\s)".$bad."/siU";
                    $replacements[] = "\\1".$replacement;
                    $patterns[] = "/^".$bad."/siU";
                    $replacements[] = $replacement;
                    $patterns[] = "/(\n)".$bad."/siU";
                    $replacements[] = "\\1".$replacement;
                    $patterns[] = "/]".$bad."/siU";
                    $replacements[] = "]".$replacement;
                    $text = preg_replace($patterns, $replacements, $text);
                }
            }
        }
        return $text;
    }


    /**#@+
     * Sanitizing of [code] tag
     */
    function codePreConv($text, $xcode = 1) {
        if($xcode != 0){
            $text = $this->mTextFilter->PreConvertXCode($text, $xcode);
        }
        return $text;
    }

    function codeConv($text, $xcode = 1, $image = 1){
        if($xcode != 0){
            $text = $this->mTextFilter->PostConvertXCode($text, $xcode);
        }
        return $text;
    }

##################### Deprecated Methods ######################

    /**#@+
     * @deprecated
     */
    function sanitizeForDisplay($text, $allowhtml = 0, $smiley = 1, $bbcode = 1)
    {
        $text = $this->mTextFilter->ToShowTarea($text, $allowhtml, $smiley, $bbcode, 1, 1, true);
        return $text;
    }

    function sanitizeForPreview($text, $allowhtml = 0, $smiley = 1, $bbcode = 1)
    {
        $text = $this->oopsStripSlashesGPC($text);
        $text = $this->mTextFilter->ToShowTarea($text, $allowhtml, $smiley, $bbcode, 1, 1, true);
        return $text;
    }

    function makeTboxData4Save($text)
    {
        return $this->addSlashes($text);
    }

    function makeTboxData4Show($text, $smiley=0)
    {
        $text = $this->mTextFilter->ToShow($text, true);
        return $text;
    }

    function makeTboxData4Edit($text)
    {
        return $this->mTextFilter->ToEdit($text);
    }

    function makeTboxData4Preview($text, $smiley=0)
    {
        $text = $this->stripSlashesGPC($text);
        $text = $this->mTextFilter->ToShow($text, true);
        return $text;
    }

    function makeTboxData4PreviewInForm($text)
    {
        $text = $this->stripSlashesGPC($text);
        return $this->mTextFilter->ToEdit($text);
    }

    function makeTareaData4Save($text)
    {
        return $this->addSlashes($text);
    }

    function &makeTareaData4Show(&$text, $html=1, $smiley=1, $xcode=1)
    {
        $ret = $this->displayTarea($text, $html, $smiley, $xcode);
        return $ret;
    }

    function makeTareaData4Edit($text)
    {
        return $this->mTextFilter->ToEdit($text);
    }

    function &makeTareaData4Preview(&$text, $html=1, $smiley=1, $xcode=1)
    {
        $ret = $this->previewTarea($text, $html, $smiley, $xcode);
        return $ret;
    }

    function makeTareaData4PreviewInForm($text)
    {
        //if magic_quotes_gpc is on, do stipslashes
        $text = $this->stripSlashesGPC($text);
        return $this->mTextFilter->ToEdit($text);
    }

    function makeTareaData4InsideQuotes($text)
    {
        return $this->mTextFilter->ToShow($text, true);
    }

    function &oopsStripSlashesGPC($text)
    {
        $ret = $this->stripSlashesGPC($text);
        return $ret;
    }

    function &oopsStripSlashesRT($text)
    {
        if (get_magic_quotes_runtime()) {
            $text =& stripslashes($text);
        }
        return $text;
    }

    function &oopsAddSlashes($text)
    {
        $ret = $this->addSlashes($text);
        return $ret;
    }

    function &oopsHtmlSpecialChars($text)
    {
        $ret = $this->mTextFilter->ToShow($text, true);
        return $ret;
    }

    function &oopsNl2Br($text)
    {
        $ret = $this->nl2br($text);
        return $ret;
    }
    /**#@-*/
}
?>