<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/class/template.php";

define("MODINSTALL_LOGTYPE_REPORT", "report");
define("MODINSTALL_LOGTYPE_WARNING", "warning");
define("MODINSTALL_LOGTYPE_ERROR", "error");

/**
 * A temporary log class.
 */
class Legacy_ModuleUtilsSimpleLog
{
	var $mFetalErrorFlag = false;
	var $mMessages = array();

	function add($msg)
	{
		$this->mMessages[] = array('type' => MODINSTALL_LOGTYPE_REPORT, 'message' => $msg);
	}

	function addReport($msg)
	{
		$this->add($msg);
	}
	
	function addWarning($msg)
	{
		$this->mMessages[] = array('type' => MODINSTALL_LOGTYPE_WARNING, 'message' => $msg);
	}

	function addError($msg)
	{
		$this->mMessages[] = array('type' => MODINSTALL_LOGTYPE_ERROR, 'message' => $msg);
		$this->mFetalErrorFlag = true;
	}
	
	function hasError()
	{
		return $this->mFetalErrorFlag;
	}
}

/**
 * @brief Old utility class with static methods for installation.
 * 
 * This provides static methods for the module installation. Methods of this
 * class may move to base class of installers. 
 * 
 * @deprecated see Legacy_ModuleInstallUtils
 */
class Legacy_ModuleUtils
{
    /**
     * Merge existing block XoopsBlock object and new XoopsBlock object from xoops_verion
     * @param $oldBlock XoopsBlock
     * @param $newBlock XoopsBlock
     * @param $changedFlag bool
     * @return XoopsBlock
     * 
     * @deprecated
     */
	function &mergeBlockObject(&$oldBlock, &$newBlock, &$changedFlag)
    {
        $blockObj =& $oldBlock->xoopsClone();
        $blockObj->unsetNew();
        
		$changedFlag = false;
		$checkValues = array('name', 'func_file', 'show_func', 'edit_func', 'template');
		foreach($checkValues as $checkValue) {
		    if ($newBlock->getVar($checkValue) != $oldBlock->getVar($checkValue)) {
		        $blockObj->setVar($checkValue, $newBlock->getVar($checkValue));
		        $changedFlag |= true;
		    }
		}

		$old_options=explode("|",$oldBlock->getVar('options'));
		$new_options=explode("|",$newBlock->getVar('options'));
		if (count($new_options) > count($old_options)) {
	        $changedFlag |= true;
		    for ($i=count($old_options); $i<count($new_options); $i++) {
		        $old_options[$i] = $old_options[$i];
		    }
		    $blockObj->setVar('options', implode("|", $old_options));
		} else if (count($new_options) < count($old_options)) {
	        $changedFlag |= true;
		    $blockObj->setVar('options', $newBlock->getVar('options'));
		}
		
		return $blockObj;
    }

	

	
}

?>