<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_LEGACY_PATH . "/admin/class/ModuleUpdater.class.php";

class Legacy_ModuleUpdateFramework extends Legacy_ModuleUpdater
{
	/**
	 * This is an array of milestone version informations. Key is a version
	 * number. Value is a method name called by execute().
	 * 
	 * Format:
	 * {version} => {methodName}
	 * 
	 * Example:
	 * var $_mMilestone = array('020' => 'update020', '025' => 'update025');
	 * 
	 * @access protected
	 */
	var $_mMilestone = array();
	
	/**
	 * @access protected
	 */
	var $_mTargetVersion = 0;

	/**
	 * @access protected
	 */	
	var $_mIsEnableFramework = false;
	
	function &loadModuleObject($dirname)
	{
		$ret = null;
		
		$module =& parent::loadModuleObject($dirname);
		if (!is_object($module)) {
			return $ret;
		}
		
		ksort($this->_mMilestone);
		
		foreach ($this->_mMilestone as $version => $value) {
			if ($version > $this->mPreVersion) {
				$this->_mTargetVersion = $version;
				$this->_mIsEnableFramework = true;
				return $module;
			}
		}
		
		$this->_mTargetVersion = intval($module->modinfo['version'] * 100);
		
		return $module;
	}

	function _installModule()
	{
		$moduleHandler =& xoops_gethandler('module');
		$this->mModule->set('version', $this->_mTargetVersion);
		if (!$moduleHandler->insert($this->mModule)) {
			$this->mLog->addError("*Could not install module information*");
			return false;
		}

		return true;
	}
	
	function execute()
	{
		if ($this->_mIsEnableFramework) {
			$this->mModule =& $this->loadModuleObject($this->mDirname);
			
			if (!is_object($this->mModule)) {
				$this->_processReport();
				return false;
			}
			
			$method = $this->_mMilestone[$this->_mTargetVersion];

			if (is_callable(array($this, $method))) {
				$this->$method();
				
				$this->_processReport();
		
				return true;
			}
			else {
				//
				// TODO need error message.
				//
				$this->mLog->addError('Update framework is a wrong.');
				return false;
			}
		}
		else {
			parent::execute();
		}
	}
}


?>