<?php
/**
 * @package Legacy
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_LEGACY_PATH . "/admin/actions/AbstractModuleInstallAction.class.php";
require_once XOOPS_LEGACY_PATH . "/admin/class/ModuleUpdater.class.php";
require_once XOOPS_LEGACY_PATH . "/admin/class/ModuleUpdateFramework.class.php";
require_once XOOPS_LEGACY_PATH . "/admin/forms/ModuleUpdateForm.class.php";

class Legacy_ModuleUpdateAction extends Legacy_AbstractModuleInstallAction
{
	/**
	 * @var XCube_Delegate
	 */
	var $mUpdateSuccess = null;
	
	/**
	 * @var XCube_Delegate
	 */
	var $mUpdateFail = null;

	function Legacy_ModuleUpdateAction($flag)
	{
		parent::Legacy_AbstractModuleInstallAction($flag);
		
		$this->mUpdateSuccess =& new XCube_Delegate();
		$this->mUpdateSuccess->register('Legacy_ModuleUpdateAction.UpdateSuccess');
		
		$this->mUpdateFail =& new XCube_Delegate();
		$this->mUpdateFail->register('Legacy_ModuleUpdateAction.UpdateFail');
	}

	function &_getInstaller($dirname)
	{
		$installer =& new Legacy_ModuleUpdater($dirname);
		return $installer;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_ModuleUpdateForm();
		$this->mActionForm->prepare();
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$renderer)
	{
		if (!$this->mLog->hasError()) {
			$this->mUpdateSuccess->call(new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
			XCube_DelegateUtils::call('Legacy.Admin.Event.ModuleUpdate.' . ucfirst($this->mModuleObject->get('dirname') . '.Success'), new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
		}
		else {
			$this->mUpdateFail->call(new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
			XCube_DelegateUtils::call('Legacy.Admin.Event.ModuleUpdate.' . ucfirst($this->mModuleObject->get('dirname') . '.Fail'), new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
		}
		
		$renderer->setTemplateName("module_update_success.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('log', $this->mLog->mMessages);
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("module_update.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('actionForm', $this->mActionForm);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$renderer)
	{
		$controller->executeForward("./index.php?action=ModuleList");
	}
}

?>