<?php
/**
 * @package user
 * @version $Id: UserSearchListAction.class.php,v 1.1.2.4 2006/09/25 09:41:04 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/PageNavigator.class.php";
require_once XOOPS_MODULE_PATH . "/user/class/AbstractListAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/UserSearchFilterForm.class.php";

class User_UserSearchListAction extends User_AbstractListAction
{
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('users_search');
		return $handler;
	}

	function &_getFilterForm(&$navi)
	{
		$filter =& new User_UserSearchFilterForm($navi);
		return $filter;
	}
	
	function _getBaseUrl()
	{
		return "./index.php?action=UserSearchList";
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		return $this->getDefaultView($controller, $xoopsUser);
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_search_list.html");
		$render->setAttribute("objects", $this->mObjects);
		$render->setAttribute("pageNavi", $this->mNavi);
	}
}

?>
