<?php
/**
 * @package XCube
 * @version $Id: XCube_PageNavigator.class.php,v 1.1.2.9 2006/09/27 07:12:42 minahito Exp $
 */

define("XCUBE_PAGENAVI_START",1);
define("XCUBE_PAGENAVI_PERPAGE",2);

/**
 * This is a class in a semiautomatic that acquires page navigation information.  
 */
class XCube_PageNavigator
{
	var $mStart=0;
	var $mTotal=0;

	var $mPerpage = 20;
	var $mPerpageFreeze = false;
	
	var $mUrl=null;
	
	var $mPrefix = null;

	var $mExtra=array();
	
	var $mFlags=0;

	function XCube_PageNavigator($url, $total=0, $flags=0)
	{
		$this->mUrl = $url;
		$this->setTotal($total);
		$this->mFlags = $flags;
	}
	
	function fetch()
	{
		$startKey = $this->getStartKey();
		$perpageKey = $this->getPerpageKey();

		if ($this->mFlags & XCUBE_PAGENAVI_START && isset($_REQUEST[$startKey])) {
			$this->mStart = intval($_REQUEST[$startKey]);
		}

		if ($this->mFlags & XCUBE_PAGENAVI_PERPAGE && isset($_REQUEST[$perpageKey]) && !$this->mPerpageFreeze) {
			$this->mPerpage = intval($_REQUEST[$perpageKey]);
		}
	}

	function addExtra($key,$value)
	{
		$this->mExtra[$key]=$value;
	}
	
	function removeExtra($key)
	{
		if ($this->mExtra[$key]) {
			unset($this->mExtra[$key]);
		}
	}
	
	function getRenderBaseUrl($mask = null)
	{
		if ($mask == null) {
			$mask = array();
		}
		if (!is_array($mask)) {
			$mask = array($mask);
		}
		
		if(count($this->mExtra) > 0) {
			$tarr=array();
			
			foreach($this->mExtra as $key=>$value) {
				if (is_array($mask) && !in_array($key, $mask)) {
					$tarr[]=$key."=".urlencode($value);
				}
			}
			
			if (count($tarr)==0) {
				return $this->mUrl;
			}
			
			if(strpos($this->mUrl,"?")!==false) {
				return $this->mUrl."&amp;".implode("&amp;",$tarr);
			}
			else {
				return $this->mUrl."?".implode("&amp;",$tarr);
			}
		}
		
		return $this->mUrl;
	}
	
	/**
	 * Return url string for navigation. The return value is lose start value.
	 * The user need to add start value. For example, It is "$navi->getRenderUrl().'20'".
	 * This method name is bad. I must rename this.
	 * @return string
	 */
	function getRenderUrl($mask = null)
	{
		if ($mask != null && !is_array($mask)) {
			$mask = array($mask);
		}
		
		$demiliter = "?";
		$url = $this->getRenderBaseUrl($mask);
		
		if(strpos($url,"?")!==false) {
			$demiliter = "&amp;";
		}
		
		return $url . $demiliter . $this->getStartKey() . "=";
	}
	
	/**
	 * Return url string for sort. The return value is complete style.
	 */
	function renderSortUrl($mask = null)
	{
		return $this->getRenderUrl($mask) . $this->mStart;
	}

	function setStart($start)
	{
		$this->mStart = intval($start);
	}
	
	function getStart()
	{
		return $this->mStart;
	}
	
	function setTotal($total)
	{
		$this->mTotal = intval($total);
	}
	
	function getTotal()
	{
		return $this->mTotal;
	}
	
	function setPerpage($perpage)
	{
		$this->mPerpage = intval($perpage);
	}
	
	function freezePerpage()
	{
		$this->mPerpageFreeze = true;
	}
	
	function getPerpage()
	{
		return $this->mPerpage;
	}

	function setPrefix($prefix)
	{
		$this->mPrefix = $prefix;
	}
	
	function getPrefix()
	{
		return $this->mPrefix;
	}

	function getStartKey()
	{
		return $this->mPrefix . "start";
	}

	function getPerpageKey()
	{
		return $this->mPrefix . "perpage";
	}
}

?>