<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionStrategy.class.php";

define ("USER_FRAME_PERFORM_SUCCESS", 1);
define ("USER_FRAME_PERFORM_FAIL", 2);
define ("USER_FRAME_INIT_SUCCESS", 3);

define ("USER_FRAME_VIEW_NONE", 1);
define ("USER_FRAME_VIEW_SUCCESS", 2);
define ("USER_FRAME_VIEW_ERROR", 3);
define ("USER_FRAME_VIEW_INDEX", 4);
define ("USER_FRAME_VIEW_INPUT", 5);
define ("USER_FRAME_VIEW_PREVIEW", 6);
define ("USER_FRAME_VIEW_CANCEL", 7);

class User_ActionFrame extends XCube_ActionStrategy
{
	var $mActionName = null;
	var $mAction = null;
	var $mAdminFlag = null;

	function User_ActionFrame($admin)
	{
		$this->mAdminFlag = $admin;
	}

	function setActionName($name)
	{
		$this->mActionName = $name;
	}

	function execute(&$controller)
	{
		if (!preg_match("/^\w+$/", $this->mActionName)) {
			die();
		}
		
		//
		// Create action object by mActionName
		//
		$className = "User_" . ucfirst($this->mActionName) . "Action";
		$fileName = ucfirst($this->mActionName) . "Action";
		if ($this->mAdminFlag) {
			$fileName = XOOPS_MODULE_PATH . "/user/admin/actions/${fileName}.class.php";
		}
		else {
			$fileName = XOOPS_MODULE_PATH . "/user/actions/${fileName}.class.php";
		}
	
		if (!file_exists($fileName)) {
			die();
		}
	
		require_once $fileName;
	
		if (class_exists($className)) {
			$this->mAction =& new $className();
		}
	
		if (!is_object($this->mAction)) {
			die();
		}
	
		if ($this->mAction->isSecure() && !is_object($controller->getXoopsUser())) {
			//
			// error
			//
			
			die("TODO");
		}
		
		$this->mAction->prepare($controller, $controller->getXoopsUser(), $controller->mModuleController->mConfig);
	
		if (!$this->mAction->hasPermission($controller, $controller->getXoopsUser(), $controller->mModuleController->mConfig)) {
			//
			// error
			//
			
			die("TODO");
		}
	
		if (xoops_getenv("REQUEST_METHOD") == "POST") {
			$viewStatus = $this->mAction->execute($controller, $controller->getXoopsUser());
		}
		else {
			$viewStatus = $this->mAction->getDefaultView($controller, $controller->getXoopsUser());
		}
	
		switch($viewStatus) {
			case USER_FRAME_VIEW_SUCCESS:
				$this->mAction->executeViewSuccess($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case USER_FRAME_VIEW_ERROR:
				$this->mAction->executeViewError($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case USER_FRAME_VIEW_INDEX:
				$this->mAction->executeViewIndex($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case USER_FRAME_VIEW_INPUT:
				$this->mAction->executeViewInput($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
				
			case USER_FRAME_VIEW_PREVIEW:
				$this->mAction->executeViewPreview($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
				
			case USER_FRAME_VIEW_CANCEL:
				$this->mAction->executeViewCancel($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		}
	}
}

class User_Action
{
	function User_Action()
	{
	}
	
	function isSecure()
	{
		return false;
	}
	
	function hasPermission(&$controller, &$xoopsUser, $moduleConfig)
	{
		return true;
	}

	function prepare(&$controller, &$xoopsUser, &$moduleConfig)
	{
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		return USER_FRAME_VIEW_NONE;
	}

	function execute(&$controller, &$xoopsUser)
	{
		return USER_FRAME_VIEW_NONE;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewPreview(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
	}
}

?>
