<?php

if (!defined("XOOPS_ROOT_PATH")) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_Service.class.php";

class Legacy_NuSoapLoader extends XCube_ActionFilter
{
	function preFilter()
	{
		require_once XOOPS_ROOT_PATH . "/modules/base/lib/nusoap/nusoap.php";
		$this->mController->mRoot->mDelegateManager->add('XCube_ServiceManager.CreateClient', 'Legacy_NuSoapLoader::createClient');
	}
	
	function createClient(&$client, $service)
	{
		if (is_object($client) || !is_object($service)) {
			return;
		}

		if ($service->isOuterService()) {		
			$client = new Legacy_SoapClient($service);
		}
		else {
			$client = new XCube_ServiceClient($service);
		}
	}
}

class Legacy_SoapClient extends XCube_AbstractServiceClient
{
	var $mClient = null;
	
	function Legacy_SoapClient(&$service)
	{
		parent::XCube_AbstractServiceClient($service);
		$this->mClient =& new soap_client($service->getWSDLUrl(), true);
	}
	
	function call()
	{
		$args = func_get_args();
		$op = array_shift($args);
		
		return $this->mClient->call($op, $args);
	}
}

?>