<?php
/**
 * @package Legacy
 * @version $Id: Legacy_BlockProcedure.class.php,v 1.1.2.1 2006/08/03 09:36:36 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) die();

require_once XOOPS_ROOT_PATH . "/class/XCube_BlockProcedure.class.php";

class Legacy_AdaptBlockProcedure extends XCube_BlockProcedure
{
	/**
	 * @access private
	 */
	var $mAdapteeBlockObject;

	var $mResultData;

	function Legacy_AdaptBlockProcedure(&$blockObject)
	{
		$this->mAdapteeBlockObject=&$blockObject;
	}

	function execute(&$controller, &$user, &$render)
	{
		$this->mResultData =& $this->mAdapteeBlockObject->buildBlock();
		$render->setAttribute("mid", $this->getId());
		
		if ($this->mAdapteeBlockObject->get('template') == null) {
			$render->setTemplateName('system_dummy.html');
			$render->setAttribute('dummy_content', $this->mResultData['content']);
		}
		else {
			$render->setTemplateName($this->mAdapteeBlockObject->get('template'));
			$render->setAttribute('block', $this->mResultData);
		}
	}
	
	function getId()
	{
		return $this->mAdapteeBlockObject->get('bid');
	}
	
	function enableCached()
	{
		return true;
	}
	
	/**
	 * Return cache time
	 * @return int
	 */
	function getCacheTime()
	{
		return $this->mAdapteeBlockObject->get('bcachetime');
	}

	function getTitle()
	{
		return $this->mAdapteeBlockObject->get('title');
	}
	
	function getEntryIndex()
	{
		return $this->mAdapteeBlockObject->getVar('side');
	}
	
	function getWeight()
	{
		return $this->mAdapteeBlockObject->get('weight');
	}
	
	function hasResult()
	{
		return !empty($this->mResultData);
	}
	
	function &getResult()
	{
		return $this->mResultData;
	}
	
	function getRenderSystemName()
	{
		return 'Legacy_RenderSystem';
	}
}

?>