<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

require_once XOOPS_MODULE_PATH . "/base/forms/SearchResultsForm.class.php";

class Legacy_SearchShowallForm extends Legacy_SearchResultsForm
{
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['mid'] =& new XCube_IntProperty('mid');
		$this->mFormProperties['uid'] =& new XCube_IntProperty('uid');
		$this->mFormProperties['andor'] =& new XCube_StringProperty('andor');
		$this->mFormProperties['query'] =& new XCube_StringProperty('query');
		$this->mFormProperties['start'] =& new XCube_IntProperty('start');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['andor'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['andor']->setDependsByArray(array('mask'));
		$this->mFieldProperties['andor']->addMessage('required', _MD_BASE_ERROR_MASK, _MD_BASE_LANG_ANDOR);
		$this->mFieldProperties['andor']->addVar('mask', '/(AND|OR)/');
	}
	
	function update(&$params)
	{
		$params['mids'][] = $this->get('mid');
		$params['queries'] = $this->mQueries;
		$params['andor'] = $this->get('andor');
		$params['maxhit'] = 20;
		$params['offset'] = $this->get('start') ? $this->get('start') : 0;
	}
}

?>
