<?php

require_once "../../../mainfile.php";
require_once XOOPS_ROOT_PATH . "/header.php";

function Legacy_modifier_css_theme($string)
{
	$infoArr = Legacy_get_ovveride_file($string, null, true);
	
	if ($infoArr['theme'] != null && $infoArr['dirname'] != null) {
		return XOOPS_THEME_URL . "/" . $infoArr['theme'] . "/modules/" . $infoArr['dirname'] . "/" . $string;
	}
	elseif ($infoArr['theme'] != null) {
		return XOOPS_THEME_URL . "/" . $infoArr['theme'] . "/" . $string;
	}
	elseif ($infoArr['dirname'] != null) {
		return XOOPS_MODULE_URL . "/" . $infoArr['dirname'] . "/admin/templates/" . $string;
	}
	
	return LEGACY_ADMIN_RENDER_FALLBACK_URL . "/" . $string;
}

$theme = isset($_GET['theme']) ? trim($_GET['theme']) : null;
$dirname = isset($_GET['dirname']) ? trim($_GET['dirname']) : null;
$file = "stylesheets/" . trim($_GET['file']);

if (strstr($theme, "..") !== false || strstr($dirname, "..") !== false || strstr($file, "..") !== false) {
	exit();
}

$smarty =& new Legacy_AdminSmarty();
$smarty->register_modifier("theme", "Legacy_modifier_css_theme");
$smarty->register_function("stylesheet", "Legacy_function_stylesheet");

if ($theme != null && $dirname != null) {
	$path = XOOPS_THEME_PATH . "/${theme}/modules/${dirname}";
}
elseif ($theme != null) {
	$path = XOOPS_THEME_PATH . "/" .$theme;
}
elseif ($dirname != null) {
	$path = XOOPS_MODULE_PATH . "/${dirname}/admin/templates";
}
else {
	$path = LEGACY_ADMIN_RENDER_FALLBACK_PATH;
}

$smarty->template_dir = $path;
$smarty->setModulePrefix('_css_' . $theme);
$result=$smarty->fetch("file:" . $file);

header('Content-Type:text/css;');
print $result;

?>