<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_BASE_PATH."/admin/class/AbstractModuleInstaller.class.php";

class Legacy_ModuleUninstaller extends Legacy_AbstractModuleInstaller
{
	/**
	 * @var XCube_Delegate
	 */
	var $mProcessScript = null;
	
	function Legacy_ModuleUninstaller($dirname)
	{
		parent::Legacy_AbstractModuleInstaller($dirname);
		
		$this->mProcessScript =& new XCube_Delegate();
		$this->mProcessScript->register('Legacy_ModuleUninstaller.ProcessScript');
	}
	
	/**
	 * Load xoops module object that isn't installed and return it.
	 * @static
	 * @access public
	 * @param $dirname string
	 * @return XoopsModule
	 */
	function &loadModuleObject($dirname)
	{
		$error = null;

		$moduleHandler =& xoops_gethandler('module');
		$module =& $moduleHandler->getByDirname($dirname);

		if (!is_object($module)) {
			$this->mLog->addError(_AD_BASE_ERROR_MODULE_NOT_FOUND);
			return $error;
		}
		
		if ($module->getVar('isactive') != 0) {
			$this->mLog->addError(_AD_BASE_ERROR_CASE_OF_ACTIVE_MODULE);
			return $error;
		}

		return $module;
	}
	
	/**
	 * Delete module information from XOOPS database because this class is uninstaller.
	 */
	function _installModule()
	{
		$moduleHandler =& xoops_gethandler('module');
		if (!$moduleHandler->delete($this->mModule)) {
			$this->mLog->addError(_AD_BASE_ERROR_DELETE_MODULEINFO_FROM_DB);
		}
		else {
			$this->mLog->addReport(_AD_BASE_MESSAGE_DELETE_MODULEINFO_FROM_DB);
		}
	}

	/**
	 * Drop table because this class is uninstaller.
	 */
	function _installTable()
	{
		$root =& XCube_Root::getSingleton();
		$db =& $root->mController->getDB();

		$tables = $this->mModule->getInfo('tables');
		if ($tables != false && is_array($tables)) {
			foreach($tables as $table) {

				// TODO Do we need to check reserved core tables?

				$sql = "DROP TABLE " . $db->prefix($table);
				if ($db->query($sql)) {
					$this->mLog->addReport(XCube_Utils::formatMessage(_AD_BASE_MESSAGE_DROP_TABLE, $db->prefix($table)));
				}
				else {
					$this->mLog->addError(XCube_Utils::formatMessage(_AD_BASE_ERROR_DROP_TABLE, $db->prefix($table)));
				}
			}
		}
	}

	/**
	 * Delete template because this class is uninstaller.
	 */
	function _installTemplate()
	{
		$tplHandler =& xoops_gethandler('tplfile');

		$deleteTemplates =& $tplHandler->find(null, 'module', $this->mModule->getVar('mid'));
		
		foreach($deleteTemplates as $tpl) {
			if (!$tplHandler->delete($tpl)) {
				$this->mLog->addError(XCube_Utils::formatMessage(_AD_BASE_ERROR_TEMPLATE_UNINSTALLED, $tpl->getVar('tpl_file')));
			}
		}
	}

	/**
	 * Delete all of module's blocks.
	 */
	function _installBlock()
	{
		$blockHandler =& xoops_gethandler('block');
		$criteria = new Criteria('mid', $this->mModule->getVar('mid'));

		$blocks =& $blockHandler->getObjectsDirectly($criteria);
		
		$gpermHandler =& xoops_gethandler('groupperm');
		foreach ($blocks as $block) {
			$blockHandler->delete($block);
			$this->mLog->addReport(XCube_Utils::formatMessage(_AD_BASE_MESSAGE_BLOCK_HAS_BEEN_UNINSTALLED, $block->get('name')));

			//
			// delete permission
			//
			$criteria =& new CriteriaCompo();
			$criteria->add(new Criteria('gperm_name', 'block_read'));
			$criteria->add(new Criteria('gperm_itemid', $block->getVar('bid')));
			$criteria->add(new Criteria('gperm_modid', 1));
			$gpermHandler->deleteAll($criteria);
		}

		$tplHandler =& xoops_gethandler('tplfile');
		$criteria =& new Criteria('tpl_module', $this->mModule->getVar('dirname'));
		if(!$tplHandler->deleteAll($criteria)) {
			$this->mLog->addError(XCube_Utils::formatMessage(_AD_BASE_ERROR_COULD_NOT_DELETE_BLOCK_TEMPLATES, $tplHandler->db->error()));
		}
	}

	function _installPreference()
	{
		Legacy_ModuleUtils::deleteAllConfigs($this->mModule, $this->mLog);
	}

	function _processScript()
	{
		$installScript = trim($this->mModule->getInfo('onUninstall'));
		if ($installScript != false) {
			require_once XOOPS_MODULE_PATH . "/" . $this->mModule->getVar('dirname') . "/" . $installScript;
			$funcName = 'xoops_module_uninstall_' . $this->mModule->getVar('dirname');
			if (function_exists($funcName)) {
				if (!call_user_func($funcName, $this->mModule)) {
					$this->mLog->addError(XCube_Utils::formatMessage(_AD_BASE_ERROR_FAILED_TO_EXECUTE_CALLBACK, $funcName));
				}
			}
		}
		
		$this->mProcessScript->call(new XCube_Ref($this->mModule), new XCube_Ref($this->mLog));
	}
	
	function _processReport()
	{
		if (!$this->mLog->hasError()) {
			$this->mLog->add(XCube_Utils::formatMessage(_AD_BASE_MESSAGE_UNINSTALLATION_MODULE_SUCCESSFUL, $this->mModule->get('name')));
		}
		else {
			if (is_object($this->mModule)) {
				$this->mLog->addError(XCube_Utils::formatMessage(_AD_BASE_ERROR_UNINSTALLATION_MODULE_FAILURE, $this->mModule->get('name')));
			}
			else {
				$this->mLog->addError(XCube_Utils::formatMessage(_AD_BASE_ERROR_UNINSTALLATION_MODULE_FAILURE, $this->mDirname));
			}
		}
	}
}

?>