<?php
/**
 * @package legacyRender
 * @version $Id: ThemeListAction.class.php,v 1.1.2.6 2006/07/12 07:16:44 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/legacyRender/admin/class/LegacyTheme.class.php";
require_once XOOPS_MODULE_PATH . "/legacyRender/admin/forms/ThemeSelectForm.class.php";

/**
 * This action shows the list of selectable themes to user.
 * 
 * [Notice]
 * In XOOPS Cube Legacy which can have many themes with different render-
 * systems, that one render-system has the control to change themes is wrong,
 * because this action can't list up themes of other render-systems.
 * The action to change themes should be in Legacy. And, each render-systems
 * should send theme informations through delegate-mechanism.
 * 
 * Therefore, we may move this action to Legacy module after the discussion.
 * If you want to check the concept of this strategy, see ThemeSelect preload
 * in Legacy module.
 */
class LegacyRender_ThemeListAction extends LegacyRender_Action
{
	var $mThemes = null;
	var $mObjectHandler = null;
	var $mActionForm = null;

	function prepare(&$controller, &$xoopsUser, $moduleConfig)
	{
		$this->_setupObject();
		$this->_setupActionForm();
	}
	
	function _setupObject()
	{
		$this->mObjectHandler =& xoops_getmodulehandler('theme');
		$this->mObjectHandler->updateThemeList();

		$this->mThemes =& $this->mObjectHandler->getObjects();
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new LegacyRender_ThemeSelectForm();
		$this->mActionForm->prepare();
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->mActionForm->load($this->mThemes);

		return LEGACYRENDER_FRAME_VIEW_INDEX;
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		$this->mActionForm->update($this->mThemes);

		if ($this->mActionForm->hasError()) {
			return $this->getDefaultView($controller, $xoopsUser);
		}

		//
		// save
		//
		foreach ($this->mThemes as $theme) {
			$this->mObjectHandler->insert($theme);
		}

		//
		// save selected theme.
		//
		$themeName = $this->mActionForm->getChooseTheme();
		
		if ($themeName != null) {
			$configHandler =& xoops_gethandler('config');

			$criteria =& new CriteriaCompo();
			$criteria->add(new Criteria('conf_name', 'theme_set'));
			$criteria->add(new Criteria('conf_catid', XOOPS_CONF));
			
			$configs =& $configHandler->getConfigs($criteria);

			$configs[0]->set('conf_value', $themeName);
			if ($configHandler->insertConfig($configs[0])) {
				$controller->mRoot->setThemeName($this->mActionForm->getChooseTheme());
			}
		}

		return $this->getDefaultView($controller, $xoopsUser);
	}
	
	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		foreach (array_keys($this->mThemes) as $name) {
			$this->mThemes[$name]->loadPackage();
		}
		
		$render->setTemplateName("theme_list.html");
		$render->setAttribute("themes", $this->mThemes);
		$render->setAttribute("actionForm", $this->mActionForm);
		
		$mainTheme =& $controller->getMainTheme();
		$render->setAttribute("currentThemeName", $mainTheme);
	}
}

?>