<?php
/**
 * @package Legacy
 * @version $Id: ThemeSelect.class.php,v 1.1.2.6 2006/08/02 09:38:44 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * Theme select mechanism is that base knows the method to change themes
 * without RenderSystem. So this class uses delegate to check whether the
 * specified theme is selectable. Functions should be added to this delegate in
 * constructor, because the delegate is called in preBlockFilter().
 */
class Base_ThemeSelect extends XCube_ActionFilter
{
	/**
	 * @var XCube_NewDelegate
	 */
	var $mIsSelectableTheme = null;
	
	function Base_ThemeSelect(&$controller)
	{
		//
		// TODO remove
		//
		parent::XCube_ActionFilter($controller);
		$this->mIsSelectableTheme =& new XCube_NewDelegate();
		$this->mIsSelectableTheme->register('Base_ThemeSelect.IsSelectableTheme');
	}
	
	function preBlockFilter()
	{
		if (!empty($_POST['xoops_theme_select']) && $this->_isSelectableTheme($_POST['xoops_theme_select'])) {
			$this->mController->setMainTheme($_POST['xoops_theme_select']);
			$_SESSION['xoopsUserTheme'] = $_POST['xoops_theme_select'];
		} elseif (!empty($_SESSION['xoopsUserTheme']) && $this->_isSelectableTheme($_POST['xoops_theme_select'])) {
			$this->mController->setMainTheme($_SESSION['xoopsUserTheme']);
		}
		
		$this->mController->mRoot->mDelegateManager->add("Site.CheckLogin.Success", "Base_ThemeSelect::callbackCheckLoginSuccess");
	}

	function callbackCheckLoginSuccess(&$xoopsUser)
	{
		//
		// Check Theme and set it to session.
		//
		$userTheme = $xoopsUser->get('theme');
		if (is_array($userTheme) && in_array($userTheme, $this->mController->getConfig('theme_set_allowed'))) {
			$_SESSION['xoopsUserTheme'] = $userTheme;
		}
	}
	
	function _isSelectableTheme($theme_name)
	{
		return in_array($theme_name, $this->mController->mConfig['theme_set_allowed']);
	}
}

?>