<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractFilterForm.class.php";

define('RANKS_SORT_KEY_RANK_ID', 1);
define('RANKS_SORT_KEY_RANK_TITLE', 2);
define('RANKS_SORT_KEY_RANK_MIN', 3);
define('RANKS_SORT_KEY_RANK_MAX', 4);
define('RANKS_SORT_KEY_RANK_SPECIAL', 5);
define('RANKS_SORT_KEY_RANK_IMAGE', 6);
define('RANKS_SORT_KEY_MAXVALUE', 6);

define('RANKS_SORT_KEY_DEFAULT', RANKS_SORT_KEY_RANK_ID);

class User_RanksFilterForm extends User_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		RANKS_SORT_KEY_RANK_ID => 'rank_id',
		RANKS_SORT_KEY_RANK_TITLE => 'rank_title',
		RANKS_SORT_KEY_RANK_MIN => 'rank_min',
		RANKS_SORT_KEY_RANK_MAX => 'rank_max',
		RANKS_SORT_KEY_RANK_SPECIAL => 'rank_special',
		RANKS_SORT_KEY_RANK_IMAGE => 'rank_image'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : RANKS_SORT_KEY_DEFAULT;
	
		if ($this->mSort > RANKS_SORT_KEY_MAXVALUE) {
			$this->mSort = RANKS_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['rank_id'])) {
			$this->_mCriteria->add(new Criteria('rank_id', array(XOBJ_DTYPE_INT, xoops_getrequest('rank_id'))));
		}
	
		if (isset($_REQUEST['rank_title'])) {
			$this->_mCriteria->add(new Criteria('rank_title', array(XOBJ_DTYPE_STRING, xoops_getrequest('rank_title'))));
		}
	
		if (isset($_REQUEST['rank_min'])) {
			$this->_mCriteria->add(new Criteria('rank_min', array(XOBJ_DTYPE_INT, xoops_getrequest('rank_min'))));
		}
	
		if (isset($_REQUEST['rank_max'])) {
			$this->_mCriteria->add(new Criteria('rank_max', array(XOBJ_DTYPE_INT, xoops_getrequest('rank_max'))));
		}
	
		if (isset($_REQUEST['rank_special'])) {
			$this->_mCriteria->add(new Criteria('rank_special', array(XOBJ_DTYPE_BOOL, xoops_getrequest('rank_special'))));
		}
	
		if (isset($_REQUEST['rank_image'])) {
			$this->_mCriteria->add(new Criteria('rank_image', array(XOBJ_DTYPE_STRING, xoops_getrequest('rank_image'))));
		}
	}
}

?>
