<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/class/XCube_PageNavigator.class.php";
require_once XOOPS_MODULE_PATH."/user/admin/class/Permission.class.php";
require_once XOOPS_MODULE_PATH."/user/admin/class/XoopsGroupEx.class.php";

/**
 *
 * This function keeps difficult problems that this depens on the column's block of X2 theme format.
 */
class User_GroupPropertyAction extends User_Action
{
	var $mGroup;
	var $mPermissions;
	var $mSystemPermissions;
	var $mBlockPermissions;
	
	var $mUsers;
	var $mPageNavi;

	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->_loadGroup();

		if (!is_object($this->mGroup)) {
			return USER_FRAME_VIEW_ERROR;
		}

		$root =& XCube_Root::getSingleton();
		$root->mLanguageManager->loadModuleAdminLanguage("system");
		$root->mLanguageManager->loadManifestoLanguage("system");

		//
		// Get member list
		//
		$memberHandler =& xoops_gethandler('member');

		$total = $memberHandler->getUserCountByGroup($this->mGroup->getVar('groupid'));
		$this->mPageNavi=new XCube_PageNavigator("./index.php?action=RankList",$total,XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);	// TODO get controller->getUrl() ?

		$this->mPageNavi->fetch();
		
		$this->mUsers =& $memberHandler->getUsersByGroup($this->mGroup->getVar('groupid'), true, $this->mPageNavi->getPerPage(), $this->mPageNavi->getStart());

		//
		// Get...
		//
		require_once XOOPS_ROOT_PATH . "/modules/system/constants.php";
		$fileHandler = opendir(XOOPS_ROOT_PATH . "/modules/system/admin");
		while ($file = readdir($fileHandler)) {
			$infoFile = XOOPS_ROOT_PATH . "/modules/system/admin/" . $file . "/xoops_version.php";
			if (file_exists($infoFile)) {
				require_once $infoFile;
				if (!empty($modversion['category'])) {
					$item =& new User_PermissionSystemAdminItem($modversion['category'], $modversion['name']);
					$this->mSystemPermissions[] =& new User_Permission($this->mGroup->getVar('groupid'), $item);

					unset($item);
				}
				unset($modversion);
			}
		}

		//
		// Get module list
		//
		$moduleHandler =& xoops_gethandler('module');
		$modules =& $moduleHandler->getObjects();
		
		foreach ($modules as $module) {
			$item =& new User_PermissionModuleItem($module);
			$this->mPermissions[] =& new User_Permission($this->mGroup->getVar('groupid'), $item);

			unset($module);
			unset($item);
		}

		//
		// Get block list
		//
		$blockHandler = xoops_gethandler('block');
		
		$idx = 0;
		foreach (array(0, 1, 3, 4, 5) as $side) {
			$this->mBlockPermissions[$idx] = array();
			$blocks =& $blockHandler->getAllBlocks("object", $side, null);

			foreach ($blocks as $block) {
				$item =& new User_PermissionBlockItem($block);
				$this->mBlockPermissions[$idx][] =& new User_Permission($this->mGroup->getVar('groupid'), $item);

				unset($block);
			}
			
			$idx++;
		}

		return USER_FRAME_VIEW_INDEX;
	}

	function _loadGroup()
	{
		$groupId = isset($_REQUEST['groupid']) ? intval($_REQUEST['groupid']) : 0;

		$groupHandler =& xoops_gethandler('group');
		$group =& $groupHandler->get($groupId);
		if (is_object($group)) {
			$this->mGroup =& new XoopsGroupEx($group);
		}
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$render)
	{
		$render->setTemplateName("group_property.html");
		$render->setAttribute("group",$this->mGroup);
		$render->setAttribute("modulePermissions",$this->mPermissions);
		$render->setAttribute("blockPermissions",$this->mBlockPermissions);
		$render->setAttribute("systemPermissions",$this->mSystemPermissions);
		$render->setAttribute("users",$this->mUsers);
		$render->setAttribute("pageNavi",$this->mPageNavi);
	}
}

?>