<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH."/user/class/AbstractEditAction.class.php";
require_once XOOPS_MODULE_PATH."/user/class/RegistMailBuilder.class.php";

class User_UserActivateAction extends User_AbstractEditAction
{
	function _getId()
	{
		return isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0;
	}
	
	function &_getHandler()
	{
		$handler =& xoops_gethandler('user');
		return $handler;
	}
	/**
	 *  Return false.
	 *  If a user requests dummy uid, kick out him!
	 */
	function isEnableCreate()
	{
		return false;
	}

	/**
	 *  Return false.
	 *  This action would be used by a guest user.
	 */
	function isSecure()
	{
		return false;
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		if ((!isset($_REQUEST['actkey'])) || (!$this->mObject)) {
			$controller->executeForward(XOOPS_URL.'/');
			exit();
		}
		if ($this->mObject->get('actkey') != $_REQUEST['actkey']) {
			redirect_header(XOOPS_URL, 3, _US_ACTKEYNOT);
			exit();
		} 
		if ($this->mObject->get('level') > 1) {
			redirect_header(XOOPS_URL.'/user.php', 3, _US_ACONTACT);
			exit();
		}
		
		$this->mObject->setVar('level','1');
		// Force update with GET request
		$this->mObjectHandler->insert($this->mObject,true);

		if ($this->mConfig['activation_type'] == 2) {
			$builder = new RegistAdminCommitMailBuilder();
			$director=new UserRegistMailDirector($this->mObject,$controller->getConfig(),$this->mConfig);
			$director->contruct($builder);
			$mailer=&$builder->getResult();
			if ($mailer->send()) {
				redirect_header(XOOPS_URL.'/' ,5, sprintf(_US_ACTVMAILOK, $this->mObject->getVar('uname')));
			} else {
				redirect_header(XOOPS_URL.'/' ,5, sprintf(_US_ACTVMAILNG, $this->mObject->getVar('uname')));
			}
		} else {
			redirect_header(XOOPS_URL.'/user.php' ,5,_US_ACTLOGIN);
		}
	}
}
?>
