<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractFilterForm.class.php";

define('USER_SORT_KEY_UID', 1);
define('USER_SORT_KEY_NAME', 2);
define('USER_SORT_KEY_UNAME', 3);
define('USER_SORT_KEY_EMAIL', 4);
define('USER_SORT_KEY_URL', 5);
define('USER_SORT_KEY_USER_AVATAR', 6);
define('USER_SORT_KEY_USER_REGDATE', 7);
define('USER_SORT_KEY_USER_ICQ', 8);
define('USER_SORT_KEY_USER_FROM', 9);
define('USER_SORT_KEY_USER_SIG', 10);
define('USER_SORT_KEY_USER_VIEWEMAIL', 11);
define('USER_SORT_KEY_ACTKEY', 12);
define('USER_SORT_KEY_USER_AIM', 13);
define('USER_SORT_KEY_USER_YIM', 14);
define('USER_SORT_KEY_USER_MSNM', 15);
define('USER_SORT_KEY_PASS', 16);
define('USER_SORT_KEY_POSTS', 17);
define('USER_SORT_KEY_ATTACHSIG', 18);
define('USER_SORT_KEY_RANK', 19);
define('USER_SORT_KEY_LEVEL', 20);
define('USER_SORT_KEY_THEME', 21);
define('USER_SORT_KEY_TIMEZONE_OFFSET', 22);
define('USER_SORT_KEY_LAST_LOGIN', 23);
define('USER_SORT_KEY_UMODE', 24);
define('USER_SORT_KEY_UORDER', 25);
define('USER_SORT_KEY_NOTIFY_METHOD', 26);
define('USER_SORT_KEY_NOTIFY_MODE', 27);
define('USER_SORT_KEY_USER_OCC', 28);
define('USER_SORT_KEY_BIO', 29);
define('USER_SORT_KEY_USER_INTREST', 30);
define('USER_SORT_KEY_USER_MAILOK', 31);
define('USER_SORT_KEY_MAXVALUE', 31);

define('USER_SORT_KEY_DEFAULT', USER_SORT_KEY_UID);

class User_UserFilterForm extends User_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		USER_SORT_KEY_UID => 'uid',
		USER_SORT_KEY_NAME => 'name',
		USER_SORT_KEY_UNAME => 'uname',
		USER_SORT_KEY_EMAIL => 'email',
		USER_SORT_KEY_URL => 'url',
		USER_SORT_KEY_USER_AVATAR => 'user_avatar',
		USER_SORT_KEY_USER_REGDATE => 'user_regdate',
		USER_SORT_KEY_USER_ICQ => 'user_icq',
		USER_SORT_KEY_USER_FROM => 'user_from',
		USER_SORT_KEY_USER_SIG => 'user_sig',
		USER_SORT_KEY_USER_VIEWEMAIL => 'user_viewemail',
		USER_SORT_KEY_ACTKEY => 'actkey',
		USER_SORT_KEY_USER_AIM => 'user_aim',
		USER_SORT_KEY_USER_YIM => 'user_yim',
		USER_SORT_KEY_USER_MSNM => 'user_msnm',
		USER_SORT_KEY_PASS => 'pass',
		USER_SORT_KEY_POSTS => 'posts',
		USER_SORT_KEY_ATTACHSIG => 'attachsig',
		USER_SORT_KEY_RANK => 'rank',
		USER_SORT_KEY_LEVEL => 'level',
		USER_SORT_KEY_THEME => 'theme',
		USER_SORT_KEY_TIMEZONE_OFFSET => 'timezone_offset',
		USER_SORT_KEY_LAST_LOGIN => 'last_login',
		USER_SORT_KEY_UMODE => 'umode',
		USER_SORT_KEY_UORDER => 'uorder',
		USER_SORT_KEY_NOTIFY_METHOD => 'notify_method',
		USER_SORT_KEY_NOTIFY_MODE => 'notify_mode',
		USER_SORT_KEY_USER_OCC => 'user_occ',
		USER_SORT_KEY_BIO => 'bio',
		USER_SORT_KEY_USER_INTREST => 'user_intrest',
		USER_SORT_KEY_USER_MAILOK => 'user_mailok'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : USER_SORT_KEY_DEFAULT;
	
		if ($this->mSort > USER_SORT_KEY_MAXVALUE) {
			$this->mSort = USER_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['uid'])) {
			$this->_mCriteria->add(new Criteria('uid', array(XOBJ_DTYPE_INT, xoops_getrequest('uid'))));
		}
	
		if (isset($_REQUEST['name'])) {
			$this->_mCriteria->add(new Criteria('name', array(XOBJ_DTYPE_STRING, xoops_getrequest('name'))));
		}
	
		if (isset($_REQUEST['uname'])) {
			$this->_mCriteria->add(new Criteria('uname', array(XOBJ_DTYPE_STRING, xoops_getrequest('uname'))));
		}
	
		if (isset($_REQUEST['email'])) {
			$this->_mCriteria->add(new Criteria('email', array(XOBJ_DTYPE_STRING, xoops_getrequest('email'))));
		}
	
		if (isset($_REQUEST['url'])) {
			$this->_mCriteria->add(new Criteria('url', array(XOBJ_DTYPE_STRING, xoops_getrequest('url'))));
		}
	
		if (isset($_REQUEST['user_avatar'])) {
			$this->_mCriteria->add(new Criteria('user_avatar', array(XOBJ_DTYPE_STRING, xoops_getrequest('user_avatar'))));
		}
	
		if (isset($_REQUEST['user_regdate'])) {
			$this->_mCriteria->add(new Criteria('user_regdate', array(XOBJ_DTYPE_INT, xoops_getrequest('user_regdate'))));
		}
	
		if (isset($_REQUEST['user_icq'])) {
			$this->_mCriteria->add(new Criteria('user_icq', array(XOBJ_DTYPE_STRING, xoops_getrequest('user_icq'))));
		}
	
		if (isset($_REQUEST['user_from'])) {
			$this->_mCriteria->add(new Criteria('user_from', array(XOBJ_DTYPE_STRING, xoops_getrequest('user_from'))));
		}
	
		if (isset($_REQUEST['user_viewemail'])) {
			$this->_mCriteria->add(new Criteria('user_viewemail', array(XOBJ_DTYPE_BOOL, xoops_getrequest('user_viewemail'))));
		}
	
		if (isset($_REQUEST['actkey'])) {
			$this->_mCriteria->add(new Criteria('actkey', array(XOBJ_DTYPE_STRING, xoops_getrequest('actkey'))));
		}
	
		if (isset($_REQUEST['user_aim'])) {
			$this->_mCriteria->add(new Criteria('user_aim', array(XOBJ_DTYPE_STRING, xoops_getrequest('user_aim'))));
		}
	
		if (isset($_REQUEST['user_yim'])) {
			$this->_mCriteria->add(new Criteria('user_yim', array(XOBJ_DTYPE_STRING, xoops_getrequest('user_yim'))));
		}
	
		if (isset($_REQUEST['user_msnm'])) {
			$this->_mCriteria->add(new Criteria('user_msnm', array(XOBJ_DTYPE_STRING, xoops_getrequest('user_msnm'))));
		}
	
		if (isset($_REQUEST['pass'])) {
			$this->_mCriteria->add(new Criteria('pass', array(XOBJ_DTYPE_STRING, xoops_getrequest('pass'))));
		}
	
		if (isset($_REQUEST['posts'])) {
			$this->_mCriteria->add(new Criteria('posts', array(XOBJ_DTYPE_INT, xoops_getrequest('posts'))));
		}
	
		if (isset($_REQUEST['attachsig'])) {
			$this->_mCriteria->add(new Criteria('attachsig', array(XOBJ_DTYPE_BOOL, xoops_getrequest('attachsig'))));
		}
	
		if (isset($_REQUEST['rank'])) {
			$this->_mCriteria->add(new Criteria('rank', array(XOBJ_DTYPE_INT, xoops_getrequest('rank'))));
		}
	
		if (isset($_REQUEST['level'])) {
			$this->_mCriteria->add(new Criteria('level', array(XOBJ_DTYPE_INT, xoops_getrequest('level'))));
		}
	
		if (isset($_REQUEST['theme'])) {
			$this->_mCriteria->add(new Criteria('theme', array(XOBJ_DTYPE_STRING, xoops_getrequest('theme'))));
		}
	
		if (isset($_REQUEST['timezone_offset'])) {
			$this->_mCriteria->add(new Criteria('timezone_offset', array(XOBJ_DTYPE_FLOAT, xoops_getrequest('timezone_offset'))));
		}
	
		if (isset($_REQUEST['last_login'])) {
			$this->_mCriteria->add(new Criteria('last_login', array(XOBJ_DTYPE_INT, xoops_getrequest('last_login'))));
		}
	
		if (isset($_REQUEST['umode'])) {
			$this->_mCriteria->add(new Criteria('umode', array(XOBJ_DTYPE_STRING, xoops_getrequest('umode'))));
		}
	
		if (isset($_REQUEST['uorder'])) {
			$this->_mCriteria->add(new Criteria('uorder', array(XOBJ_DTYPE_BOOL, xoops_getrequest('uorder'))));
		}
	
		if (isset($_REQUEST['notify_method'])) {
			$this->_mCriteria->add(new Criteria('notify_method', array(XOBJ_DTYPE_BOOL, xoops_getrequest('notify_method'))));
		}
	
		if (isset($_REQUEST['notify_mode'])) {
			$this->_mCriteria->add(new Criteria('notify_mode', array(XOBJ_DTYPE_BOOL, xoops_getrequest('notify_mode'))));
		}
	
		if (isset($_REQUEST['user_occ'])) {
			$this->_mCriteria->add(new Criteria('user_occ', array(XOBJ_DTYPE_STRING, xoops_getrequest('user_occ'))));
		}
	
		if (isset($_REQUEST['user_intrest'])) {
			$this->_mCriteria->add(new Criteria('user_intrest', array(XOBJ_DTYPE_STRING, xoops_getrequest('user_intrest'))));
		}
	
		if (isset($_REQUEST['user_mailok'])) {
			$this->_mCriteria->add(new Criteria('user_mailok', array(XOBJ_DTYPE_BOOL, xoops_getrequest('user_mailok'))));
		}
	}
}

?>
