<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractDeleteAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/UserAdminDeleteForm.class.php";

class User_UserDeleteAction extends User_AbstractDeleteAction
{
	function _getId()
	{
		return isset($_REQUEST['uid']) ? $_REQUEST['uid'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_gethandler('user');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new UserAdminDeleteForm();
		$this->mActionForm->prepare();
	}
	
	function _doExecute()
	{
		$handler =& xoops_gethandler('member');
		return $handler->delete($this->mObject) ? USER_FRAME_VIEW_SUCCESS
		                                        : USER_FRAME_VIEW_ERROR;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=UserList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=UserList", 1, _AD_USER_ERROR_DBUPDATE_FAILED);
	}
}

?>
