<?php
// $Id: XoopsDebugManager.class.php,v 1.1.4.6 2006/04/14 06:28:50 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if (!defined('XOOPS_ROOT_PATH')) exit();

define("XOOPS_DEBUG_OFF",0);
define("XOOPS_DEBUG_PHP",1);
define("XOOPS_DEBUG_MYSQL",2);
define("XOOPS_DEBUG_SMARTY",3);

class XoopsDebuggerManager
{
	function getInstance($debug_mode)
	{
        static $instance = array();
        if (empty($instance[$debug_mode])) {
            $instance[$debug_mode] =& XoopsDebuggerManager::_createInstance($debug_mode);
        }
        
        return $instance[$debug_mode];
	}
	
	/**
	Create XoopsDebugger instance.
	You must not communicate with this method directly.
	*/
	function &_createInstance($debug_mode)
	{
		$instance = null;
		switch($debug_mode) {
			case XOOPS_DEBUG_PHP:
				$instance = new XoopsPHPDebugger();
				break;

			case XOOPS_DEBUG_MYSQL:
				$instance = new XoopsMysqlDebugger();
				break;

			case XOOPS_DEBUG_SMARTY:
				$instance = new XoopsSmartyDebugger();
				break;
			
			case XOOPS_DEBUG_OFF:
			default:
				// @todo I can not realize abstract class to instance.
				$instance = new AbstractXoopsDebugger();
				break;
		}
		
		return $instance;
	}
}

class AbstractXoopsDebugger
{
	function XoopsDebugger()
	{
	}

	function setup()
	{
	}
	
	function isDebugRenderSystem()
	{
		return false;
	}
	
	function displayLog()
	{
	}
}

/**
This class works for "PHP debugging mode".
*/
class XoopsPHPDebugger extends AbstractXoopsDebugger
{
	function setup()
	{
		error_reporting(E_ALL);
	}
}

/**
This class works for "Mysql debugging mode".
*/
class XoopsMysqlDebugger extends AbstractXoopsDebugger
{
	function displayLog()
	{
		$xoopsLogger =& XoopsLogger::instance();
        echo '<script type="text/javascript">
        <!--//
        debug_window = openWithSelfMain("", "xoops_debug", 680, 600, true);
        ';
        $content = '<html><head><meta http-equiv="content-type" content="text/html; charset='._CHARSET.'" /><meta http-equiv="content-language" content="'._LANGCODE.'" /><title>'.htmlspecialchars($xoopsConfig['sitename']).'</title><link rel="stylesheet" type="text/css" media="all" href="'.getcss($xoopsConfig['theme_set']).'" /></head><body>'.$xoopsLogger->dumpAll().'<div style="text-align:center;"><input class="formButton" value="'._CLOSE.'" type="button" onclick="javascript:window.close();" /></div></body></html>';
        $lines = preg_split("/(\r\n|\r|\n)( *)/", $content);
        foreach ($lines as $line) {
            echo 'debug_window.document.writeln("'.str_replace('"', '\"', $line).'");';
        }
        echo '
        debug_window.document.close();
        //-->
        </script>';
	}
}


/**
This class works for "Smarty debugging mode".
*/
class XoopsSmartyDebugger extends AbstractXoopsDebugger
{
	function isDebugRenderSystem()
	{
		return true;
	}
}

?>