<?php
// $Id: Legacy_AdminModuleController.class.php,v 1.1.2.13 2006/04/02 13:06:02 nobunobu Exp $
//  ------------------------------------------------------------------------ //
//              XOOPSCube - PHP Content Management System                    //
//                  Copyright (c) 2005 XOOPSCube.org                         //
//                     <http://www.xoopscube.org/>                           //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * When user accesses admin panel, this class is be used.
 * (This class does not need to confirm it)
 */
class Legacy_AdminModuleController extends XCube_ModuleController
{
	var $mModuleObject;

	function prepare()
	{
		// Is this request module process?
		if(!$this->isModuleProcess())
			return;

		$this->_createModuleObject();


		//
		// Set config values for this module
		//
		if($this->mModuleObject!=null) {
			if($this->mModuleObject->getVar('hasconfig')==1 || $this->mModuleObject->getVar('hascomments')==1) {
				$configHandler=&xoops_gethandler('config');
				$this->mConfig=&$configHandler->getConfigsByCat(0,$this->mModuleObject->getVar('mid'));
			}
			
			if(!defined('__XC_DIRNAME__'))
				define('__XC_DIRNAME__', $this->mModuleObject->getVar('dirname'));
		}
	}

	/**
	 * Return true.
	 * When user accesses admin panel, this class is be used.
	 * @return boolean
	 */
	function isModuleProcess()
	{
		return true;
	}
	
	function isActive()
	{
		return is_object($this->mModuleObject) && $this->mModuleObject->getVar('isactive');
	}
	
	/**
	 *  Check current user's permission, return boolean as its result. If current
	 * module's dirname is Base or System, check whether current user has one of
	 * the permissions of administrator.
	 *
	 *  The check of this method is loose for Base module and System module only.
	 * But, In Base module's controller, system must check his permission strictly.
	 *
	 * @access public
	 * @todo This method re-writes $GLOBAL['xoopsUserIsAdmin']! Wmm...
	 * @return bool
	 */
	function hasPermission()
	{
		$xoopsUser =& $this->mController->getXoopsUser();

		//
		// The guest user is never administrator.
		//
		if (!is_object($xoopsUser))
			return false;

		//
		// Decide $mid as a argument for checkRight() by current module's dirname.
		//
		$mid = 0;
		if ($this->mModuleObject->get('dirname') == 'base' || $this->mModuleObject->get('dirname') == 'system') {
			$mid = -1;
		}
		else {
			$mid = $this->mModuleObject->get('mid');
		}
		
        $modPermHandler =& xoops_gethandler('groupperm');
		return $modPermHandler->checkRight('module_admin', $mid, $xoopsUser->getGroups());
	}

	/**
	 @return void
	*/
	function _createModuleObject()
	{
		$dirname=$this->_getDirname();
		$moduleHandler=&xoops_gethandler('module');

		//
		// When user accesses to root/admin.php, $dirname is null.
		//
		$module=null;
		if($dirname!=null) {
			$module=&$moduleHandler->getByDirname($dirname);
		}
		else {
			$module=&$moduleHandler->getByDirname("system");
		}
		
		//
		// We must set $xoopsModule to some module that use $xoopsModule in message catalog file.
		//
		$GLOBALS['xoopsModule']=&$module;

		$dmy=&$module->getInfo();

		//
		// Load admin menu, and add preference menu by own judge.
		//
		$module->loadAdminMenu();
		if ($module->getVar('hasnotification')
		    || ($module->getInfo('config') && is_array($module->getInfo('config')))
		    || ($module->getInfo('comments') && is_array($module->getInfo('comments')))) {
				$module->adminmenu[] = array(
					'link' => XOOPS_URL.'/modules/system/admin.php?fct=preferences&amp;op=showmod&amp;mod='.$module->getVar('mid'),
					'title' => _PREFERENCES,
					'absolute' => true);
		}
		
		$this->mModuleObject=&$module;
	}


	/**
	 * @access private
	 */
	function _getDirname()
	{
	    $url_arr = explode("/",strstr($_SERVER['REQUEST_URI'],'/modules/'));
	    return isset($url_arr[2]) ? $url_arr[2] : null;
	}
	
	function setupLanguage()
	{
		$languageManager=&$this->mController->mRoot->getLanguageManager();
		$languageManager->loadModuleAdminLanguage($this->mModuleObject->getVar('dirname'));
		$languageManager->loadManifestoLanguage($this->mModuleObject->getVar('dirname'));
	}
	
	function _processErrorModuleNotExist()
	{
		// Wmm...
		require_once XOOPS_ROOT_PATH ."/header.php";
		print "<h4>" . _MODULENOEXIST . "</h4>";
		require_once XOOPS_ROOT_PATH ."/footer.php";
		exit();
	}

	function getModuleDir()
	{
		return XOOPS_ROOT_PATH."/modules/".$this->mModuleObject->getVar('dirname')."/admin";
	}
	
	/**
	 *  Return module's directory name. This function is dependent on the design
	 * of Legacy.
	 */	
	function getDirname()
	{
		return is_object($this->mModuleObject) ? $this->mModuleObject->get('dirname') : null;
	}

	function &getXoopsModule()
	{
		return $this->mModuleObject;
	}

	function getDependRenderSystem()
	{
		return "Legacy_AdminRenderSystem";
	}
}

?>