<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/AbstractDeleteAction.class.php";
require_once XOOPS_MODULE_PATH . "/base/admin/forms/CommentAdminDeleteForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/admin/actions/CommentEditAction.class.php";

class Legacy_CommentDeleteAction extends Legacy_AbstractDeleteAction
{
	function prepare(&$controller, &$xoopsUser)
	{
		parent::prepare($controller, $xoopsUser);
				
		$root =& XCube_Root::getSingleton();
		$root->mEventManager->add("Module.Legacy.Comment.Delete.Success", new XCube_InstanceDelegate($this, "doDelete"));
	}
	
	function _getId()
	{
		return isset($_REQUEST['com_id']) ? $_REQUEST['com_id'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('comment');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_CommentAdminDeleteForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		//
		// Lazy load
		//
		$this->mObject->loadUser();
		$this->mObject->loadModule();
		$this->mObject->loadStatus();

		//
		// Load children and load their module and commentater.
		//
		$handler =& xoops_getmodulehandler('comment');
		$criteria =& new Criteria('com_pid', $this->mObject->get('com_id'));
		$children =& $handler->getObjects($criteria);

		if (count($children) > 0) {
			foreach (array_keys($children) as $key) {
				$children[$key]->loadModule();
				$children[$key]->loadUser();
			}
		}

		$render->setTemplateName("comment_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
		$render->setAttribute('children', $children);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=CommentList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=CommentList", 1, _AD_BASE_ERROR_DBUPDATE_FAILED);
	}
	
	function doDelete(&$sender, &$eventArgs)
	{
		$comment =& $eventArgs['comment'];
		
		//
		// Adjust user's post count.
		//
		if ($comment->get('com_status') != 1 && $comment->get('com_uid') > 0) {
			$handler =& xoops_gethandler('member');

			//
			// TODO We should adjust the following lines and handler's design.
			// We think we should not use getUser() and updateUserByField in XCube 2.1.
			//
			$user =& $handler->getUser($comment->get('com_uid'));
			$count = $user->get('posts');
			
			if($count > 0) {
				$handler->updateUserByField($user, 'posts', $count - 1);
			}
		}
		
		//
		// callback
		//
		$comment_config = Legacy_CommentEditAction::loadCallbackFile($comment);
		
		if ($comment_config == false) {
			return;
		}
		
		$function = $comment_config['callback']['update'];
		
		if (function_exists($function)) {
			call_user_func($function, $comment);
		}
	}
}

?>
