<?php

class UserAvatarObject extends XoopsSimpleObject
{
	function UserAvatarObject()
	{
		$this->initVar('avatar_id', XOBJ_DTYPE_INT, 0, true);
		$this->initVar('avatar_file', XOBJ_DTYPE_STRING, '', true, 30);
		$this->initVar('avatar_name', XOBJ_DTYPE_STRING, '', true, 100);
		$this->initVar('avatar_mimetype', XOBJ_DTYPE_STRING, '', true, 30);
		$this->initVar('avatar_created', XOBJ_DTYPE_INT, time(), true);
		$this->initVar('avatar_display', XOBJ_DTYPE_BOOL, '0', true);
		$this->initVar('avatar_weight', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('avatar_type', XOBJ_DTYPE_STRING, 'S', true, 1);
	}
}

class UserAvatarHandler extends XoopsObjectGenericHandler
{
	var $mTable = "avatar";
	var $mPrimary = "avatar_id";
	var $mClass = "UserAvatarObject";

	function delete(&$obj)
	{
		@unlink(XOOPS_UPLOAD_PATH . "/" . $obj->get('avatar_name'));
		return parent::delete($obj);
	}
}

?>
