<?php

require_once XOOPS_ROOT_PATH."/class/XCube_PageNavigator.class.php";
require_once XOOPS_ROOT_PATH."/modules/user/class/RankObject.class.php";
require_once XOOPS_ROOT_PATH."/modules/user/admin/forms/RankActionFilterForm.class.php";

class UserRankListAction extends UserAction
{
	var $mRankObjects=array();
	var $mFilter=null;
	var $mPageNavi=null;

	function isSecure()
	{
		return true;
	}

	function getDefaultView(&$controller,&$xoopsUser)
	{
		$this->mFilter=new RankActionFilterForm();
		$this->mFilter->fetch();

		$rankHandler = new UserRankObjectHandler($controller->mDB);
		$total=$rankHandler->countAll($this->mFilter->mSpecial);

		$this->mPageNavi=new XCube_PageNavigator("./index.php?action=RankList",$total,XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);	// TODO get controller->getUrl() ?
		$this->mPageNavi->fetch();

		$this->mRankObjects=$rankHandler->enumAll(
			$this->mFilter->mSpecial,
			$this->mFilter->getSort(),
			$this->mFilter->getOrder(),
			$this->mPageNavi->getStart(),
			$this->mPageNavi->getPerPage()
		);
		
		return USER_FRAME_VIEW_INDEX;
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderSystem)
	{
		$renderSystem->setTemplateName("user_admin_ranklist_index.html");
		$renderSystem->setAttribute("ranks",$this->mRankObjects);
		$renderSystem->setAttribute("pageNavi",$this->mPageNavi);
	}
}

?>