<?php
// $Id$
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                  Copyright (c) 2005 XOOPS Cube.org                        //
//                     <http://www.xoopscube.org/>                           //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

require_once XOOPS_ROOT_PATH."/class/XCube_ActionStrategy.class.php";

define ("PM_FRAME_PERFORM_SUCCESS",1);
define ("PM_FRAME_PERFORM_FAIL",2);
define ("PM_FRAME_INIT_SUCCESS",3);

define ("PM_FRAME_VIEW_NONE",0);
define ("PM_FRAME_VIEW_SUCCESS",1);
define ("PM_FRAME_VIEW_ERROR",2);
define ("PM_FRAME_VIEW_INDEX",3);
define ("PM_FRAME_VIEW_INPUT",4);

/**
 * This is simple frame work for misc page controller.
 * @package pm
 */
class PmActionFrame extends XCube_ActionStrategy
{
	var $mActionName="";
	var $mAction=null;
	
	function PmActionFrame()
	{
	}
	
	function setActionName($actionName)
	{
		$this->mActionName=$actionName;
	}
	
	function execute(&$controller)
	{
		if($this->mActionName==null)
			$this->mActionName=isset($_REQUEST['action']) ? trim($_REQUEST['action']) : null;

		if(!preg_match("/^\w+$/",$this->mActionName))
			die();


		//
		// Create action object by mActionName
		//
		$className="Pm".ucfirst($this->mActionName)."Action";
		$fileName=XOOPS_MODULE_PATH."/pm/actions/${className}.class.php";
		if(!file_exists($fileName))
			die();	// TODO
		
		require_once $fileName;
		if(class_exists($className))
				$this->mAction=new $className($controller,$controller->getXoopsUser());
		
		if(!is_object($this->mAction))
			die();	// TODO

		//
		// Simple Permission check
		//
		if($this->mAction->isSecure()&&!is_object($controller->getXoopsUser())) {
			$errorMessages= array(_PM_SORRY,_PM_PLZREG);
			XCube_Utils::redirectHeader(XOOPS_URL,2,$errorMessages);
		}
		
		//
		// Simple execute action switch.
		//
		if(xoops_getenv("REQUEST_METHOD")=="POST") {
			$viewStatus=$this->mAction->execute($controller,$controller->getXoopsUser());
		}
		else {
			$viewStatus=$this->mAction->getDefaultView($controller,$controller->getXoopsUser());
		}


		//
		// Call the view stab method of action by $viewStatus
		//
		switch($viewStatus) {
			case PM_FRAME_VIEW_SUCCESS:
				$this->mAction->executeViewSuccess($controller,$controller->getXoopsUser(),$controller->mRenderSystem);
				break;
			
			case PM_FRAME_VIEW_ERROR:
				$this->mAction->executeViewError($controller,$controller->getXoopsUser(),$controller->mRenderSystem);
				break;
			
			case PM_FRAME_VIEW_INDEX:
				$this->mAction->executeViewIndex($controller,$controller->getXoopsUser(),$controller->mRenderSystem);
				break;

			case PM_FRAME_VIEW_INPUT:
				$this->mAction->executeViewInput($controller,$controller->getXoopsUser(),$controller->mRenderSystem);
				break;
		}
	}
}

class PmAction
{
	var $mConfig;
	
	function PmAction(&$controller,&$xoopsUser)
	{
		$this->mConfig=$controller->mModuleController->getConfig();
	}
	
	/**
	 * @return bool
	 */
	function isSecure()
	{
		return false;
	}
	
	/**
	 * @param $controller Base_Controller
	 * @param $xoopsUser XoopsUserObject
	 */
	function getDefaultView(&$controller,&$xoopsUser)
	{
		return PM_FRAME_VIEW_NONE;
	}
	
	function execute()
	{
		return PM_FRAME_VIEW_NONE;
	}
	
	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderSystem)
	{
	}

	function executeViewInput(&$controller,&$xoopsUser,&$renderSystem)
	{
	}
}

?>