<?php

class LegacyRenderTplfileObject extends XoopsSimpleObject
{
	/**
	 * @access public
	 */
	var $Source = null;
	
	function LegacyRenderTplfileObject()
	{
		$this->initVar('tpl_id', XOBJ_DTYPE_INT, '', true);
		$this->initVar('tpl_refid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('tpl_module', XOBJ_DTYPE_STRING, '', true, 25);
		$this->initVar('tpl_tplset', XOBJ_DTYPE_STRING, '', true, 50);
		$this->initVar('tpl_file', XOBJ_DTYPE_STRING, '', true, 50);
		$this->initVar('tpl_desc', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('tpl_lastmodified', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('tpl_lastimported', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('tpl_type', XOBJ_DTYPE_STRING, '', true, 20);
	}
	
	function loadSource()
	{
		if (!is_object($this->Source)) {
			$handler =& xoops_getmodulehandler('tplsource');
			$this->Source =& $handler->get($this->get('tpl_id'));
			if (!is_object($this->Source)) {
				$this->Source =& $handler->create();
			}
		}
	}
	
	function &createClone($name)
	{
		$this->loadSource();
		
		$obj =& new LegacyRenderTplfileObject();

		$obj->set('tpl_refid', $this->get('tpl_refid'));
		$obj->set('tpl_module', $this->get('tpl_module'));

		$obj->set('tpl_tplset', $name);

		$obj->set('tpl_file', $this->get('tpl_file'));
		$obj->set('tpl_desc', $this->get('tpl_desc'));
		$obj->set('tpl_lastmodified', $this->get('tpl_lastmodified'));
		$obj->set('tpl_lastimported', $this->get('tpl_lastimported'));
		$obj->set('tpl_type', $this->get('tpl_type'));
		
		$handler =& xoops_getmodulehandler('tplsource');
		$obj->Source =& $handler->create();
		
		$obj->Source->set('tpl_source', $this->Source->get('tpl_source'));
		
		return $obj;
	}
}

class LegacyRenderTplfileHandler extends XoopsObjectGenericHandler
{
	var $mTable = "tplfile";
	var $mPrimary = "tpl_id";
	var $mClass = "LegacyRenderTplfileObject";
	
	function insert(&$obj, $force = false)
	{
		if (!parent::insert($obj, $force)) {
			return false;
		}
		
		$obj->loadSource();
		
		if (!is_object($obj->Source)) {
			return true;
		}
		else {
			$handler =& xoops_getmodulehandler('tplsource');

			if ($obj->Source->isNew()) {
				$obj->Source->set('tpl_id', $obj->get('tpl_id'));
			}

			return $handler->insert($obj->Source, $force);
		}
	}
	
	function delete(&$obj, $force)
	{
		$obj->loadSource();
		
		if (is_object($obj->Source)) {
			$handler =& xoops_getmodulehandler('tplsource');
			if (!$handler->delete($obj->Source, $force)) {
				return false;
			}
		}

		return parent::delete($obj, $force);
	}
	
	function &getRecentModifyFile($limit = 10)
	{
		$criteria = new Criteria('tpl_id', 0, '>');

		$criteria->setLimit($limit);

		$criteria->setSort('tpl_lastmodified');
		$criteria->setOrder('DESC');
		
		$objs =& $this->getObjects($criteria);
		
		return $objs;
	}
}

?>
