<?php

define('TPLFILE_SORT_KEY_DEFAULT', 0);
define('TPLFILE_SORT_KEY_TPL_ID', 1);
define('TPLFILE_SORT_KEY_TPL_REFID', 2);
define('TPLFILE_SORT_KEY_TPL_MODULE', 3);
define('TPLFILE_SORT_KEY_TPL_TPLSET', 4);
define('TPLFILE_SORT_KEY_TPL_FILE', 5);
define('TPLFILE_SORT_KEY_TPL_DESC', 6);
define('TPLFILE_SORT_KEY_TPL_LASTMODIFIED', 7);
define('TPLFILE_SORT_KEY_TPL_LASTIMPORTED', 8);
define('TPLFILE_SORT_KEY_TPL_TYPE', 9);
define('TPLFILE_SORT_KEY_MAXVALUE', 9);

class LegacyRender_TplfileFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		TPLFILE_SORT_KEY_DEFAULT => 'tpl_id',
		TPLFILE_SORT_KEY_TPL_ID => 'tpl_id',
		TPLFILE_SORT_KEY_TPL_REFID => 'tpl_refid',
		TPLFILE_SORT_KEY_TPL_MODULE => 'tpl_module',
		TPLFILE_SORT_KEY_TPL_TPLSET => 'tpl_tplset',
		TPLFILE_SORT_KEY_TPL_FILE => 'tpl_file',
		TPLFILE_SORT_KEY_TPL_DESC => 'tpl_desc',
		TPLFILE_SORT_KEY_TPL_LASTMODIFIED => 'tpl_lastmodified',
		TPLFILE_SORT_KEY_TPL_LASTIMPORTED => 'tpl_lastimported',
		TPLFILE_SORT_KEY_TPL_TYPE => 'tpl_type'
	);
	
	var $_mCriteria = null;
	
	var $_mAttributes = array();
	
	var $_mNavi = null;
	
	var $mTplset = null;
	var $mModule = null;

	function LegacyRender_TplfileFilterForm(&$navi)
	{
		$this->_mNavi =& $navi;
		$this->_mCriteria =& new CriteriaCompo();
	}

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if (abs($this->mSort) > TPLFILE_SORT_KEY_MAXVALUE) {
			$this->mSort = TPLFILE_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['tpl_module'])) {
			$this->_mNavi->addExtra('tpl_module', xoops_getrequest('tpl_module'));
			$this->_mCriteria->add(new Criteria('tpl_module', array(XOBJ_DTYPE_STRING, xoops_getrequest('tpl_module'))));
			
			$handler =& xoops_gethandler('module');
			$this->mModule =& $handler->getByDirname(xoops_getrequest('tpl_module'));
		}
	
		if (isset($_REQUEST['tpl_tplset'])) {
			$this->_mNavi->addExtra('tpl_tplset', xoops_getrequest('tpl_tplset'));
			$this->_mCriteria->add(new Criteria('tpl_tplset', array(XOBJ_DTYPE_STRING, xoops_getrequest('tpl_tplset'))));
			
			$handler =& xoops_getmodulehandler('tplset');
			$tplsets =& $handler->getObjects(new Criteria('tplset_name', xoops_getrequest('tpl_tplset')));
			if (count($tplsets) > 0) {
				$this->mTplset =& $tplsets[0];
			}
		}
	
		if (isset($_REQUEST['tpl_file'])) {
			$this->_mNavi->addExtra('tpl_file', xoops_getrequest('tpl_file'));
			$this->_mCriteria->add(new Criteria('tpl_file', array(XOBJ_DTYPE_STRING, "%" . xoops_getrequest('tpl_file') . "%"), 'LIKE'));
		}
	
		if (isset($_REQUEST['tpl_type'])) {
			$this->_mNavi->addExtra('tpl_type', xoops_getrequest('tpl_type'));
			$this->_mCriteria->add(new Criteria('tpl_type', array(XOBJ_DTYPE_STRING, xoops_getrequest('tpl_type'))));
		}

		$this->_mNavi->addExtra('sort', $this->mSort);

		//
		// check filtering criterion and if module & tplset specified mode, then remove paging function.
		//
		if ($this->mModule != null && $this->mTplset != null) {
			$this->_mNavi->setPerpage(0);
			$this->_mNavi->freezePerpage();
		}
	}

	function getSort()
	{
		$sortkey = abs($this->mSort);
		return $this->_mSortKeys[$sortkey];
	}

	function getOrder()
	{
		return ($this->mSort < 0) ? "DESC" : "ASC";
	}

	function getCriteria($start = 0, $limit = 0)
	{
		$criteria = $this->_mCriteria;
	
		$criteria->setStart($start);
		$criteria->setLimit($limit);

		$criteria->setSort($this->getSort());
		$criteria->setOrder($this->getOrder());
	
		return $criteria;
	}
}

?>
