<?php

require_once XOOPS_MODULE_PATH . "/legacyRender/admin/actions/TplsetEditAction.class.php";
require_once XOOPS_MODULE_PATH . "/legacyRender/admin/forms/TplsetCloneForm.class.php";

class LegacyRender_TplsetCloneAction extends LegacyRender_TplsetEditAction
{
	var $mCloneObject = null;
	
	function _setupObject()
	{
		parent::_setupObject();
		$this->mCloneObject =& $this->mObjectHandler->create();
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new TplsetCloneForm();
		$this->mActionForm->prepare();
	}

	function isAllowDefault()
	{
		return true;
	}

	function execute(&$controller, &$xoopsUser)
	{
		if ($this->mObject == null) {
			return LEGACYRENDER_FRAME_VIEW_ERROR;
		}
		//
		// If image is no, the data has to continue to keep his value.
		//
		$this->mActionForm->load($this->mCloneObject);

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if($this->mActionForm->hasError()) {
			return LEGACYRENDER_FRAME_VIEW_INPUT;
		}
			
		$this->mActionForm->update($this->mCloneObject);
		
		return $this->mObjectHandler->insertClone($this->mObject, $this->mCloneObject) ? LEGACYRENDER_FRAME_VIEW_SUCCESS
		                                                     : LEGACYRENDER_FRAME_VIEW_ERROR;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("tplset_clone.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=TplsetList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=TplsetList", 1, _AD_LEGACYRENDER_ERROR_DBUPDATE_FAILED);
	}
}

?>
