<?php

class SiteClose_Filter extends XCube_ActionFilter
{
	function preBlockFilter()
	{
		if($this->mController->mConfig['closesite']==1)
			$this->_processSiteClose();

		$delegate=new XCube_Delegate("SiteClose_Filter","callbackCheckLoginSuccess");
		$this->mController->mRoot->mEventManager->add("Site.CheckLogin.Success",$delegate);
	}

	function _processSiteClose()
	{
	    $accessAllowFlag = false;

		if(is_object($this->mController->mXoopsUser)) {
			foreach ($this->mController->mXoopsUser->getGroups() as $group) {
				if (in_array($group, $this->mController->mConfig['closesite_okgrp']) || XOOPS_GROUP_ADMIN == $group) {
					$allowed = true;
					break;
				}
			}
		}
		elseif(!empty($_POST['xoops_login'])) {
			// Check!
	        require_once XOOPS_ROOT_PATH.'/include/checklogin.php';
	        exit();
	    }

	    if (!$accessAllowFlag) {
	        require_once XOOPS_ROOT_PATH.'/class/template.php';
	        $xoopsTpl = new XoopsTpl();
	        $xoopsTpl->assign( array('xoops_sitename' => htmlspecialchars($this->mController->mConfig['sitename']),
	                                   'xoops_themecss' => xoops_getcss(),
	                                   'xoops_imageurl' => XOOPS_THEME_URL.'/'.$this->mController->mConfig['theme_set'].'/',
	                                   'lang_login' => _LOGIN,
	                                   'lang_username' => _USERNAME,
	                                   'lang_password' => _PASSWORD,
	                                   'lang_siteclosemsg' => $this->mController->mConfig['closesite_text']));
	        $xoopsTpl->xoops_setCaching(1);
	        $xoopsTpl->display('db:system_siteclosed.html');	///< @todo depends schema
	        exit();
	    }
	}
	
	function callbackCheckLoginSuccess(&$controller,&$eventArgs)
	{
		//
		// This check is not needed. :)
		//
		if(!is_object($eventArgs['xoopsUser']))
			return;

		$user=&$eventArgs['xoopsUser'];

		// Site close
		if($controller->getConfig('closesite')) {
			$accessAllowed=false;

			foreach($user->getGroups() as $group) {
				if(in_array($group,$controller->getConfig('closesite_okgrp') || $group==XOOPS_GROUP_ADMIN)) {
					$accessAllowed=true;
					break;
				}
			}

			if(!$accessAllowed) {
				XCube_Utils::redirectHeader(XOOPS_URL,1,_NOPERM);
			}
		}
	}
}

?>