<?php
/**
 * @version
 */

require_once XOOPS_BASE_PATH."/admin/class/ModuleUtils.class.php";

/**
 * This is a abstract class for the process of install, update and uninstall.
 */
class Legacy_AbstractModuleInstaller
{
	var $mDirname = null;

	/**
	 * XoopsModule
	 */
	var $mModule = null;

	/**
	 * Legacy_ModuleUtilsSimpleLog
	 */
	var $mLog = null;

	/**
	 * If this flag is true, never stop processing.
	 */
	var $mForceMode = false;

	function Legacy_AbstractModuleInstaller($dirname)
	{
		$this->mDirname = $dirname;
		$this->mLog = new Legacy_ModuleUtilsSimpleLog();
	}
	
	/**
	 * @return bool
	 */
	function execute()
	{
		$this->mModule =& $this->loadModuleObject($this->mDirname);
		if (!is_object($this->mModule))
			return false;

		$this->_installTable();
		if (!$this->mForceMode && $this->mLog->hasError())
			return false;

		$this->_installModule();
		if (!$this->mForceMode && $this->mLog->hasError())
			return false;

		$this->_installTemplate();
		if (!$this->mForceMode && $this->mLog->hasError())
			return false;

		$this->_installBlock();
		if (!$this->mForceMode && $this->mLog->hasError())
			return false;

		$this->_installPreference();
		if (!$this->mForceMode && $this->mLog->hasError())
			return false;
		
		$this->_processScript();

		return true;
	}

	/**
	 * Load xoops module object and return it.
	 * @static
	 * @access public
	 * @param $dirname string
	 * @return XoopsModule
	 */
	function &loadModuleObject($dirname)
	{
	}

	function _installModule()
	{
		$moduleHandler =& xoops_gethandler('module');
		if (!$moduleHandler->insert($this->mModule)) {
			$this->mLog->addError("*Could not install module information*");
			return false;
		}

		return true;
	}

	/**
	 * Create or drop tables, this function is called by own execute().
	 */
	function _installTable()
	{
	}

	/**
	 * Install or uninstall templates of this target module, this function is called by own execute().
	 */
	function _installTemplate()
	{
	}

	/**
	 * Install or uninstall blocks and their templates, this function is called by own execute().
	 */
	function _installBlock()
	{
	}
	
	/**
	 * Install or uninstall blocks and their preference, this function is called by own execute().
	 */
	function _installPreference()
	{
	}

	function _processScript()
	{
	}
	
	/**
	 * If set true, this class may never stop for error.
	 */
	function setForceMode($flag)
	{
		$this->mForceMode = $flag;
	}
	
	/**
	 * Return log instance.
	 */
	function &getLog()
	{
		return $this->mLog;
	}
	
	function hasAgree()
	{
		return false;
	}
}

?>