<?php
/**
 * @version $Id: ModuleInfoAction.class.php,v 1.1.2.1 2006/01/25 16:18:51 minahito Exp $
 */

/**
 * This action will show the information of a module specified to user.
 */
class Legacy_ModuleInfoAction extends Legacy_Action
{
	/**
	 * XoopsModule instance specified.
	 */
	var $mModuleObject = null;
	var $mInstalledFlag = false;

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$dirname = $_GET['dirname'];
		if (!preg_match("/^[a-z\_]+$/i", $dirname)) {
			return LEGACY_FRAME_VIEW_ERROR;
		}

		if (!is_dir(XOOPS_MODULE_PATH . "/" . $dirname)) {
			return LEGACY_FRAME_VIEW_ERROR;
		}

		$moduleHandler =& xoops_gethandler('module');
		$this->mModuleObject =& $moduleHandler->getByDirname($dirname);

		//
		// If a module is installed, load modinfo and go to special displaying.
		//
		if (is_object($this->mModuleObject)) {
			$this->mModuleObject->loadAdminMenu();
			$this->mModuleObject->loadInfo($dirname);
			$this->mInstalledFlag = true;
		}
		else {
			$this->mModuleObject =& $moduleHandler->create();
			$this->mModuleObject->loadInfoAsVar($dirname);
			$this->mInstalledFlag = false;
		}

		return LEGACY_FRAME_VIEW_SUCCESS;
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("module_information.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('installed', $this->mInstalledFlag);
	}

	function executeViewError(&$controller, &$xoopsUser, &$renderer)
	{
		XCube_Utils::redirectHeader('./index.php?action=ModuleList', 1, "*Module not found*");
	}
}

?>